/*
 * Decompiled with CFR 0.152.
 */
package dev.tr7zw.notenoughanimations.util;

import dev.tr7zw.notenoughanimations.versionless.NEABaseMod;
import dev.tr7zw.notenoughanimations.versionless.animations.BodyPart;
import dev.tr7zw.transition.mc.GeneralUtil;
import dev.tr7zw.transition.mc.ItemUtil;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CrossbowItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.UseAnim;

public class AnimationUtil {
    private static Item crossbow = ItemUtil.getItem((ResourceLocation)GeneralUtil.getResourceLocation((String)"minecraft", (String)"crossbow"));

    public static Set<Item> parseItemList(Collection<String> list) {
        HashSet<Item> items = new HashSet<Item>();
        Item invalid = ItemUtil.getItem((ResourceLocation)GeneralUtil.getResourceLocation((String)"minecraft", (String)"air"));
        for (String itemId : list) {
            try {
                String[] parts = itemId.split(":");
                if (parts.length != 2) {
                    NEABaseMod.LOGGER.info("Invalid item ID format (expected namespace:path): " + itemId);
                    continue;
                }
                Item item = ItemUtil.getItem((ResourceLocation)GeneralUtil.getResourceLocation((String)parts[0], (String)parts[1]));
                if (invalid == item) continue;
                items.add(item);
            }
            catch (Exception ex) {
                NEABaseMod.LOGGER.info("Unknown item to add to the list: " + itemId);
            }
        }
        return items;
    }

    public static boolean isUsingBothHands(HumanoidModel.ArmPose pose) {
        return pose == HumanoidModel.ArmPose.BOW_AND_ARROW || pose == HumanoidModel.ArmPose.CROSSBOW_CHARGE || pose == HumanoidModel.ArmPose.CROSSBOW_HOLD;
    }

    public static boolean isSwingingArm(AbstractClientPlayer player, BodyPart arm) {
        if (!player.f_20911_) {
            return false;
        }
        if (arm == BodyPart.LEFT_ARM) {
            return player.m_5737_() == HumanoidArm.LEFT && player.f_20912_ == InteractionHand.MAIN_HAND || player.m_5737_() == HumanoidArm.RIGHT && player.f_20912_ == InteractionHand.OFF_HAND;
        }
        return player.m_5737_() == HumanoidArm.RIGHT && player.f_20912_ == InteractionHand.MAIN_HAND || player.m_5737_() == HumanoidArm.LEFT && player.f_20912_ == InteractionHand.OFF_HAND;
    }

    public static HumanoidModel.ArmPose getArmPose(AbstractClientPlayer abstractClientPlayerEntity, InteractionHand hand) {
        ItemStack itemStack = abstractClientPlayerEntity.m_21120_(hand);
        if (itemStack.m_41619_()) {
            return HumanoidModel.ArmPose.EMPTY;
        }
        if (abstractClientPlayerEntity.m_7655_() == hand && abstractClientPlayerEntity.m_21212_() > 0) {
            UseAnim useAction = itemStack.m_41780_();
            if (useAction == UseAnim.BLOCK) {
                return HumanoidModel.ArmPose.BLOCK;
            }
            if (useAction == UseAnim.BOW) {
                return HumanoidModel.ArmPose.BOW_AND_ARROW;
            }
            if (useAction == UseAnim.SPEAR) {
                return HumanoidModel.ArmPose.THROW_SPEAR;
            }
            if (useAction == UseAnim.SPYGLASS) {
                return HumanoidModel.ArmPose.SPYGLASS;
            }
            if (useAction == UseAnim.CROSSBOW && hand.equals((Object)abstractClientPlayerEntity.m_7655_())) {
                return HumanoidModel.ArmPose.CROSSBOW_CHARGE;
            }
        } else if (!abstractClientPlayerEntity.f_20911_ && itemStack.m_41720_().equals(crossbow) && AnimationUtil.isChargedCrossbow(itemStack)) {
            return HumanoidModel.ArmPose.CROSSBOW_HOLD;
        }
        return HumanoidModel.ArmPose.ITEM;
    }

    public static boolean isChargedCrossbow(ItemStack item) {
        return CrossbowItem.m_40932_((ItemStack)item);
    }

    public static void applyArmTransforms(PlayerModel model, HumanoidArm arm, float pitch, float yaw, float roll) {
        ModelPart part = arm == HumanoidArm.RIGHT ? model.f_102811_ : model.f_102812_;
        part.f_104203_ = pitch;
        part.f_104204_ = yaw;
        if (arm == HumanoidArm.LEFT) {
            part.f_104204_ *= -1.0f;
        }
        part.f_104205_ = roll;
        if (arm == HumanoidArm.LEFT) {
            part.f_104205_ *= -1.0f;
        }
    }

    public static void applyTransforms(PlayerModel model, BodyPart bodyPart, float pitch, float yaw, float roll) {
        boolean mirror = false;
        switch (bodyPart) {
            case LEFT_ARM: {
                mirror = true;
                ModelPart part = model.f_102812_;
                break;
            }
            case RIGHT_ARM: {
                ModelPart part = model.f_102811_;
                break;
            }
            case LEFT_LEG: {
                mirror = true;
                ModelPart part = model.f_102814_;
                break;
            }
            case RIGHT_LEG: {
                ModelPart part = model.f_102813_;
                break;
            }
            default: {
                return;
            }
        }
        part.f_104203_ = pitch;
        part.f_104204_ = yaw;
        if (mirror) {
            part.f_104204_ *= -1.0f;
        }
        part.f_104205_ = roll;
        if (mirror) {
            part.f_104205_ *= -1.0f;
        }
    }

    public static void minMaxHeadRotation(Player livingEntity, PlayerModel model) {
        float value = AnimationUtil.legacyWrapDegrees(model.f_102808_.f_104204_);
        float min = AnimationUtil.legacyWrapDegrees(model.f_102810_.f_104204_ - 1.5707964f);
        float max = AnimationUtil.legacyWrapDegrees(model.f_102810_.f_104204_ + 1.5707964f);
        value = Math.min(value, max);
        value = Math.max(value, min);
        AnimationUtil.setHeadYRot(model, value);
    }

    public static void setHeadYRot(PlayerModel model, float value) {
        model.f_102808_.f_104204_ = value;
        model.f_102809_.f_104204_ = value;
    }

    public static float interpolateRotation(float start, float end, float amount) {
        float wrappedStart = AnimationUtil.wrapDegrees(start);
        float wrappedEnd = AnimationUtil.wrapDegrees(end);
        float diff = wrappedEnd - wrappedStart;
        if (diff > (float)Math.PI) {
            wrappedEnd -= (float)Math.PI * 2;
        } else if (diff < (float)(-Math.PI)) {
            wrappedEnd += (float)Math.PI * 2;
        }
        return AnimationUtil.wrapDegrees(wrappedStart + (wrappedEnd - wrappedStart) * amount);
    }

    public static float interpolateRotation2(float start, float end, float amount) {
        float wrappedStart = AnimationUtil.wrapDegrees2(start);
        float wrappedEnd = AnimationUtil.wrapDegrees2(end);
        float diff = wrappedEnd - wrappedStart;
        if (diff > 180.0f) {
            wrappedEnd -= 360.0f;
        } else if (diff < -180.0f) {
            wrappedEnd += 360.0f;
        }
        return AnimationUtil.wrapDegrees2(wrappedStart + (wrappedEnd - wrappedStart) * amount);
    }

    public static float lerpAngle(float delta, float start, float end) {
        float wrappedStart = AnimationUtil.wrapDegrees(start);
        float wrappedEnd = AnimationUtil.wrapDegrees(end);
        float difference = wrappedEnd - wrappedStart;
        float shortestPath = (difference + (float)Math.PI) % ((float)Math.PI * 2) - (float)Math.PI;
        return AnimationUtil.wrapDegrees(wrappedStart + shortestPath * delta);
    }

    public static float wrapDegrees(float angle) {
        return (angle + (float)Math.PI) % ((float)Math.PI * 2) - (float)Math.PI;
    }

    public static float wrapDegrees2(float angle) {
        float wrapped = (angle + 180.0f) % 360.0f;
        if (wrapped < 0.0f) {
            wrapped += 360.0f;
        }
        return wrapped - 180.0f;
    }

    public static float legacyWrapDegrees(float f) {
        float g = f % 6.283185f;
        if (g >= 3.1415925f) {
            g -= 6.283185f;
        }
        if (g < -3.1415925f) {
            g += 6.283185f;
        }
        return g;
    }
}

