/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexmodguy.alexscaves.client.render.blockentity;

import com.github.alexmodguy.alexscaves.client.render.ACRenderTypes;
import com.github.alexmodguy.alexscaves.server.block.blockentity.AmbersolBlockEntity;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.phys.Vec3;
import org.joml.Matrix3f;
import org.joml.Matrix4f;
import org.joml.Quaternionf;

public class AmbersolBlockRenderer<T extends AmbersolBlockEntity>
implements BlockEntityRenderer<T> {
    private static final Map<BlockPos, AmbersolBlockEntity> allOnScreen = new HashMap<BlockPos, AmbersolBlockEntity>();
    private static final float HALF_SQRT_3 = (float)(Math.sqrt(3.0) / 2.0);
    private static final int SHINE_R = 215;
    private static final int SHINE_G = 89;
    private static final int SHINE_B = 32;
    private static final int SHINE_CENTER_R = 255;
    private static final int SHINE_CENTER_G = 254;
    private static final int SHINE_CENTER_B = 233;

    public AmbersolBlockRenderer(BlockEntityRendererProvider.Context rendererDispatcherIn) {
    }

    public static void renderEntireBatch(LevelRenderer levelRenderer, PoseStack poseStack, int renderTick, Camera camera, float partialTick) {
        if (!allOnScreen.isEmpty()) {
            ArrayList<BlockPos> sortedPoses = new ArrayList<BlockPos>(allOnScreen.keySet());
            Collections.sort(sortedPoses, (blockPos1, blockPos2) -> AmbersolBlockRenderer.sortBlockPos(camera, blockPos1, blockPos2));
            poseStack.m_85836_();
            Vec3 cameraPos = camera.m_90583_();
            poseStack.m_85837_(-cameraPos.f_82479_, -cameraPos.f_82480_, -cameraPos.f_82481_);
            MultiBufferSource.BufferSource multibuffersource$buffersource = Minecraft.m_91087_().m_91269_().m_110104_();
            for (BlockPos pos : sortedPoses) {
                Vec3 blockAt = Vec3.m_82512_((Vec3i)pos);
                poseStack.m_85836_();
                poseStack.m_85837_(blockAt.f_82479_, blockAt.f_82480_, blockAt.f_82481_);
                AmbersolBlockRenderer.renderAt(allOnScreen.get(pos), partialTick, poseStack, (MultiBufferSource)multibuffersource$buffersource);
                poseStack.m_85849_();
            }
            poseStack.m_85849_();
        }
        allOnScreen.clear();
    }

    private static int sortBlockPos(Camera camera, BlockPos blockPos1, BlockPos blockPos2) {
        double d1 = camera.m_90583_().m_82554_(Vec3.m_82512_((Vec3i)blockPos1));
        double d2 = camera.m_90583_().m_82554_(Vec3.m_82512_((Vec3i)blockPos2));
        return Double.compare(d2, d1);
    }

    public void render(T ambersol, float partialTicks, PoseStack matrixStackIn, MultiBufferSource bufferIn, int combinedLightIn, int combinedOverlayIn) {
        if (!ambersol.m_58901_()) {
            allOnScreen.put(ambersol.m_58899_(), (AmbersolBlockEntity)((Object)ambersol));
        } else {
            allOnScreen.remove(ambersol.m_58899_());
        }
    }

    private static void renderAt(AmbersolBlockEntity ambersol, float partialTicks, PoseStack matrixStackIn, MultiBufferSource bufferIn) {
        float scale = 1.0f;
        float time = 0.0f;
        if (Minecraft.m_91087_().m_91288_() != null) {
            scale = ambersol.calculateShineScale(Minecraft.m_91087_().m_91288_().m_20318_(partialTicks));
            time = (float)Minecraft.m_91087_().m_91288_().f_19797_ + partialTicks;
        }
        if (scale > 0.0f) {
            Quaternionf camera = Minecraft.m_91087_().m_91290_().m_253208_();
            float time1 = time * ambersol.getRotSpeed() * 0.3f;
            float time2 = time * 0.1f;
            matrixStackIn.m_85836_();
            matrixStackIn.m_252781_(camera);
            VertexConsumer lightConsumer = bufferIn.m_6299_(ACRenderTypes.getAmbersolShine());
            int lights = ambersol.getLights();
            matrixStackIn.m_252781_(Axis.f_252393_.m_252977_(ambersol.getRotOffset()));
            for (int i = 0; i < lights; ++i) {
                float length = (float)(3.0 + Math.sin(time2 + (float)(i * 2))) * scale;
                float width = (float)(1.0 - (double)0.2f * Math.abs(Math.cos((double)time2 - (double)i * Math.PI * 0.5))) * scale;
                int j = 255;
                float u = 0.0f;
                float v = 0.0f;
                matrixStackIn.m_85836_();
                matrixStackIn.m_252781_(Axis.f_252393_.m_252977_(time1 - (float)i / (float)lights * 360.0f));
                PoseStack.Pose posestack$pose = matrixStackIn.m_85850_();
                Matrix4f matrix4f = posestack$pose.m_252922_();
                Matrix3f matrix3f = posestack$pose.m_252943_();
                AmbersolBlockRenderer.shineOriginVertex(lightConsumer, matrix4f, matrix3f, j, u, v);
                AmbersolBlockRenderer.shineLeftCornerVertex(lightConsumer, matrix4f, matrix3f, length, width, u, v);
                AmbersolBlockRenderer.shineRightCornerVertex(lightConsumer, matrix4f, matrix3f, length, width, u, v);
                AmbersolBlockRenderer.shineLeftCornerVertex(lightConsumer, matrix4f, matrix3f, length, width, u, v);
                matrixStackIn.m_85849_();
            }
            PoseStack.Pose posestack$pose = matrixStackIn.m_85850_();
            Matrix4f matrix4f = posestack$pose.m_252922_();
            Matrix3f matrix3f = posestack$pose.m_252943_();
            VertexConsumer lines = bufferIn.m_6299_(RenderType.m_110504_());
            matrixStackIn.m_85849_();
        }
    }

    private static void shineOriginVertex(VertexConsumer p_114220_, Matrix4f p_114221_, Matrix3f p_114092_, int p_114222_, float xOffset, float yOffset) {
        p_114220_.m_252986_(p_114221_, 0.0f, 0.0f, 0.0f).m_6122_(255, 254, 233, 230).m_7421_(xOffset + 0.5f, yOffset).m_86008_(OverlayTexture.f_118083_).m_85969_(240).m_252939_(p_114092_, 0.0f, 1.0f, 0.0f).m_5752_();
    }

    private static void shineLeftCornerVertex(VertexConsumer p_114215_, Matrix4f p_114216_, Matrix3f p_114092_, float p_114217_, float p_114218_, float xOffset, float yOffset) {
        p_114215_.m_252986_(p_114216_, -HALF_SQRT_3 * p_114218_, p_114217_, 0.0f).m_6122_(215, 89, 32, 0).m_7421_(xOffset, yOffset + 1.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(240).m_252939_(p_114092_, 0.0f, -1.0f, 0.0f).m_5752_();
    }

    private static void shineRightCornerVertex(VertexConsumer p_114224_, Matrix4f p_114225_, Matrix3f p_114092_, float p_114226_, float p_114227_, float xOffset, float yOffset) {
        p_114224_.m_252986_(p_114225_, HALF_SQRT_3 * p_114227_, p_114226_, 0.0f).m_6122_(215, 89, 32, 0).m_7421_(xOffset + 1.0f, yOffset + 1.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(240).m_252939_(p_114092_, 0.0f, -1.0f, 0.0f).m_5752_();
    }

    public int m_142163_() {
        return 256;
    }
}

