/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexmodguy.alexscaves.server.block.blockentity;

import com.github.alexmodguy.alexscaves.server.block.SirenLightBlock;
import com.github.alexmodguy.alexscaves.server.block.blockentity.ACBlockEntityRegistry;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class SirenLightBlockEntity
extends BlockEntity {
    private float onProgress;
    private float prevOnProgress;
    private float sirenRotation;
    private float prevSirenRotation;
    private int color = -1;

    public SirenLightBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ACBlockEntityRegistry.SIREN_LIGHT.get(), pos, state);
        if (((Boolean)state.m_61143_((Property)SirenLightBlock.POWERED)).booleanValue()) {
            this.onProgress = 10.0f;
            this.prevOnProgress = 10.0f;
        }
    }

    public static void tick(Level level, BlockPos blockPos, BlockState state, SirenLightBlockEntity entity) {
        entity.prevOnProgress = entity.onProgress;
        entity.prevSirenRotation = entity.sirenRotation;
        boolean powered = (Boolean)state.m_61143_((Property)SirenLightBlock.POWERED);
        if (powered && entity.onProgress < 10.0f) {
            entity.onProgress += 1.0f;
        } else if (!powered && entity.onProgress > 0.0f) {
            entity.onProgress -= 1.0f;
        }
        if (powered) {
            entity.sirenRotation += entity.onProgress * 2.0f + 0.25f;
        }
    }

    public float getOnProgress(float partialTicks) {
        return (this.prevOnProgress + (this.onProgress - this.prevOnProgress) * partialTicks) * 0.1f;
    }

    public float getSirenRotation(float partialTicks) {
        return this.prevSirenRotation + (this.sirenRotation - this.prevSirenRotation) * partialTicks;
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.color = tag.m_128451_("Color");
    }

    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128405_("Color", this.color);
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket packet) {
        if (packet != null && packet.m_131708_() != null) {
            this.color = packet.m_131708_().m_128451_("Color");
        }
    }

    public void setColor(int setTo) {
        this.color = setTo;
        this.f_58857_.m_7260_(this.m_58899_(), this.m_58900_(), this.m_58900_(), 2);
    }

    public int getColor() {
        return this.color < 0 ? 65280 : this.color;
    }

    @OnlyIn(value=Dist.CLIENT)
    public AABB getRenderBoundingBox() {
        BlockPos pos = this.m_58899_();
        return new AABB(pos.m_7918_(-3, -3, -3), pos.m_7918_(4, 4, 4));
    }

    public CompoundTag m_5995_() {
        return this.m_187482_();
    }
}

