/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexmodguy.alexscaves.server.entity.ai;

import com.github.alexmodguy.alexscaves.server.block.AbyssalAltarBlock;
import com.github.alexmodguy.alexscaves.server.block.blockentity.AbyssalAltarBlockEntity;
import com.github.alexmodguy.alexscaves.server.block.poi.ACPOIRegistry;
import com.github.alexmodguy.alexscaves.server.entity.living.DeepOneBaseEntity;
import com.github.alexmodguy.alexscaves.server.misc.ACTagRegistry;
import com.github.alexthe666.citadel.animation.IAnimatedEntity;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.List;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.village.poi.PoiManager;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;

public class DeepOneBarterGoal
extends Goal {
    private BlockPos altarPos = null;
    private DeepOneBaseEntity mob;
    private int executionCooldown = 10;
    private boolean groundTarget = false;

    public DeepOneBarterGoal(DeepOneBaseEntity mob) {
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        this.mob = mob;
    }

    public boolean m_8036_() {
        LivingEntity target = this.mob.m_5448_();
        if (!(target != null && target.m_6084_() || this.mob.getAnimation() != IAnimatedEntity.NO_ANIMATION)) {
            if (this.executionCooldown-- > 0) {
                return false;
            }
            this.executionCooldown = 150 + this.mob.m_217043_().m_188503_(100);
            BlockPos pos = null;
            if (this.mob.getLastAltarPos() != null) {
                BlockEntity blockEntity = this.mob.m_9236_().m_7702_(this.mob.getLastAltarPos());
                if (blockEntity instanceof AbyssalAltarBlockEntity) {
                    AbyssalAltarBlockEntity altar = (AbyssalAltarBlockEntity)blockEntity;
                    this.executionCooldown = 10;
                    if (altar.m_8020_(0).m_204117_(ACTagRegistry.DEEP_ONE_BARTERS)) {
                        pos = this.mob.getLastAltarPos();
                    }
                } else {
                    this.mob.setLastAltarPos(null);
                }
            }
            if (pos == null) {
                List<BlockPos> list = DeepOneBarterGoal.getNearbyAltars(this.mob.m_20183_(), (ServerLevel)this.mob.m_9236_(), 64).sorted(Comparator.comparingDouble(arg_0 -> ((BlockPos)this.mob.m_20183_()).m_123331_(arg_0))).toList();
                if (!list.isEmpty()) {
                    pos = list.get(0);
                }
            }
            if (pos != null) {
                this.altarPos = pos;
                this.mob.setLastAltarPos(this.altarPos);
                return true;
            }
        }
        return false;
    }

    public boolean m_8045_() {
        LivingEntity target = this.mob.m_5448_();
        return !(this.altarPos == null || !DeepOneBarterGoal.hasPearls(this.mob.m_9236_(), this.altarPos, false) && this.mob.getAnimation() != this.mob.getTradingAnimation() || target != null && target.m_6084_());
    }

    private static Stream<BlockPos> getNearbyAltars(BlockPos blockpos, ServerLevel world, int range) {
        PoiManager pointofinterestmanager = world.m_8904_();
        return pointofinterestmanager.m_27138_(poiTypeHolder -> poiTypeHolder.m_203565_(ACPOIRegistry.ABYSSAL_ALTAR.getKey()), blockpos2 -> DeepOneBarterGoal.hasPearls((Level)world, blockpos2, true), blockpos, range, PoiManager.Occupancy.ANY);
    }

    private static boolean hasPearls(Level world, BlockPos pos, boolean timed) {
        BlockEntity blockEntity = world.m_7702_(pos);
        if (blockEntity instanceof AbyssalAltarBlockEntity) {
            AbyssalAltarBlockEntity altar = (AbyssalAltarBlockEntity)blockEntity;
            if (timed && world.m_46467_() - altar.getLastInteractionTime() < 100L) {
                return false;
            }
            return altar.m_8020_(0).m_204117_(ACTagRegistry.DEEP_ONE_BARTERS) && altar.m_58900_().m_60734_() instanceof AbyssalAltarBlock && (Boolean)altar.m_58900_().m_61143_((Property)AbyssalAltarBlock.ACTIVE) == false;
        }
        return false;
    }

    public void m_8037_() {
        Vec3 center = Vec3.m_82512_((Vec3i)this.altarPos);
        double distance = Vec3.m_82539_((Vec3i)this.altarPos).m_82546_(this.mob.m_20182_()).m_165924_();
        if (distance < 8.0) {
            this.mob.m_21563_().m_24950_(center.f_82479_, center.f_82480_, center.f_82481_, 10.0f, (float)this.mob.m_8132_());
        }
        if (distance > 3.0) {
            this.mob.m_21573_().m_26519_((double)((float)this.altarPos.m_123341_() + 0.5f), (double)this.altarPos.m_123342_(), (double)((float)this.altarPos.m_123343_() + 0.5f), 1.0);
        } else {
            AbyssalAltarBlockEntity altar;
            this.mob.setLastAltarPos(this.altarPos);
            this.mob.setTradingLockedTime(50);
            this.mob.m_21573_().m_26573_();
            BlockEntity blockEntity = this.mob.m_9236_().m_7702_(this.altarPos);
            if (blockEntity instanceof AbyssalAltarBlockEntity && (altar = (AbyssalAltarBlockEntity)blockEntity).m_8020_(0).m_204117_(ACTagRegistry.DEEP_ONE_BARTERS) && altar.queueItemDrop(altar.m_8020_(0))) {
                this.mob.m_9236_().m_7605_((Entity)this.mob, (byte)69);
                altar.onEntityInteract((LivingEntity)this.mob, true);
                altar.m_6836_(0, ItemStack.f_41583_);
            }
        }
    }
}

