/*
 * Decompiled with CFR 0.152.
 */
package org.dimdev.dimdoors.item.door.data;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.util.LinkedList;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import org.dimdev.dimdoors.block.entity.EntranceRiftBlockEntity;
import org.dimdev.dimdoors.item.door.data.condition.Condition;
import org.dimdev.dimdoors.rift.registry.LinkProperties;
import org.dimdev.dimdoors.rift.targets.VirtualTarget;

public class RiftDataList {
    private final LinkedList<Pair<OptRiftData, Condition>> riftDataConditions;

    public static RiftDataList fromJson(JsonArray jsonArray) {
        LinkedList<Pair<JsonObject, Condition>> riftDataConditions = new LinkedList<Pair<JsonObject, Condition>>();
        for (JsonElement json : jsonArray) {
            JsonObject jsonObject = json.getAsJsonObject();
            JsonObject unbakedRiftData = jsonObject.getAsJsonObject("data");
            Condition condition = Condition.fromJson(jsonObject.getAsJsonObject("condition"));
            riftDataConditions.add((Pair<JsonObject, Condition>)new Pair((Object)unbakedRiftData, (Object)condition));
        }
        return new RiftDataList(riftDataConditions);
    }

    public RiftDataList(LinkedList<Pair<JsonObject, Condition>> riftDataConditions) {
        this.riftDataConditions = riftDataConditions.stream().map(pair -> new Pair((Object)OptRiftData.fromJson((JsonObject)pair.getFirst()), (Object)((Condition)pair.getSecond()))).collect(Collectors.toCollection(LinkedList::new));
    }

    public OptRiftData getRiftData(EntranceRiftBlockEntity rift) {
        return (OptRiftData)this.riftDataConditions.stream().filter(pair -> ((Condition)pair.getSecond()).matches(rift)).findFirst().orElseThrow(() -> new RuntimeException("Could not find any matching rift data")).getFirst();
    }

    public JsonArray toJson() {
        JsonArray jsonArray = new JsonArray();
        for (Map.Entry<OptRiftData, Condition> entry : this.riftDataConditions.stream().collect(Collectors.toMap(Pair::getFirst, Pair::getSecond)).entrySet()) {
            JsonObject unbakedRiftData = entry.getKey().toJson(new JsonObject());
            Condition condition = entry.getValue();
            JsonObject jsonInner = new JsonObject();
            jsonInner.add("data", (JsonElement)unbakedRiftData);
            jsonInner.add("condition", (JsonElement)condition.toJson(new JsonObject()));
            jsonArray.add((JsonElement)jsonInner);
        }
        return jsonArray;
    }

    public static class OptRiftData {
        private final VirtualTarget destination;
        private final Optional<LinkProperties> linkProperties;

        public static OptRiftData fromJson(JsonObject json) {
            VirtualTarget destination = Optional.of(json.get("destination")).map(JsonElement::getAsJsonObject).map(j -> (Tag)JsonOps.INSTANCE.convertTo((DynamicOps)NbtOps.f_128958_, (JsonElement)j)).map(CompoundTag.class::cast).map(VirtualTarget::fromNbt).get();
            Optional<LinkProperties> linkProperties = Optional.ofNullable(json.get("properties")).map(JsonElement::getAsJsonObject).map(j -> (Tag)JsonOps.INSTANCE.convertTo((DynamicOps)NbtOps.f_128958_, (JsonElement)j)).map(CompoundTag.class::cast).map(LinkProperties::fromNbt);
            return new OptRiftData(destination, linkProperties);
        }

        public OptRiftData(VirtualTarget destination, Optional<LinkProperties> linkProperties) {
            this.destination = destination;
            this.linkProperties = linkProperties;
        }

        public JsonObject toJson(JsonObject json) {
            Optional.of(this.destination).ifPresent(s -> json.add("destination", (JsonElement)NbtOps.f_128958_.convertTo((DynamicOps)JsonOps.INSTANCE, (Tag)VirtualTarget.toNbt(s))));
            this.linkProperties.ifPresent(s -> json.add("properties", (JsonElement)NbtOps.f_128958_.convertTo((DynamicOps)JsonOps.INSTANCE, (Tag)LinkProperties.toNbt(s))));
            return json;
        }

        public Optional<LinkProperties> getProperties() {
            return this.linkProperties;
        }

        public VirtualTarget getDestination() {
            return this.destination.copy();
        }
    }
}

