/*
 * Decompiled with CFR 0.152.
 */
package org.dimdev.dimdoors.pockets.modifier;

import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Queue;
import java.util.function.Consumer;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.LevelChunk;
import org.dimdev.dimdoors.pockets.modifier.Modifier;

public interface LazyCompatibleModifier
extends Modifier {
    public static final LinkedHashMap<ChunkPos, Queue<Consumer<ChunkAccess>>> chunkModificationQueue = new LinkedHashMap();

    public static void runQueuedModifications(LevelChunk chunk) {
        Queue tasks = (Queue)chunkModificationQueue.remove(chunk.m_7697_());
        if (tasks == null) {
            return;
        }
        Iterator iterator = tasks.iterator();
        while (iterator.hasNext()) {
            Consumer task = (Consumer)iterator.next();
            iterator.remove();
            task.accept(chunk);
        }
    }

    public static void runLeftoverModifications(Level world) {
        new HashSet<ChunkPos>(chunkModificationQueue.keySet()).forEach(chunkPos -> world.m_46865_(chunkPos.m_45615_()));
    }

    default public void queueChunkModificationTask(ChunkPos pos, Consumer<ChunkAccess> task) {
        chunkModificationQueue.compute(pos, (chunkPos, chunkTaskQueue) -> {
            if (chunkTaskQueue == null) {
                chunkTaskQueue = new LinkedList<Consumer>();
            }
            chunkTaskQueue.add(task);
            return chunkTaskQueue;
        });
    }
}

