/*
 * Decompiled with CFR 0.152.
 */
package org.dimdev.dimdoors.pockets.modifier;

import com.google.common.collect.Multimap;
import dev.architectury.registry.registries.Registrar;
import dev.architectury.registry.registries.RegistrarManager;
import dev.architectury.registry.registries.RegistrySupplier;
import java.util.Collection;
import java.util.function.Supplier;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import org.dimdev.dimdoors.DimensionalDoors;
import org.dimdev.dimdoors.api.util.ReferenceSerializable;
import org.dimdev.dimdoors.api.util.ResourceUtil;
import org.dimdev.dimdoors.pockets.PocketGenerationContext;
import org.dimdev.dimdoors.pockets.modifier.AbsoluteRiftBlockEntityModifier;
import org.dimdev.dimdoors.pockets.modifier.DimensionalDoorModifier;
import org.dimdev.dimdoors.pockets.modifier.OffsetModifier;
import org.dimdev.dimdoors.pockets.modifier.PocketEntranceModifier;
import org.dimdev.dimdoors.pockets.modifier.RelativeReferenceModifier;
import org.dimdev.dimdoors.pockets.modifier.RiftDataModifier;
import org.dimdev.dimdoors.pockets.modifier.RiftManager;
import org.dimdev.dimdoors.pockets.modifier.ShellModifier;
import org.dimdev.dimdoors.pockets.modifier.TemplateModifier;
import org.dimdev.dimdoors.world.pocket.type.Pocket;

public interface Modifier
extends ReferenceSerializable {
    public static final Registrar<ModifierType<? extends Modifier>> REGISTRY = RegistrarManager.get((String)"dimdoors").builder(DimensionalDoors.id("modifier_type"), (Object[])new ModifierType[0]).build();
    public static final String RESOURCE_STARTING_PATH = "pockets/modifier";

    public static Modifier deserialize(Tag nbt, ResourceManager manager) {
        return switch (nbt.m_7060_()) {
            case 10 -> Modifier.deserialize((CompoundTag)nbt, manager);
            case 8 -> ResourceUtil.loadReferencedResource(manager, RESOURCE_STARTING_PATH, nbt.m_7916_(), ResourceUtil.NBT_READER.andThenComposable(Tag2 -> Modifier.deserialize(Tag2, manager)));
            default -> throw new RuntimeException(String.format("Unexpected NbtType %d!", nbt.m_7060_()));
        };
    }

    public static Modifier deserialize(Tag nbt) {
        return Modifier.deserialize(nbt, null);
    }

    public static Modifier deserialize(CompoundTag nbt, ResourceManager manager) {
        ResourceLocation id = ResourceLocation.m_135820_((String)nbt.m_128461_("type"));
        return ((ModifierType)REGISTRY.get(id)).fromNbt(nbt, manager);
    }

    public static Modifier deserialize(CompoundTag nbt) {
        return Modifier.deserialize(nbt, null);
    }

    public static Tag serialize(Modifier modifier, boolean allowReference) {
        return modifier.toNbt(new CompoundTag(), allowReference);
    }

    public static Tag serialize(Modifier modifier) {
        return Modifier.serialize(modifier, false);
    }

    public Modifier fromNbt(CompoundTag var1, ResourceManager var2);

    default public Modifier fromNbt(CompoundTag nbt) {
        return this.fromNbt(nbt, null);
    }

    default public Tag toNbt(CompoundTag nbt, boolean allowReference) {
        return this.getType().toNbt(nbt);
    }

    default public Tag toNbt(CompoundTag nbt) {
        return this.toNbt(nbt, false);
    }

    public void setResourceKey(String var1);

    public String getResourceKey();

    @Override
    default public void processFlags(Multimap<String, String> flags) {
        Collection reference = flags.get((Object)"reference");
        if (reference.stream().findFirst().map(string -> string.equals("local") || string.equals("global")).orElse(false).booleanValue()) {
            this.setResourceKey(flags.get((Object)"resource_key").stream().findFirst().orElse(null));
        }
    }

    public ModifierType<? extends Modifier> getType();

    public String getKey();

    public void apply(PocketGenerationContext var1, RiftManager var2);

    public void apply(PocketGenerationContext var1, Pocket.PocketBuilder<?, ?> var2);

    public static interface ModifierType<T extends Modifier> {
        public static final RegistrySupplier<ModifierType<ShellModifier>> SHELL_MODIFIER_TYPE = ModifierType.register(DimensionalDoors.id("shell"), ShellModifier::new);
        public static final RegistrySupplier<ModifierType<DimensionalDoorModifier>> DIMENSIONAL_DOOR_MODIFIER_TYPE = ModifierType.register(DimensionalDoors.id("door"), DimensionalDoorModifier::new);
        public static final RegistrySupplier<ModifierType<Modifier>> PUBLIC_MODIFIER_TYPE = ModifierType.register(DimensionalDoors.id("pocket_entrance"), PocketEntranceModifier::new);
        public static final RegistrySupplier<ModifierType<RiftDataModifier>> RIFT_DATA_MODIFIER_TYPE = ModifierType.register(DimensionalDoors.id("rift_data"), RiftDataModifier::new);
        public static final RegistrySupplier<ModifierType<RelativeReferenceModifier>> RELATIVE_REFERENCE_MODIFIER_TYPE = ModifierType.register(DimensionalDoors.id("relative"), RelativeReferenceModifier::new);
        public static final RegistrySupplier<ModifierType<OffsetModifier>> OFFSET_MODIFIER_TYPE = ModifierType.register(DimensionalDoors.id("offset"), OffsetModifier::new);
        public static final RegistrySupplier<ModifierType<Modifier>> ABSOLUTE_RIFT_BLOCK_ENTITY_MODIFIER_TYPE = ModifierType.register(DimensionalDoors.id("block_entity"), AbsoluteRiftBlockEntityModifier::new);
        public static final RegistrySupplier<ModifierType<TemplateModifier>> TEMPLATE_MODIFIER_TYPE = ModifierType.register(DimensionalDoors.id("template"), TemplateModifier::new);

        public Modifier fromNbt(CompoundTag var1, ResourceManager var2);

        default public Modifier fromNbt(CompoundTag nbt) {
            return this.fromNbt(nbt, null);
        }

        public CompoundTag toNbt(CompoundTag var1);

        public static void register() {
        }

        public static <U extends Modifier> RegistrySupplier<ModifierType<U>> register(final ResourceLocation id, final Supplier<U> factory) {
            return REGISTRY.register(id, () -> new ModifierType<U>(){

                @Override
                public Modifier fromNbt(CompoundTag nbt, ResourceManager manager) {
                    return ((Modifier)factory.get()).fromNbt(nbt, manager);
                }

                @Override
                public CompoundTag toNbt(CompoundTag nbt) {
                    nbt.m_128359_("type", id.toString());
                    return nbt;
                }
            });
        }
    }
}

