/*
 * Decompiled with CFR 0.152.
 */
package org.dimdev.dimdoors.pockets.virtual.reference;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.TickTask;
import net.minecraft.server.level.ChunkHolder;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.chunk.LevelChunk;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.dimdev.dimdoors.DimensionalDoors;
import org.dimdev.dimdoors.api.util.math.Equation;
import org.dimdev.dimdoors.pockets.PocketGenerationContext;
import org.dimdev.dimdoors.pockets.generator.LazyPocketGenerator;
import org.dimdev.dimdoors.pockets.generator.PocketGenerator;
import org.dimdev.dimdoors.pockets.modifier.LazyCompatibleModifier;
import org.dimdev.dimdoors.pockets.modifier.LazyModifier;
import org.dimdev.dimdoors.pockets.modifier.Modifier;
import org.dimdev.dimdoors.pockets.modifier.RiftManager;
import org.dimdev.dimdoors.pockets.virtual.AbstractVirtualPocket;
import org.dimdev.dimdoors.pockets.virtual.ImplementedVirtualPocket;
import org.dimdev.dimdoors.world.pocket.type.LazyGenerationPocket;
import org.dimdev.dimdoors.world.pocket.type.Pocket;

public abstract class PocketGeneratorReference
extends AbstractVirtualPocket {
    private static final Logger LOGGER = LogManager.getLogger();
    protected String weight;
    protected Equation weightEquation;
    protected Boolean setupLoot;
    protected final List<Modifier> modifierList = Lists.newArrayList();
    protected final List<CompoundTag> addons = new ArrayList<CompoundTag>();

    private void parseWeight() {
        try {
            this.weightEquation = Equation.parse(this.weight);
        }
        catch (Equation.EquationParseException e) {
            LOGGER.debug("Defaulting to default weight equation for {}", (Object)this);
            LOGGER.debug("Exception Stacktrace", (Throwable)e);
            try {
                this.weightEquation = Equation.newEquation(Equation.parse(DimensionalDoors.getConfig().getPocketsConfig().defaultWeightEquation)::apply, stringBuilder -> stringBuilder.append(this.weight));
            }
            catch (Equation.EquationParseException equationParseException) {
                LOGGER.debug("Defaulting to default weight equation for {}", (Object)this);
                LOGGER.debug("Exception Stacktrace", (Throwable)e);
                this.weightEquation = Equation.newEquation(stringDoubleMap -> DimensionalDoors.getConfig().getPocketsConfig().fallbackWeight, stringBuilder -> stringBuilder.append(this.weight));
            }
        }
    }

    @Override
    public ImplementedVirtualPocket fromNbt(CompoundTag nbt, ResourceManager manager) {
        int i;
        ListTag modifiersNbt;
        if (nbt.m_128441_("weight")) {
            this.weight = nbt.m_128461_("weight");
            this.parseWeight();
        }
        if (nbt.m_128441_("setup_loot")) {
            this.setupLoot = nbt.m_128471_("setup_loot");
        }
        if (nbt.m_128441_("modifiers")) {
            modifiersNbt = nbt.m_128437_("modifiers", 10);
            for (i = 0; i < modifiersNbt.size(); ++i) {
                this.modifierList.add(Modifier.deserialize(modifiersNbt.m_128728_(i), manager));
            }
        }
        if (nbt.m_128441_("modifier_references")) {
            modifiersNbt = nbt.m_128437_("modifier_references", 8);
            for (Tag nbtElement : modifiersNbt) {
                this.modifierList.add(Modifier.deserialize(nbtElement, manager));
            }
        }
        if (nbt.m_128425_("addons", 9)) {
            ListTag addonsNbt = nbt.m_128437_("addons", 10);
            for (i = 0; i < addonsNbt.size(); ++i) {
                this.addons.add(addonsNbt.m_128728_(i));
            }
        }
        return this;
    }

    @Override
    protected CompoundTag toNbtInternal(CompoundTag nbt, boolean allowReference) {
        if (this.weight != null) {
            nbt.m_128359_("weight", this.weight);
        }
        if (this.setupLoot != null) {
            nbt.m_128379_("setup_loot", this.setupLoot.booleanValue());
        }
        ListTag modifiersNbt = new ListTag();
        for (Modifier modifier : this.modifierList) {
            modifiersNbt.add((Object)modifier.toNbt(new CompoundTag()));
        }
        if (modifiersNbt.size() > 0) {
            nbt.m_128365_("modifiers", (Tag)modifiersNbt);
        }
        ListTag addonsNbt = new ListTag();
        addonsNbt.addAll(this.addons);
        if (addonsNbt.size() > 0) {
            nbt.m_128365_("addons", (Tag)addonsNbt);
        }
        return nbt;
    }

    @Override
    public double getWeight(PocketGenerationContext parameters) {
        try {
            return this.weightEquation != null ? this.weightEquation.apply(parameters.toVariableMap(Maps.newHashMap())) : this.peekReferencedPocketGenerator(parameters).getWeight(parameters);
        }
        catch (RuntimeException e) {
            LOGGER.error(this.toString());
            throw new AssertionError((Object)e);
        }
    }

    public void applyModifiers(PocketGenerationContext parameters, RiftManager manager) {
        for (Modifier modifier : this.modifierList) {
            modifier.apply(parameters, manager);
        }
    }

    public void applyModifiers(PocketGenerationContext parameters, Pocket.PocketBuilder<?, ?> builder) {
        for (Modifier modifier : this.modifierList) {
            modifier.apply(parameters, builder);
        }
    }

    @Override
    public Pocket prepareAndPlacePocket(PocketGenerationContext parameters) {
        PocketGenerator generator = this.getReferencedPocketGenerator(parameters);
        Object builder = generator.pocketBuilder(parameters).virtualLocation(parameters.sourceVirtualLocation());
        generator.applyModifiers(parameters, (Pocket.PocketBuilder<?, ?>)builder);
        this.applyModifiers(parameters, (Pocket.PocketBuilder<?, ?>)builder);
        LazyPocketGenerator.currentlyGenerating = true;
        Set<LevelChunk> alreadyLoadedChunks = StreamSupport.stream(parameters.world().m_7726_().f_8325_.m_140416_().spliterator(), false).map(ChunkHolder::m_140085_).filter(Objects::nonNull).collect(Collectors.toSet());
        Pocket pocket = generator.prepareAndPlacePocket(parameters, (Pocket.PocketBuilder<?, ?>)builder);
        BlockPos originalOrigin = pocket.getOrigin();
        RiftManager manager = generator.getRiftManager(pocket);
        generator.applyModifiers(parameters, manager);
        this.applyModifiers(parameters, manager);
        if (pocket instanceof LazyGenerationPocket) {
            if (!(generator instanceof LazyPocketGenerator)) {
                throw new RuntimeException("pocket was instance of LazyGenerationPocket but generator was not instance of LazyPocketGenerator");
            }
            LazyGenerationPocket lazyPocket = (LazyGenerationPocket)pocket;
            LazyPocketGenerator clonedGenerator = ((LazyPocketGenerator)generator).cloneWithLazyModifiers(originalOrigin);
            if (this.setupLoot != null) {
                clonedGenerator.setSetupLoot(this.setupLoot);
            }
            this.attachLazyModifiers(clonedGenerator);
            clonedGenerator.attachToPocket(lazyPocket);
            lazyPocket.init();
            alreadyLoadedChunks.forEach(lazyPocket::chunkLoaded);
            LazyPocketGenerator.currentlyGenerating = false;
            while (!LazyPocketGenerator.generationQueue.isEmpty()) {
                LevelChunk chunk = LazyPocketGenerator.generationQueue.remove();
                LazyCompatibleModifier.runQueuedModifications(chunk);
                MinecraftServer server = DimensionalDoors.getServer();
                DimensionalDoors.getServer().m_6937_((Runnable)new TickTask(server.m_129921_(), () -> lazyPocket.chunkLoaded(chunk)));
            }
            LazyCompatibleModifier.runLeftoverModifications((Level)DimensionalDoors.getWorld(lazyPocket.getWorld()));
        } else {
            LazyPocketGenerator.currentlyGenerating = false;
            LazyPocketGenerator.generationQueue.clear();
        }
        generator.setup(pocket, manager, parameters, this.setupLoot != null ? this.setupLoot.booleanValue() : generator.isSetupLoot());
        return pocket;
    }

    @Override
    public PocketGeneratorReference peekNextPocketGeneratorReference(PocketGenerationContext parameters) {
        return this;
    }

    @Override
    public PocketGeneratorReference getNextPocketGeneratorReference(PocketGenerationContext parameters) {
        return this;
    }

    public abstract PocketGenerator peekReferencedPocketGenerator(PocketGenerationContext var1);

    public abstract PocketGenerator getReferencedPocketGenerator(PocketGenerationContext var1);

    public abstract String toString();

    public void attachLazyModifiers(LazyPocketGenerator generator) {
        generator.attachLazyModifiers(this.modifierList.stream().filter(LazyModifier.class::isInstance).map(LazyModifier.class::cast).collect(Collectors.toList()));
    }
}

