/*
 * Decompiled with CFR 0.152.
 */
package org.dimdev.dimdoors.world;

import java.util.Collections;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderSet;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstapContext;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.VerticalAnchor;
import net.minecraft.world.level.levelgen.heightproviders.ConstantHeight;
import net.minecraft.world.level.levelgen.heightproviders.HeightProvider;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.TerrainAdjustment;
import net.minecraft.world.level.levelgen.structure.pools.StructureTemplatePool;
import net.minecraft.world.level.levelgen.structure.structures.JigsawStructure;
import org.dimdev.dimdoors.DimensionalDoors;
import org.dimdev.dimdoors.tag.ModBiomeTags;
import org.dimdev.dimdoors.world.ModGatewayPools;

public class ModStructures {
    public static ResourceKey<Structure> TWO_PILLARS = ModStructures.key("two_pillars");
    public static ResourceKey<Structure> ICE_PILLARS = ModStructures.key("i_pillars");
    public static ResourceKey<Structure> SANDSTONE_PILLARS = ModStructures.key("sandstone_pillars");
    public static ResourceKey<Structure> RED_SANDSTONE_PILLARS = ModStructures.key("red_sandstone_pillars");
    public static ResourceKey<Structure> ENCLOSED_GATEWAY = ModStructures.key("enclosed_gateway");
    public static ResourceKey<Structure> ENCLOSED_ENDSTONE_GATEWAY = ModStructures.key("enclosed_endstone_gateway");
    public static ResourceKey<Structure> ENCLOSED_MUD_GATEWAY = ModStructures.key("enclosed_mud_gateway");
    public static ResourceKey<Structure> ENCLOSED_PRISMARINE_GATEWAY = ModStructures.key("enclosed_prismarine_gateway");
    public static ResourceKey<Structure> ENCLOSED_QUARTZ_GATEWAY = ModStructures.key("enclosed_quartz_gateway");
    public static ResourceKey<Structure> ENCLOSED_RED_SANDSTONE_GATEWAY = ModStructures.key("enclosed_red_sandstone_gateway");
    public static ResourceKey<Structure> ENCLOSED_SANDSTONE_GATEWAY = ModStructures.key("enclosed_sandstone_gateway");
    private final HolderGetter<Biome> biomes;
    private final HolderGetter<StructureTemplatePool> pools;
    private final BootstapContext<Structure> context;

    public ModStructures(BootstapContext<Structure> context) {
        this.biomes = context.m_255420_(Registries.f_256952_);
        this.pools = context.m_255420_(Registries.f_256948_);
        this.context = context;
        this.register(ENCLOSED_GATEWAY, ModBiomeTags.ENCLOSED_GATEWAY, ModGatewayPools.ENCLOSED_GATEWAY);
        this.register(ENCLOSED_ENDSTONE_GATEWAY, ModBiomeTags.ENCLOSED_ENDSTONE_GATEWAY, ModGatewayPools.ENCLOSED_ENDSTONE_GATEWAY);
        this.register(ENCLOSED_MUD_GATEWAY, ModBiomeTags.ENCLOSED_MUD_GATEWAY, ModGatewayPools.ENCLOSED_MUD_GATEWAY);
        context.m_255272_(ENCLOSED_PRISMARINE_GATEWAY, (Object)new JigsawStructure(new Structure.StructureSettings((HolderSet)this.biomes.m_254956_(ModBiomeTags.ENCLOSED_PRISMARINE_GATEWAY), Collections.emptyMap(), GenerationStep.Decoration.SURFACE_STRUCTURES, TerrainAdjustment.BEARD_THIN), (Holder)this.pools.m_255043_(ModGatewayPools.ENCLOSED_PRISMARINE_GATEWAY), 1, (HeightProvider)ConstantHeight.m_161956_((VerticalAnchor)VerticalAnchor.m_158922_((int)0)), true, Heightmap.Types.OCEAN_FLOOR_WG));
        this.register(ENCLOSED_QUARTZ_GATEWAY, ModBiomeTags.ENCLOSED_QUARTZ_GATEWAY, ModGatewayPools.ENCLOSED_QUARTZ_GATEWAY);
        this.register(ENCLOSED_RED_SANDSTONE_GATEWAY, ModBiomeTags.ENCLOSED_RED_SANDSTONE_GATEWAY, ModGatewayPools.ENCLOSED_RED_SANDSTONE_GATEWAY);
        this.register(ENCLOSED_SANDSTONE_GATEWAY, ModBiomeTags.ENCLOSED_SANDSTONE_GATEWAY, ModGatewayPools.ENCLOSED_SANDSTONE_GATEWAY);
    }

    private void register(ResourceKey<Structure> structure, TagKey<Biome> biome, ResourceKey<StructureTemplatePool> pool) {
        this.context.m_255272_(structure, (Object)new JigsawStructure(new Structure.StructureSettings((HolderSet)this.biomes.m_254956_(biome), Collections.emptyMap(), GenerationStep.Decoration.SURFACE_STRUCTURES, TerrainAdjustment.BEARD_THIN), (Holder)this.pools.m_255043_(pool), 1, (HeightProvider)ConstantHeight.m_161956_((VerticalAnchor)VerticalAnchor.m_158922_((int)0)), true, Heightmap.Types.WORLD_SURFACE_WG));
    }

    private static ResourceKey<Structure> key(String name) {
        return ResourceKey.m_135785_((ResourceKey)Registries.f_256944_, (ResourceLocation)DimensionalDoors.id(name));
    }
}

