/*
 * Decompiled with CFR 0.152.
 */
package org.dimdev.dimdoors.world.pocket;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.mojang.datafixers.util.Pair;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import org.dimdev.dimdoors.api.util.StreamUtils;
import org.dimdev.dimdoors.world.level.registry.DimensionalRegistry;
import org.dimdev.dimdoors.world.pocket.type.Pocket;
import org.dimdev.dimdoors.world.pocket.type.PrivatePocket;

public class PrivateRegistry {
    private static final String DATA_NAME = "dimdoors_private_pockets";
    protected BiMap<UUID, PocketInfo> privatePocketMap = HashBiMap.create();

    public void fromNbt(CompoundTag nbt) {
        this.privatePocketMap.clear();
        CompoundTag privatePocketMapNbt = nbt.m_128469_("private_pocket_map");
        CompletableFuture<Map> futurePrivatePocketMap = CompletableFuture.supplyAsync(() -> ((Stream)((Stream)privatePocketMapNbt.m_128431_().stream().unordered()).map(key -> {
            CompoundTag pocketInfoNbt = privatePocketMapNbt.m_128469_(key);
            return CompletableFuture.supplyAsync(() -> new Pair((Object)UUID.fromString(key), (Object)PocketInfo.fromNbt(pocketInfoNbt)));
        }).parallel()).map(CompletableFuture::join).collect(Collectors.toConcurrentMap(Pair::getFirst, Pair::getSecond)));
        this.privatePocketMap.putAll(futurePrivatePocketMap.join());
    }

    public CompoundTag toNbt(CompoundTag nbt) {
        CompletableFuture<CompoundTag> futurePrivatePocketMapNbt = StreamUtils.supplyAsync(() -> {
            Map privatePocketNbtMap = ((Stream)this.privatePocketMap.entrySet().parallelStream().unordered()).collect(Collectors.toConcurrentMap(entry -> ((UUID)entry.getKey()).toString(), entry -> PocketInfo.toNbt((PocketInfo)entry.getValue())));
            CompoundTag privatePocketMapNbt = new CompoundTag();
            privatePocketNbtMap.forEach((arg_0, arg_1) -> ((CompoundTag)privatePocketMapNbt).m_128365_(arg_0, arg_1));
            return privatePocketMapNbt;
        });
        nbt.m_128365_("private_pocket_map", (Tag)futurePrivatePocketMapNbt.join());
        return nbt;
    }

    public PrivatePocket getPrivatePocket(UUID playerUUID) {
        PocketInfo pocket = (PocketInfo)this.privatePocketMap.get((Object)playerUUID);
        if (pocket == null) {
            return null;
        }
        return DimensionalRegistry.getPocketDirectory(pocket.world).getPocket(pocket.id, PrivatePocket.class);
    }

    public void setPrivatePocketID(UUID playerUUID, Pocket pocket) {
        this.privatePocketMap.put((Object)playerUUID, (Object)new PocketInfo(pocket.getWorld(), pocket.getId()));
    }

    public UUID getPrivatePocketOwner(Pocket pocket) {
        return (UUID)this.privatePocketMap.inverse().get((Object)new PocketInfo(pocket.getWorld(), pocket.getId()));
    }

    protected static class PocketInfo {
        public final ResourceKey<Level> world;
        public final int id;

        public PocketInfo(ResourceKey<Level> world, int id) {
            this.world = world;
            this.id = id;
        }

        public static CompoundTag toNbt(PocketInfo info) {
            CompoundTag nbt = new CompoundTag();
            nbt.m_128359_("world", info.world.m_135782_().toString());
            nbt.m_128405_("id", info.id);
            return nbt;
        }

        public static PocketInfo fromNbt(CompoundTag nbt) {
            return new PocketInfo((ResourceKey<Level>)ResourceKey.m_135785_((ResourceKey)Registries.f_256858_, (ResourceLocation)new ResourceLocation(nbt.m_128461_("world"))), nbt.m_128451_("id"));
        }
    }
}

