/*
 * Decompiled with CFR 0.152.
 */
package org.dimdev.dimdoors.world.pocket.type.addon;

import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import org.dimdev.dimdoors.DimensionalDoors;
import org.dimdev.dimdoors.api.util.EntityUtils;
import org.dimdev.dimdoors.block.AncientFabricBlock;
import org.dimdev.dimdoors.block.FabricBlock;
import org.dimdev.dimdoors.block.ModBlocks;
import org.dimdev.dimdoors.world.pocket.type.Pocket;
import org.dimdev.dimdoors.world.pocket.type.PocketColor;
import org.dimdev.dimdoors.world.pocket.type.PrivatePocket;
import org.dimdev.dimdoors.world.pocket.type.addon.AddonProvider;
import org.dimdev.dimdoors.world.pocket.type.addon.PocketAddon;

public class DyeableAddon
implements PocketAddon {
    public static ResourceLocation ID = DimensionalDoors.id("dyeable");
    private static final int BLOCKS_PAINTED_PER_DYE = 1000000;
    protected PocketColor dyeColor = PocketColor.WHITE;
    private PocketColor nextDyeColor = PocketColor.NONE;
    private int count = 0;

    private static int amountOfDyeRequiredToColor(Pocket pocket) {
        int outerVolume = pocket.getBox().m_71057_() * pocket.getBox().m_71058_() * pocket.getBox().m_71056_();
        int innerVolume = (pocket.getBox().m_71057_() - 5) * (pocket.getBox().m_71058_() - 5) * (pocket.getBox().m_71056_() - 5);
        return Math.max((outerVolume - innerVolume) / 1000000, 1);
    }

    private void repaint(Pocket pocket, DyeColor dyeColor) {
        ServerLevel serverWorld = DimensionalDoors.getWorld(pocket.getWorld());
        BlockState innerWall = ((Block)ModBlocks.fabricFromDye(dyeColor).getOrNull()).m_49966_();
        BlockState outerWall = ((Block)ModBlocks.ancientFabricFromDye(dyeColor).getOrNull()).m_49966_();
        BlockPos.m_121919_((BoundingBox)pocket.getBox()).forEach(arg_0 -> DyeableAddon.lambda$repaint$0((Level)serverWorld, outerWall, innerWall, arg_0));
    }

    public boolean addDye(Pocket pocket, Entity entity, DyeColor dyeColor) {
        PocketColor color = PocketColor.from(dyeColor);
        int maxDye = DyeableAddon.amountOfDyeRequiredToColor(pocket);
        if (this.dyeColor == color) {
            EntityUtils.chat(entity, (Component)Component.m_237115_((String)"dimdoors.pockets.dyeAlreadyAbsorbed"));
            return false;
        }
        if (this.nextDyeColor != PocketColor.NONE && this.nextDyeColor == color) {
            if (this.count + 1 > maxDye) {
                this.repaint(pocket, dyeColor);
                this.dyeColor = color;
                this.nextDyeColor = PocketColor.NONE;
                this.count = 0;
                EntityUtils.chat(entity, (Component)Component.m_237110_((String)"dimdoors.pocket.pocketHasBeenDyed", (Object[])new Object[]{dyeColor}));
            } else {
                ++this.count;
                EntityUtils.chat(entity, (Component)Component.m_237110_((String)"dimdoors.pocket.remainingNeededDyes", (Object[])new Object[]{this.count, maxDye, color}));
            }
        } else {
            this.nextDyeColor = color;
            this.count = 1;
            EntityUtils.chat(entity, (Component)Component.m_237110_((String)"dimdoors.pocket.remainingNeededDyes", (Object[])new Object[]{this.count, maxDye, color}));
        }
        return true;
    }

    @Override
    public boolean applicable(Pocket pocket) {
        return pocket instanceof PrivatePocket;
    }

    @Override
    public PocketAddon fromNbt(CompoundTag nbt) {
        this.dyeColor = PocketColor.from(nbt.m_128451_("dyeColor"));
        this.nextDyeColor = PocketColor.from(nbt.m_128451_("nextDyeColor"));
        this.count = nbt.m_128451_("count");
        return this;
    }

    @Override
    public CompoundTag toNbt(CompoundTag nbt) {
        PocketAddon.super.toNbt(nbt);
        nbt.m_128405_("dyeColor", this.dyeColor.getId().intValue());
        nbt.m_128405_("nextDyeColor", this.nextDyeColor.getId().intValue());
        nbt.m_128405_("count", this.count);
        return nbt;
    }

    @Override
    public PocketAddon.PocketAddonType<? extends PocketAddon> getType() {
        return (PocketAddon.PocketAddonType)PocketAddon.PocketAddonType.DYEABLE_ADDON.get();
    }

    @Override
    public ResourceLocation getId() {
        return ID;
    }

    private static /* synthetic */ void lambda$repaint$0(Level serverWorld, BlockState outerWall, BlockState innerWall, BlockPos pos) {
        if (serverWorld.m_8055_(pos).m_60734_() instanceof AncientFabricBlock) {
            serverWorld.m_46597_(pos, outerWall);
        } else if (serverWorld.m_8055_(pos).m_60734_() instanceof FabricBlock) {
            serverWorld.m_46597_(pos, innerWall);
        }
    }

    public static interface DyeablePocket
    extends AddonProvider {
        default public boolean addDye(Entity entity, DyeColor dyeColor) {
            this.ensureIsPocket();
            if (!this.hasAddon(ID)) {
                DyeableAddon addon = new DyeableAddon();
                this.addAddon(addon);
                return addon.addDye((Pocket)((Object)this), entity, dyeColor);
            }
            return ((DyeableAddon)this.getAddon(ID)).addDye((Pocket)((Object)this), entity, dyeColor);
        }
    }

    public static class DyeableBuilderAddon
    implements PocketAddon.PocketBuilderAddon<DyeableAddon> {
        private PocketColor dyeColor = PocketColor.NONE;

        @Override
        public void apply(Pocket pocket) {
            DyeableAddon addon = new DyeableAddon();
            addon.dyeColor = this.dyeColor;
            pocket.addAddon(addon);
        }

        @Override
        public ResourceLocation getId() {
            return ID;
        }

        @Override
        public PocketAddon.PocketBuilderAddon<DyeableAddon> fromNbt(CompoundTag nbt) {
            this.dyeColor = PocketColor.from(nbt.m_128451_("dye_color"));
            return this;
        }

        @Override
        public CompoundTag toNbt(CompoundTag nbt) {
            PocketAddon.PocketBuilderAddon.super.toNbt(nbt);
            nbt.m_128405_("dye_color", this.dyeColor.getId().intValue());
            return nbt;
        }

        @Override
        public PocketAddon.PocketAddonType<DyeableAddon> getType() {
            return (PocketAddon.PocketAddonType)PocketAddon.PocketAddonType.DYEABLE_ADDON.get();
        }
    }

    public static interface DyeablePocketBuilder<T extends Pocket.PocketBuilder<T, ?>>
    extends PocketAddon.PocketBuilderExtension<T> {
        default public T dyeColor(PocketColor dyeColor) {
            ((DyeableBuilderAddon)this.getAddon((ResourceLocation)DyeableAddon.ID)).dyeColor = dyeColor;
            return this.getSelf();
        }
    }
}

