/*
 * Decompiled with CFR 0.152.
 */
package dev.mayaqq.cynosure.core.registry;

import com.google.common.collect.HashBiMap;
import com.google.common.collect.ImmutableMap;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import dev.mayaqq.cynosure.utils.serialization.defaults.ResourceLocationSerializer;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.StringCompanionObject;
import kotlinx.serialization.KSerializer;
import kotlinx.serialization.builtins.BuiltinSerializersKt;
import kotlinx.serialization.descriptors.SerialDescriptor;
import kotlinx.serialization.descriptors.SerialDescriptorsKt;
import kotlinx.serialization.encoding.Decoder;
import kotlinx.serialization.encoding.Encoder;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\t\b\u0016\u0018\u0000 !*\b\b\u0000\u0010\u0002*\u00020\u00012\u00020\u0001:\u0002!\"B\u0019\u0012\u0010\b\u0002\u0010\u0004\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u001f\u0010\n\u001a\u00028\u00002\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00028\u0000H\u0016\u00a2\u0006\u0004\b\n\u0010\u000bJ\u001a\u0010\f\u001a\u0004\u0018\u00018\u00002\u0006\u0010\b\u001a\u00020\u0007H\u0096\u0002\u00a2\u0006\u0004\b\f\u0010\rJ\u0019\u0010\u000e\u001a\u0004\u0018\u00010\u00072\u0006\u0010\t\u001a\u00028\u0000H\u0016\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u0019\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00028\u00000\u0010\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u0013\u0010\u0014\u001a\b\u0012\u0004\u0012\u00028\u00000\u0013\u00a2\u0006\u0004\b\u0014\u0010\u0015J\u0013\u0010\u0017\u001a\b\u0012\u0004\u0012\u00028\u00000\u0016\u00a2\u0006\u0004\b\u0017\u0010\u0018R\u001c\u0010\u0004\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\u00038\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0004\u0010\u0019R&\u0010\u001b\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00028\u00000\u001a8\u0004X\u0084\u0004\u00a2\u0006\f\n\u0004\b\u001b\u0010\u001c\u001a\u0004\b\u001d\u0010\u001eR\u001e\u0010\u0014\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\u00138\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u0014\u0010\u001fR\u001e\u0010\u0017\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\u00168\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u0017\u0010 \u00a8\u0006#"}, d2={"Ldev/mayaqq/cynosure/core/registry/NamedRegistry;", "", "T", "Lkotlin/Function0;", "defaultValue", "<init>", "(Lkotlin/jvm/functions/Function0;)V", "Lnet/minecraft/resources/ResourceLocation;", "key", "value", "register", "(Lnet/minecraft/resources/ResourceLocation;Ljava/lang/Object;)Ljava/lang/Object;", "get", "(Lnet/minecraft/resources/ResourceLocation;)Ljava/lang/Object;", "getKey", "(Ljava/lang/Object;)Lnet/minecraft/resources/ResourceLocation;", "", "getAll", "()Ljava/util/Map;", "Lcom/mojang/serialization/Codec;", "codec", "()Lcom/mojang/serialization/Codec;", "Lkotlinx/serialization/KSerializer;", "serializer", "()Lkotlinx/serialization/KSerializer;", "Lkotlin/jvm/functions/Function0;", "Lcom/google/common/collect/HashBiMap;", "idMap", "Lcom/google/common/collect/HashBiMap;", "getIdMap", "()Lcom/google/common/collect/HashBiMap;", "Lcom/mojang/serialization/Codec;", "Lkotlinx/serialization/KSerializer;", "Companion", "Serializer", "cynosure_forge"})
@SourceDebugExtension(value={"SMAP\nNamedRegistry.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NamedRegistry.kt\ndev/mayaqq/cynosure/core/registry/NamedRegistry\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,63:1\n1#2:64\n*E\n"})
public class NamedRegistry<T> {
    @NotNull
    private static final Companion Companion = new Companion(null);
    @Nullable
    private final Function0<T> defaultValue;
    @NotNull
    private final HashBiMap<ResourceLocation, T> idMap;
    @Nullable
    private Codec<T> codec;
    @Nullable
    private KSerializer<T> serializer;

    public NamedRegistry(@Nullable Function0<? extends T> defaultValue) {
        this.defaultValue = defaultValue;
        HashBiMap hashBiMap = HashBiMap.create();
        Intrinsics.checkNotNullExpressionValue((Object)hashBiMap, (String)"create(...)");
        this.idMap = hashBiMap;
    }

    public /* synthetic */ NamedRegistry(Function0 function0, int i, DefaultConstructorMarker defaultConstructorMarker) {
        if ((i & 1) != 0) {
            function0 = null;
        }
        this(function0);
    }

    @NotNull
    protected final HashBiMap<ResourceLocation, T> getIdMap() {
        return this.idMap;
    }

    @NotNull
    public T register(@NotNull ResourceLocation key, @NotNull T value) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter(value, (String)"value");
        Objects.requireNonNull(key, "Key cannot be null");
        Objects.requireNonNull(value, "Value cannot be null");
        if (!(!this.idMap.containsKey((Object)key))) {
            boolean i = false;
            String string = "Key already present: " + key;
            throw new IllegalStateException(string.toString());
        }
        ((Map)this.idMap).put(key, value);
        return value;
    }

    @Nullable
    public T get(@NotNull ResourceLocation key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Object object = this.idMap.get((Object)key);
        if (object == null) {
            Function0<T> function0 = this.defaultValue;
            object = function0 != null ? function0.invoke() : null;
        }
        return (T)object;
    }

    @Nullable
    public ResourceLocation getKey(@NotNull T value) {
        Intrinsics.checkNotNullParameter(value, (String)"value");
        return (ResourceLocation)this.idMap.inverse().get(value);
    }

    @NotNull
    public final Map<ResourceLocation, T> getAll() {
        ImmutableMap immutableMap = ImmutableMap.copyOf((Map)((Map)this.idMap));
        Intrinsics.checkNotNullExpressionValue((Object)immutableMap, (String)"copyOf(...)");
        return (Map)immutableMap;
    }

    @NotNull
    public final Codec<T> codec() {
        Codec codec2 = this.codec;
        if (codec2 == null) {
            Codec codec3;
            Codec it = codec3 = ResourceLocation.f_135803_.flatXmap(arg_0 -> NamedRegistry.codec$lambda$3(arg_0 -> NamedRegistry.codec$lambda$2(this, arg_0), arg_0), arg_0 -> NamedRegistry.codec$lambda$6(arg_0 -> NamedRegistry.codec$lambda$5(this, arg_0), arg_0));
            boolean i = false;
            this.codec = it;
            Codec codec4 = codec3;
            Intrinsics.checkNotNullExpressionValue((Object)codec4, (String)"also(...)");
            codec2 = codec4;
        }
        return codec2;
    }

    @NotNull
    public final KSerializer<T> serializer() {
        KSerializer kSerializer = this.serializer;
        if (kSerializer == null) {
            Serializer serializer2;
            Serializer it = serializer2 = new Serializer();
            boolean i = false;
            this.serializer = it;
            kSerializer = serializer2;
        }
        return kSerializer;
    }

    private static final String codec$lambda$2$lambda$1(ResourceLocation $rl) {
        return "Entry not present: " + $rl;
    }

    private static final <T> DataResult<? extends T> codec$lambda$2(NamedRegistry<T> this$0, ResourceLocation rl) {
        Intrinsics.checkNotNull((Object)rl);
        return NamedRegistry.Companion.failIfNull(this$0.get(rl), () -> NamedRegistry.codec$lambda$2$lambda$1(rl));
    }

    private static final DataResult codec$lambda$3(Function1 $tmp0, Object p0) {
        return (DataResult)$tmp0.invoke(p0);
    }

    private static final String codec$lambda$5$lambda$4(Object $value) {
        return "Item not found in registry: " + $value;
    }

    private static final <T> DataResult<? extends ResourceLocation> codec$lambda$5(NamedRegistry<T> this$0, T value) {
        Intrinsics.checkNotNull(value);
        return NamedRegistry.Companion.failIfNull(this$0.getKey(value), () -> NamedRegistry.codec$lambda$5$lambda$4(value));
    }

    private static final DataResult codec$lambda$6(Function1 $tmp0, Object p0) {
        return (DataResult)$tmp0.invoke(p0);
    }

    public NamedRegistry() {
        this(null, 1, null);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0082\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J3\u0010\n\u001a\b\u0012\u0004\u0012\u00028\u00010\t\"\u0004\b\u0001\u0010\u00042\b\u0010\u0005\u001a\u0004\u0018\u00018\u00012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u0002\u00a2\u0006\u0004\b\n\u0010\u000b\u00a8\u0006\f"}, d2={"Ldev/mayaqq/cynosure/core/registry/NamedRegistry$Companion;", "", "<init>", "()V", "R", "item", "Ljava/util/function/Supplier;", "", "errorMessage", "Lcom/mojang/serialization/DataResult;", "failIfNull", "(Ljava/lang/Object;Ljava/util/function/Supplier;)Lcom/mojang/serialization/DataResult;", "cynosure_forge"})
    private static final class Companion {
        private Companion() {
        }

        private final <R> DataResult<R> failIfNull(R item, Supplier<String> errorMessage) {
            DataResult dataResult;
            R r = item;
            if (r != null) {
                DataResult dataResult2 = DataResult.success(r);
                dataResult = dataResult2;
                Intrinsics.checkNotNullExpressionValue((Object)dataResult2, (String)"success(...)");
            } else {
                DataResult dataResult3 = DataResult.error(errorMessage);
                dataResult = dataResult3;
                Intrinsics.checkNotNullExpressionValue((Object)dataResult3, (String)"error(...)");
            }
            return dataResult;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0082\u0004\u0018\u00002\b\u0012\u0004\u0012\u00028\u00000\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0017\u0010\u0006\u001a\u00028\u00002\u0006\u0010\u0005\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u001f\u0010\f\u001a\u00020\u000b2\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00028\u0000H\u0016\u00a2\u0006\u0004\b\f\u0010\rR\u001a\u0010\u000f\u001a\u00020\u000e8\u0016X\u0096\u0004\u00a2\u0006\f\n\u0004\b\u000f\u0010\u0010\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u0013"}, d2={"Ldev/mayaqq/cynosure/core/registry/NamedRegistry$Serializer;", "Lkotlinx/serialization/KSerializer;", "<init>", "(Ldev/mayaqq/cynosure/core/registry/NamedRegistry;)V", "Lkotlinx/serialization/encoding/Decoder;", "decoder", "deserialize", "(Lkotlinx/serialization/encoding/Decoder;)Ljava/lang/Object;", "Lkotlinx/serialization/encoding/Encoder;", "encoder", "value", "", "serialize", "(Lkotlinx/serialization/encoding/Encoder;Ljava/lang/Object;)V", "Lkotlinx/serialization/descriptors/SerialDescriptor;", "descriptor", "Lkotlinx/serialization/descriptors/SerialDescriptor;", "getDescriptor", "()Lkotlinx/serialization/descriptors/SerialDescriptor;", "cynosure_forge"})
    private final class Serializer
    implements KSerializer<T> {
        @NotNull
        private final SerialDescriptor descriptor;

        public Serializer() {
            this.descriptor = SerialDescriptorsKt.SerialDescriptor((String)("dev.mayaqq.cynosure.core.registry.NamedRegistry[" + NamedRegistry.this + "]"), (SerialDescriptor)BuiltinSerializersKt.serializer((StringCompanionObject)StringCompanionObject.INSTANCE).getDescriptor());
        }

        @NotNull
        public SerialDescriptor getDescriptor() {
            return this.descriptor;
        }

        @NotNull
        public T deserialize(@NotNull Decoder decoder) {
            Intrinsics.checkNotNullParameter((Object)decoder, (String)"decoder");
            Object t = NamedRegistry.this.get(ResourceLocationSerializer.INSTANCE.deserialize(decoder));
            Intrinsics.checkNotNull(t);
            return t;
        }

        public void serialize(@NotNull Encoder encoder, @NotNull T value) {
            Intrinsics.checkNotNullParameter((Object)encoder, (String)"encoder");
            Intrinsics.checkNotNullParameter(value, (String)"value");
            ResourceLocation resourceLocation = NamedRegistry.this.getKey(value);
            if (resourceLocation == null) {
                String string = "Required value was null.";
                throw new IllegalArgumentException(string.toString());
            }
            ResourceLocationSerializer.INSTANCE.serialize(encoder, resourceLocation);
        }
    }
}

