/*
 * Decompiled with CFR 0.152.
 */
package dev.mayaqq.cynosure.events;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.ParseResults;
import dev.mayaqq.cynosure.events.ForgeEventsKt;
import dev.mayaqq.cynosure.events.api.EventKt;
import dev.mayaqq.cynosure.events.block.BlockEvent;
import dev.mayaqq.cynosure.events.command.CommandExecuteEvent;
import dev.mayaqq.cynosure.events.command.CommandRegistrationEvent;
import dev.mayaqq.cynosure.events.entity.EntityCreatedEvent;
import dev.mayaqq.cynosure.events.entity.EntityTrackingEvent;
import dev.mayaqq.cynosure.events.entity.LivingEntityEvent;
import dev.mayaqq.cynosure.events.entity.MountEvent;
import dev.mayaqq.cynosure.events.entity.player.PlayerConnectionEvent;
import dev.mayaqq.cynosure.events.entity.player.PlayerTickEvent;
import dev.mayaqq.cynosure.events.entity.player.interaction.InteractionEvent;
import dev.mayaqq.cynosure.events.server.DataPackSyncEvent;
import dev.mayaqq.cynosure.events.server.ServerChatEvent;
import dev.mayaqq.cynosure.events.server.ServerEvent;
import dev.mayaqq.cynosure.events.world.LevelEvent;
import dev.mayaqq.cynosure.internal.CynosureHooksImpl;
import dev.mayaqq.cynosure.items.extensions.CustomEntityItem;
import dev.mayaqq.cynosure.items.extensions.CustomFurnaceFuel;
import dev.mayaqq.cynosure.items.extensions.ItemExtension;
import java.util.Iterator;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.TickTask;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.util.thread.BlockableEventLoop;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.common.util.LogicalSidedProvider;
import net.minecraftforge.event.AddReloadListenerEvent;
import net.minecraftforge.event.CommandEvent;
import net.minecraftforge.event.OnDatapackSyncEvent;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.event.entity.EntityMountEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.MobEffectEvent;
import net.minecraftforge.event.entity.player.AttackEntityEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.furnace.FurnaceFuelBurnTimeEvent;
import net.minecraftforge.event.level.BlockEvent;
import net.minecraftforge.event.level.LevelEvent;
import net.minecraftforge.event.server.ServerAboutToStartEvent;
import net.minecraftforge.event.server.ServerStartedEvent;
import net.minecraftforge.event.server.ServerStoppedEvent;
import net.minecraftforge.event.server.ServerStoppingEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.common.Mod;
import org.jetbrains.annotations.NotNull;

@Mod.EventBusSubscriber(modid="cynosure")
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0082\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c7\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0017\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004H\u0007\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0017\u0010\n\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\tH\u0007\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0017\u0010\r\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\fH\u0007\u00a2\u0006\u0004\b\r\u0010\u000eJ\u0017\u0010\u0010\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u000fH\u0007\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u0017\u0010\u0013\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0012H\u0007\u00a2\u0006\u0004\b\u0013\u0010\u0014J\u0017\u0010\u0016\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0015H\u0007\u00a2\u0006\u0004\b\u0016\u0010\u0017J\u0017\u0010\u0019\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0018H\u0007\u00a2\u0006\u0004\b\u0019\u0010\u001aJ\u0017\u0010\u001c\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u001bH\u0007\u00a2\u0006\u0004\b\u001c\u0010\u001dJ\u0017\u0010\u001f\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u001eH\u0007\u00a2\u0006\u0004\b\u001f\u0010 J\u0017\u0010\"\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020!H\u0007\u00a2\u0006\u0004\b\"\u0010#J\u0017\u0010%\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020$H\u0007\u00a2\u0006\u0004\b%\u0010&J\u0017\u0010(\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020'H\u0007\u00a2\u0006\u0004\b(\u0010)J\u0017\u0010+\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020*H\u0007\u00a2\u0006\u0004\b+\u0010,J\u0017\u0010.\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020-H\u0007\u00a2\u0006\u0004\b.\u0010/J\u0017\u00101\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u000200H\u0007\u00a2\u0006\u0004\b1\u00102J\u0017\u00104\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u000203H\u0007\u00a2\u0006\u0004\b4\u00105J\u0017\u00106\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u000203H\u0007\u00a2\u0006\u0004\b6\u00105J\u0017\u00108\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u000207H\u0007\u00a2\u0006\u0004\b8\u00109J\u0017\u0010;\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020:H\u0007\u00a2\u0006\u0004\b;\u0010<J\u0017\u0010>\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020=H\u0007\u00a2\u0006\u0004\b>\u0010?J\u0017\u0010A\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020@H\u0007\u00a2\u0006\u0004\bA\u0010BJ\u0017\u0010D\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020CH\u0007\u00a2\u0006\u0004\bD\u0010EJ\u0017\u0010G\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020FH\u0007\u00a2\u0006\u0004\bG\u0010HJ\u0017\u0010J\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020IH\u0007\u00a2\u0006\u0004\bJ\u0010KJ\u0017\u0010M\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020LH\u0007\u00a2\u0006\u0004\bM\u0010NJ\u0017\u0010P\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020OH\u0007\u00a2\u0006\u0004\bP\u0010QJ\u0017\u0010S\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020RH\u0007\u00a2\u0006\u0004\bS\u0010TJ\u0017\u0010V\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020UH\u0007\u00a2\u0006\u0004\bV\u0010WJ\u0017\u0010Y\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020XH\u0007\u00a2\u0006\u0004\bY\u0010ZJ\u0017\u0010\\\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020[H\u0007\u00a2\u0006\u0004\b\\\u0010]J\u0017\u0010_\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020^H\u0007\u00a2\u0006\u0004\b_\u0010`\u00a8\u0006a"}, d2={"Ldev/mayaqq/cynosure/events/ForgeEvents;", "", "<init>", "()V", "Lnet/minecraftforge/event/entity/player/PlayerEvent$PlayerLoggedInEvent;", "event", "", "onPlayerJoin", "(Lnet/minecraftforge/event/entity/player/PlayerEvent$PlayerLoggedInEvent;)V", "Lnet/minecraftforge/event/entity/player/PlayerEvent$PlayerLoggedOutEvent;", "onPlayerLeave", "(Lnet/minecraftforge/event/entity/player/PlayerEvent$PlayerLoggedOutEvent;)V", "Lnet/minecraftforge/event/entity/living/LivingDeathEvent;", "onEntityDeath", "(Lnet/minecraftforge/event/entity/living/LivingDeathEvent;)V", "Lnet/minecraftforge/event/level/BlockEvent;", "onBlockEvent", "(Lnet/minecraftforge/event/level/BlockEvent;)V", "Lnet/minecraftforge/event/entity/player/PlayerInteractEvent;", "onPlayerInteract", "(Lnet/minecraftforge/event/entity/player/PlayerInteractEvent;)V", "Lnet/minecraftforge/event/entity/player/AttackEntityEvent;", "onAttackEntity", "(Lnet/minecraftforge/event/entity/player/AttackEntityEvent;)V", "Lnet/minecraftforge/event/entity/living/LivingEvent$LivingTickEvent;", "onEntityTick", "(Lnet/minecraftforge/event/entity/living/LivingEvent$LivingTickEvent;)V", "Lnet/minecraftforge/event/OnDatapackSyncEvent;", "onSyncDatapack", "(Lnet/minecraftforge/event/OnDatapackSyncEvent;)V", "Lnet/minecraftforge/event/entity/EntityJoinLevelEvent;", "onEntityJoin", "(Lnet/minecraftforge/event/entity/EntityJoinLevelEvent;)V", "Lnet/minecraftforge/event/entity/EntityMountEvent;", "onEntityMount", "(Lnet/minecraftforge/event/entity/EntityMountEvent;)V", "Lnet/minecraftforge/event/level/LevelEvent$Load;", "onLoadWorld", "(Lnet/minecraftforge/event/level/LevelEvent$Load;)V", "Lnet/minecraftforge/event/level/LevelEvent$Unload;", "onUnloadWorld", "(Lnet/minecraftforge/event/level/LevelEvent$Unload;)V", "Lnet/minecraftforge/event/level/LevelEvent$Save;", "onSaveWorld", "(Lnet/minecraftforge/event/level/LevelEvent$Save;)V", "Lnet/minecraftforge/event/TickEvent$LevelTickEvent;", "onTickWorld", "(Lnet/minecraftforge/event/TickEvent$LevelTickEvent;)V", "Lnet/minecraftforge/event/AddReloadListenerEvent;", "onReloadListener", "(Lnet/minecraftforge/event/AddReloadListenerEvent;)V", "Lnet/minecraftforge/event/furnace/FurnaceFuelBurnTimeEvent;", "furnaceFuel", "(Lnet/minecraftforge/event/furnace/FurnaceFuelBurnTimeEvent;)V", "furnaceFuel1", "Lnet/minecraftforge/event/server/ServerAboutToStartEvent;", "onServerStarting", "(Lnet/minecraftforge/event/server/ServerAboutToStartEvent;)V", "Lnet/minecraftforge/event/server/ServerStartedEvent;", "onServerStarted", "(Lnet/minecraftforge/event/server/ServerStartedEvent;)V", "Lnet/minecraftforge/event/server/ServerStoppingEvent;", "onServerStopping", "(Lnet/minecraftforge/event/server/ServerStoppingEvent;)V", "Lnet/minecraftforge/event/server/ServerStoppedEvent;", "onServerStopped", "(Lnet/minecraftforge/event/server/ServerStoppedEvent;)V", "Lnet/minecraftforge/event/TickEvent$ServerTickEvent;", "onServerTick", "(Lnet/minecraftforge/event/TickEvent$ServerTickEvent;)V", "Lnet/minecraftforge/event/RegisterCommandsEvent;", "onCommandRegistration", "(Lnet/minecraftforge/event/RegisterCommandsEvent;)V", "Lnet/minecraftforge/event/CommandEvent;", "onCommand", "(Lnet/minecraftforge/event/CommandEvent;)V", "Lnet/minecraftforge/event/TickEvent$PlayerTickEvent;", "onPlayerTick", "(Lnet/minecraftforge/event/TickEvent$PlayerTickEvent;)V", "Lnet/minecraftforge/event/entity/player/PlayerEvent$StartTracking;", "onStartTracking", "(Lnet/minecraftforge/event/entity/player/PlayerEvent$StartTracking;)V", "Lnet/minecraftforge/event/entity/player/PlayerEvent$StopTracking;", "onStopTracking", "(Lnet/minecraftforge/event/entity/player/PlayerEvent$StopTracking;)V", "Lnet/minecraftforge/event/ServerChatEvent;", "onChat", "(Lnet/minecraftforge/event/ServerChatEvent;)V", "Lnet/minecraftforge/event/entity/living/MobEffectEvent$Added;", "onEntityEffectAdded", "(Lnet/minecraftforge/event/entity/living/MobEffectEvent$Added;)V", "Lnet/minecraftforge/event/entity/living/MobEffectEvent$Remove;", "onEntityEffectRemoved", "(Lnet/minecraftforge/event/entity/living/MobEffectEvent$Remove;)V", "Lnet/minecraftforge/event/entity/living/MobEffectEvent$Expired;", "onEntityEffectExpired", "(Lnet/minecraftforge/event/entity/living/MobEffectEvent$Expired;)V", "cynosure_forge"})
@SourceDebugExtension(value={"SMAP\nForgeEvents.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ForgeEvents.kt\ndev/mayaqq/cynosure/events/ForgeEvents\n+ 2 ItemExtensions.kt\ndev/mayaqq/cynosure/items/extensions/ItemExtensionsKt\n+ 3 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,290:1\n35#2:291\n35#2:294\n216#3,2:292\n*S KotlinDebug\n*F\n+ 1 ForgeEvents.kt\ndev/mayaqq/cynosure/events/ForgeEvents\n*L\n137#1:291\n191#1:294\n185#1:292,2\n*E\n"})
public final class ForgeEvents {
    @NotNull
    public static final ForgeEvents INSTANCE = new ForgeEvents();

    private ForgeEvents() {
    }

    @SubscribeEvent
    public final void onPlayerJoin(@NotNull PlayerEvent.PlayerLoggedInEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Player player = event.getEntity();
        Intrinsics.checkNotNull((Object)player, (String)"null cannot be cast to non-null type net.minecraft.server.level.ServerPlayer");
        EventKt.post$default(new PlayerConnectionEvent.Join((ServerPlayer)player), null, 1, null);
    }

    @SubscribeEvent
    public final void onPlayerLeave(@NotNull PlayerEvent.PlayerLoggedOutEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Player player = event.getEntity();
        Intrinsics.checkNotNull((Object)player, (String)"null cannot be cast to non-null type net.minecraft.server.level.ServerPlayer");
        EventKt.post$default(new PlayerConnectionEvent.Leave((ServerPlayer)player), null, 1, null);
    }

    @SubscribeEvent
    public final void onEntityDeath(@NotNull LivingDeathEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        LivingEntity livingEntity = event.getEntity();
        Intrinsics.checkNotNullExpressionValue((Object)livingEntity, (String)"getEntity(...)");
        DamageSource damageSource = event.getSource();
        Intrinsics.checkNotNullExpressionValue((Object)damageSource, (String)"getSource(...)");
        event.setCanceled(EventKt.post$default(new LivingEntityEvent.Death(livingEntity, damageSource), null, 1, null));
    }

    @SubscribeEvent
    public final void onBlockEvent(@NotNull BlockEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        BlockEvent blockEvent = event;
        if (blockEvent instanceof BlockEvent.BreakEvent) {
            LevelAccessor levelAccessor = ((BlockEvent.BreakEvent)event).getLevel();
            Intrinsics.checkNotNullExpressionValue((Object)levelAccessor, (String)"getLevel(...)");
            BlockState blockState = ((BlockEvent.BreakEvent)event).getState();
            Intrinsics.checkNotNullExpressionValue((Object)blockState, (String)"getState(...)");
            BlockPos blockPos = ((BlockEvent.BreakEvent)event).getPos();
            Intrinsics.checkNotNullExpressionValue((Object)blockPos, (String)"getPos(...)");
            EventKt.post$default(new BlockEvent.Break(levelAccessor, blockState, blockPos, ((BlockEvent.BreakEvent)event).getPlayer()), null, (Object)event, null, 5, null);
        } else if (blockEvent instanceof BlockEvent.EntityPlaceEvent) {
            LevelAccessor levelAccessor = ((BlockEvent.EntityPlaceEvent)event).getLevel();
            Intrinsics.checkNotNullExpressionValue((Object)levelAccessor, (String)"getLevel(...)");
            BlockState blockState = ((BlockEvent.EntityPlaceEvent)event).getState();
            Intrinsics.checkNotNullExpressionValue((Object)blockState, (String)"getState(...)");
            BlockPos blockPos = ((BlockEvent.EntityPlaceEvent)event).getPos();
            Intrinsics.checkNotNullExpressionValue((Object)blockPos, (String)"getPos(...)");
            EventKt.post$default(new BlockEvent.Place(levelAccessor, blockState, blockPos, ((BlockEvent.EntityPlaceEvent)event).getEntity()), null, (Object)event, null, 5, null);
        } else if (blockEvent instanceof BlockEvent.FluidPlaceBlockEvent) {
            // empty if block
        }
    }

    @SubscribeEvent
    public final void onPlayerInteract(@NotNull PlayerInteractEvent event) {
        InteractionResult result;
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        PlayerInteractEvent playerInteractEvent = event;
        if (playerInteractEvent instanceof PlayerInteractEvent.RightClickBlock) {
            Level level = ((PlayerInteractEvent.RightClickBlock)event).getLevel();
            Intrinsics.checkNotNullExpressionValue((Object)level, (String)"getLevel(...)");
            Player player = ((PlayerInteractEvent.RightClickBlock)event).getEntity();
            Intrinsics.checkNotNullExpressionValue((Object)player, (String)"getEntity(...)");
            InteractionHand interactionHand = ((PlayerInteractEvent.RightClickBlock)event).getHand();
            Intrinsics.checkNotNullExpressionValue((Object)interactionHand, (String)"getHand(...)");
            BlockHitResult blockHitResult = ((PlayerInteractEvent.RightClickBlock)event).getHitVec();
            Intrinsics.checkNotNullExpressionValue((Object)blockHitResult, (String)"getHitVec(...)");
            v4 = (InteractionResult)EventKt.post$default(new InteractionEvent.UseBlock(level, player, interactionHand, blockHitResult), null, (Object)event, null, 5, null);
        } else if (playerInteractEvent instanceof PlayerInteractEvent.LeftClickBlock) {
            Level level = ((PlayerInteractEvent.LeftClickBlock)event).getLevel();
            Intrinsics.checkNotNullExpressionValue((Object)level, (String)"getLevel(...)");
            Player player = ((PlayerInteractEvent.LeftClickBlock)event).getEntity();
            Intrinsics.checkNotNullExpressionValue((Object)player, (String)"getEntity(...)");
            InteractionHand interactionHand = ((PlayerInteractEvent.LeftClickBlock)event).getHand();
            Intrinsics.checkNotNullExpressionValue((Object)interactionHand, (String)"getHand(...)");
            BlockPos blockPos = ((PlayerInteractEvent.LeftClickBlock)event).getPos();
            Intrinsics.checkNotNullExpressionValue((Object)blockPos, (String)"getPos(...)");
            Direction direction = ((PlayerInteractEvent.LeftClickBlock)event).getFace();
            Intrinsics.checkNotNull((Object)direction);
            v4 = (InteractionResult)EventKt.post$default(new InteractionEvent.AttackBlock(level, player, interactionHand, blockPos, direction), null, (Object)event, null, 5, null);
        } else if (playerInteractEvent instanceof PlayerInteractEvent.EntityInteractSpecific) {
            Level level = ((PlayerInteractEvent.EntityInteractSpecific)event).getLevel();
            Intrinsics.checkNotNullExpressionValue((Object)level, (String)"getLevel(...)");
            Player player = ((PlayerInteractEvent.EntityInteractSpecific)event).getEntity();
            Intrinsics.checkNotNullExpressionValue((Object)player, (String)"getEntity(...)");
            InteractionHand interactionHand = ((PlayerInteractEvent.EntityInteractSpecific)event).getHand();
            Intrinsics.checkNotNullExpressionValue((Object)interactionHand, (String)"getHand(...)");
            Entity entity = ((PlayerInteractEvent.EntityInteractSpecific)event).getTarget();
            Intrinsics.checkNotNullExpressionValue((Object)entity, (String)"getTarget(...)");
            v4 = (InteractionResult)EventKt.post$default(new InteractionEvent.UseEntity(level, player, interactionHand, entity, ((PlayerInteractEvent.EntityInteractSpecific)event).getLocalPos(), InteractionEvent.UseEntity.Phase.SPECIFIC), null, (Object)event, null, 5, null);
        } else if (playerInteractEvent instanceof PlayerInteractEvent.EntityInteract) {
            Level level = ((PlayerInteractEvent.EntityInteract)event).getLevel();
            Intrinsics.checkNotNullExpressionValue((Object)level, (String)"getLevel(...)");
            Player player = ((PlayerInteractEvent.EntityInteract)event).getEntity();
            Intrinsics.checkNotNullExpressionValue((Object)player, (String)"getEntity(...)");
            InteractionHand interactionHand = ((PlayerInteractEvent.EntityInteract)event).getHand();
            Intrinsics.checkNotNullExpressionValue((Object)interactionHand, (String)"getHand(...)");
            Entity entity = ((PlayerInteractEvent.EntityInteract)event).getTarget();
            Intrinsics.checkNotNullExpressionValue((Object)entity, (String)"getTarget(...)");
            v4 = (InteractionResult)EventKt.post$default(new InteractionEvent.UseEntity(level, player, interactionHand, entity, null, InteractionEvent.UseEntity.Phase.GENERAL), null, (Object)event, null, 5, null);
        } else if (playerInteractEvent instanceof PlayerInteractEvent.RightClickItem) {
            Level level = ((PlayerInteractEvent.RightClickItem)event).getLevel();
            Intrinsics.checkNotNullExpressionValue((Object)level, (String)"getLevel(...)");
            Player player = ((PlayerInteractEvent.RightClickItem)event).getEntity();
            Intrinsics.checkNotNullExpressionValue((Object)player, (String)"getEntity(...)");
            InteractionHand interactionHand = ((PlayerInteractEvent.RightClickItem)event).getHand();
            Intrinsics.checkNotNullExpressionValue((Object)interactionHand, (String)"getHand(...)");
            v4 = (InteractionResult)EventKt.post$default(new InteractionEvent.UseItem(level, player, interactionHand), null, (Object)event, null, 5, null);
        } else {
            v4 = result = null;
        }
        if (result != null) {
            event.setCancellationResult(result);
            event.setCanceled(result.m_19077_());
        }
    }

    @SubscribeEvent
    public final void onAttackEntity(@NotNull AttackEntityEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Level level = event.getEntity().m_9236_();
        Intrinsics.checkNotNullExpressionValue((Object)level, (String)"level(...)");
        Player player = event.getEntity();
        Intrinsics.checkNotNullExpressionValue((Object)player, (String)"getEntity(...)");
        InteractionHand interactionHand = event.getEntity().m_7655_();
        Intrinsics.checkNotNullExpressionValue((Object)interactionHand, (String)"getUsedItemHand(...)");
        Entity entity = event.getTarget();
        Intrinsics.checkNotNullExpressionValue((Object)entity, (String)"getTarget(...)");
        InteractionResult interactionResult = (InteractionResult)EventKt.post$default(new InteractionEvent.AttackEntity(level, player, interactionHand, entity), null, (Object)event, null, 5, null);
        event.setCanceled(interactionResult != null ? interactionResult.m_19077_() : false);
    }

    @SubscribeEvent
    public final void onEntityTick(@NotNull LivingEvent.LivingTickEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        LivingEntity livingEntity = event.getEntity();
        Intrinsics.checkNotNullExpressionValue((Object)livingEntity, (String)"getEntity(...)");
        event.setCanceled(EventKt.post$default(new LivingEntityEvent.Tick(livingEntity), null, (Object)event, null, 5, null));
    }

    @SubscribeEvent
    public final void onSyncDatapack(@NotNull OnDatapackSyncEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (event.getPlayer() != null) {
            ServerPlayer serverPlayer = event.getPlayer();
            Intrinsics.checkNotNull((Object)serverPlayer);
            EventKt.post$default(new DataPackSyncEvent((Player)serverPlayer, true), null, (Object)event, null, 5, null);
        } else {
            for (ServerPlayer player : event.getPlayerList().m_11314_()) {
                Intrinsics.checkNotNull((Object)player);
                EventKt.post$default(new DataPackSyncEvent((Player)player, false), null, (Object)event, null, 5, null);
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public final void onEntityJoin(@NotNull EntityJoinLevelEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Entity entity = event.getEntity();
        if (Intrinsics.areEqual(entity.getClass(), ItemEntity.class)) {
            Intrinsics.checkNotNull((Object)entity, (String)"null cannot be cast to non-null type net.minecraft.world.entity.item.ItemEntity");
            ItemStack stack = ((ItemEntity)entity).m_32055_();
            Item item = stack.m_41720_();
            Intrinsics.checkNotNullExpressionValue((Object)item, (String)"getItem(...)");
            Item $this$getExtension$iv = item;
            boolean $i$f$getExtension = false;
            CustomEntityItem customEntityItem = (CustomEntityItem)((ItemExtension)ItemExtension.Registry.getExtension(CustomEntityItem.class, $this$getExtension$iv));
            if (customEntityItem != null) {
                ItemEntity itemEntity = (ItemEntity)entity;
                Level level = event.getLevel();
                Intrinsics.checkNotNullExpressionValue((Object)level, (String)"getLevel(...)");
                Intrinsics.checkNotNull((Object)stack);
                Entity newEntity = customEntityItem.createItemEntity(itemEntity, level, stack);
                ((ItemEntity)entity).m_146870_();
                event.setCanceled(true);
                BlockableEventLoop executor = (BlockableEventLoop)LogicalSidedProvider.WORKQUEUE.get(event.getLevel().f_46443_ ? LogicalSide.CLIENT : LogicalSide.SERVER);
                executor.m_6937_((Runnable)new TickTask(0, () -> ForgeEvents.onEntityJoin$lambda$0(event, newEntity)));
            }
        }
        Entity entity2 = event.getEntity();
        Intrinsics.checkNotNullExpressionValue((Object)entity2, (String)"getEntity(...)");
        Level level = event.getLevel();
        Intrinsics.checkNotNullExpressionValue((Object)level, (String)"getLevel(...)");
        event.setCanceled(EventKt.post$default(new EntityCreatedEvent(entity2, level), null, 1, null));
    }

    @SubscribeEvent
    public final void onEntityMount(@NotNull EntityMountEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Entity entity = event.getEntityMounting();
        Intrinsics.checkNotNullExpressionValue((Object)entity, (String)"getEntityMounting(...)");
        MountEvent cynosureEvent = new MountEvent(entity, event.getEntityBeingMounted(), event.isMounting());
        EventKt.post$default(cynosureEvent, null, 1, null);
        if (cynosureEvent.isCancelled()) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public final void onLoadWorld(@NotNull LevelEvent.Load event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        LevelAccessor levelAccessor = event.getLevel();
        Intrinsics.checkNotNull((Object)levelAccessor, (String)"null cannot be cast to non-null type net.minecraft.world.level.Level");
        EventKt.post$default(new LevelEvent.Load((Level)levelAccessor), null, (Object)ForgeEventsKt.access$getDistContext$p(), null, 5, null);
    }

    @SubscribeEvent
    public final void onUnloadWorld(@NotNull LevelEvent.Unload event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        LevelAccessor levelAccessor = event.getLevel();
        Intrinsics.checkNotNull((Object)levelAccessor, (String)"null cannot be cast to non-null type net.minecraft.world.level.Level");
        EventKt.post$default(new LevelEvent.Unload((Level)levelAccessor), null, (Object)ForgeEventsKt.access$getDistContext$p(), null, 5, null);
    }

    @SubscribeEvent
    public final void onSaveWorld(@NotNull LevelEvent.Save event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        LevelAccessor levelAccessor = event.getLevel();
        Intrinsics.checkNotNull((Object)levelAccessor, (String)"null cannot be cast to non-null type net.minecraft.server.level.ServerLevel");
        EventKt.post$default(new LevelEvent.Save((ServerLevel)levelAccessor), null, 1, null);
    }

    @SubscribeEvent
    public final void onTickWorld(@NotNull TickEvent.LevelTickEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        TickEvent.Phase phase = event.phase;
        Intrinsics.checkNotNull((Object)phase);
        LevelEvent e = switch (WhenMappings.$EnumSwitchMapping$0[phase.ordinal()]) {
            case 1 -> {
                Level v1 = event.level;
                Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"level");
                yield new LevelEvent.BeginTick(v1);
            }
            case 2 -> {
                Level v3 = event.level;
                Intrinsics.checkNotNullExpressionValue((Object)v3, (String)"level");
                yield new LevelEvent.EndTick(v3);
            }
            default -> throw new NoWhenBranchMatchedException();
        };
        EventKt.post$default(e, null, (Object)ForgeEventsKt.access$getDistContext$p(), null, 5, null);
    }

    @SubscribeEvent
    public final void onReloadListener(@NotNull AddReloadListenerEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Map<ResourceLocation, PreparableReloadListener> $this$forEach$iv = CynosureHooksImpl.INSTANCE.getSERVER_RELOAD_LISTENERS$cynosure_forge();
        boolean $i$f$forEach = false;
        Iterator<Map.Entry<ResourceLocation, PreparableReloadListener>> iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<ResourceLocation, PreparableReloadListener> element$iv;
            Map.Entry<ResourceLocation, PreparableReloadListener> entry = element$iv = iterator.next();
            boolean i = false;
            PreparableReloadListener listener = entry.getValue();
            event.addListener(listener);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST, receiveCanceled=true)
    public final void furnaceFuel(@NotNull FurnaceFuelBurnTimeEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Item item = event.getItemStack().m_41720_();
        Intrinsics.checkNotNull((Object)item);
        Item $this$getExtension$iv = item;
        boolean $i$f$getExtension = false;
        CustomFurnaceFuel customBurnTime = (CustomFurnaceFuel)((ItemExtension)ItemExtension.Registry.getExtension(CustomFurnaceFuel.class, $this$getExtension$iv));
        if (customBurnTime != null) {
            ItemStack itemStack = event.getItemStack();
            Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"getItemStack(...)");
            Integer n = customBurnTime.getItemBurnTime(itemStack, event.getRecipeType());
            if (n != null) {
                int it = ((Number)n).intValue();
                boolean i = false;
                event.setBurnTime(it);
                event.setCanceled(true);
            }
            return;
        }
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public final void furnaceFuel1(@NotNull FurnaceFuelBurnTimeEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Item item = event.getItemStack().m_41720_();
        if (CynosureHooksImpl.INSTANCE.getBURN_TIME_BY_ITEM$cynosure_forge().containsKey((Object)item)) {
            event.setBurnTime(CynosureHooksImpl.INSTANCE.getBURN_TIME_BY_ITEM$cynosure_forge().getInt((Object)item));
        }
    }

    @SubscribeEvent
    public final void onServerStarting(@NotNull ServerAboutToStartEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        MinecraftServer minecraftServer = event.getServer();
        Intrinsics.checkNotNullExpressionValue((Object)minecraftServer, (String)"getServer(...)");
        EventKt.post$default(new ServerEvent.Starting(minecraftServer), null, (Object)event, null, 5, null);
    }

    @SubscribeEvent
    public final void onServerStarted(@NotNull ServerStartedEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        MinecraftServer minecraftServer = event.getServer();
        Intrinsics.checkNotNullExpressionValue((Object)minecraftServer, (String)"getServer(...)");
        EventKt.post$default(new ServerEvent.Started(minecraftServer), null, (Object)event, null, 5, null);
    }

    @SubscribeEvent
    public final void onServerStopping(@NotNull ServerStoppingEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        MinecraftServer minecraftServer = event.getServer();
        Intrinsics.checkNotNullExpressionValue((Object)minecraftServer, (String)"getServer(...)");
        EventKt.post$default(new ServerEvent.Stopping(minecraftServer), null, (Object)event, null, 5, null);
    }

    @SubscribeEvent
    public final void onServerStopped(@NotNull ServerStoppedEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        MinecraftServer minecraftServer = event.getServer();
        Intrinsics.checkNotNullExpressionValue((Object)minecraftServer, (String)"getServer(...)");
        EventKt.post$default(new ServerEvent.Stopped(minecraftServer), null, (Object)event, null, 5, null);
    }

    @SubscribeEvent
    public final void onServerTick(@NotNull TickEvent.ServerTickEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        TickEvent.Phase phase = event.phase;
        Intrinsics.checkNotNull((Object)phase);
        switch (WhenMappings.$EnumSwitchMapping$0[phase.ordinal()]) {
            case 1: {
                MinecraftServer minecraftServer = event.getServer();
                Intrinsics.checkNotNullExpressionValue((Object)minecraftServer, (String)"getServer(...)");
                boolean bl = EventKt.post$default(new ServerEvent.BeginTick(minecraftServer), null, (Object)event, null, 5, null);
                break;
            }
            case 2: {
                MinecraftServer minecraftServer = event.getServer();
                Intrinsics.checkNotNullExpressionValue((Object)minecraftServer, (String)"getServer(...)");
                boolean bl = EventKt.post$default(new ServerEvent.EndTick(minecraftServer), null, (Object)event, null, 5, null);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
    }

    @SubscribeEvent
    public final void onCommandRegistration(@NotNull RegisterCommandsEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        CommandDispatcher commandDispatcher = event.getDispatcher();
        Intrinsics.checkNotNullExpressionValue((Object)commandDispatcher, (String)"getDispatcher(...)");
        CommandBuildContext commandBuildContext = event.getBuildContext();
        Intrinsics.checkNotNullExpressionValue((Object)commandBuildContext, (String)"getBuildContext(...)");
        Commands.CommandSelection commandSelection = event.getCommandSelection();
        Intrinsics.checkNotNullExpressionValue((Object)commandSelection, (String)"getCommandSelection(...)");
        EventKt.post$default(new CommandRegistrationEvent((CommandDispatcher<CommandSourceStack>)commandDispatcher, commandBuildContext, commandSelection), null, 1, null);
    }

    @SubscribeEvent
    public final void onCommand(@NotNull CommandEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        ParseResults parseResults = event.getParseResults();
        Intrinsics.checkNotNullExpressionValue((Object)parseResults, (String)"getParseResults(...)");
        CommandExecuteEvent evt = new CommandExecuteEvent((ParseResults<CommandSourceStack>)parseResults, event.getException());
        event.setCanceled(EventKt.post$default(evt, null, 1, null));
        event.setException(evt.getException());
        event.setParseResults(evt.getParseResults());
    }

    @SubscribeEvent
    public final void onPlayerTick(@NotNull TickEvent.PlayerTickEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        TickEvent.Phase phase = event.phase;
        switch (phase == null ? -1 : WhenMappings.$EnumSwitchMapping$0[phase.ordinal()]) {
            case 1: {
                Player player = event.player;
                Intrinsics.checkNotNullExpressionValue((Object)player, (String)"player");
                boolean bl = EventKt.post$default(new PlayerTickEvent.Begin(player), null, (Object)event, null, 5, null);
                break;
            }
            case 2: {
                Player player = event.player;
                Intrinsics.checkNotNullExpressionValue((Object)player, (String)"player");
                boolean bl = EventKt.post$default(new PlayerTickEvent.End(player), null, (Object)event, null, 5, null);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
    }

    @SubscribeEvent
    public final void onStartTracking(@NotNull PlayerEvent.StartTracking event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (event.getEntity() instanceof ServerPlayer) {
            Entity entity = event.getTarget();
            Intrinsics.checkNotNullExpressionValue((Object)entity, (String)"getTarget(...)");
            Player player = event.getEntity();
            Intrinsics.checkNotNull((Object)player, (String)"null cannot be cast to non-null type net.minecraft.server.level.ServerPlayer");
            EventKt.post$default(new EntityTrackingEvent.Start(entity, (ServerPlayer)player), null, 1, null);
        }
    }

    @SubscribeEvent
    public final void onStopTracking(@NotNull PlayerEvent.StopTracking event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (event.getEntity() instanceof ServerPlayer) {
            Entity entity = event.getTarget();
            Intrinsics.checkNotNullExpressionValue((Object)entity, (String)"getTarget(...)");
            Player player = event.getEntity();
            Intrinsics.checkNotNull((Object)player, (String)"null cannot be cast to non-null type net.minecraft.server.level.ServerPlayer");
            EventKt.post$default(new EntityTrackingEvent.Start(entity, (ServerPlayer)player), null, 1, null);
        }
    }

    @SubscribeEvent
    public final void onChat(@NotNull net.minecraftforge.event.ServerChatEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        ServerPlayer serverPlayer = event.getPlayer();
        Intrinsics.checkNotNullExpressionValue((Object)serverPlayer, (String)"getPlayer(...)");
        Component component = event.getMessage();
        Intrinsics.checkNotNullExpressionValue((Object)component, (String)"getMessage(...)");
        String string = event.getRawText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getRawText(...)");
        ServerChatEvent serverChatEvent = new ServerChatEvent(serverPlayer, component, string);
        EventKt.post$default(serverChatEvent, null, 1, null);
        if (serverChatEvent.isCancelled()) {
            event.setCanceled(true);
        } else {
            event.setMessage(serverChatEvent.getMessage());
        }
    }

    @SubscribeEvent
    public final void onEntityEffectAdded(@NotNull MobEffectEvent.Added event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        LivingEntity livingEntity = event.getEntity();
        Intrinsics.checkNotNullExpressionValue((Object)livingEntity, (String)"getEntity(...)");
        MobEffectInstance mobEffectInstance = event.getEffectInstance();
        Intrinsics.checkNotNullExpressionValue((Object)mobEffectInstance, (String)"getEffectInstance(...)");
        EventKt.post$default(new LivingEntityEvent.EffectApply(livingEntity, mobEffectInstance, event.getOldEffectInstance(), null, 8, null), null, (Object)event, null, 5, null);
    }

    @SubscribeEvent
    public final void onEntityEffectRemoved(@NotNull MobEffectEvent.Remove event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        LivingEntity livingEntity = event.getEntity();
        Intrinsics.checkNotNullExpressionValue((Object)livingEntity, (String)"getEntity(...)");
        EventKt.post$default(new LivingEntityEvent.EffectRemove(livingEntity, event.getEffectInstance(), null, 4, null), null, (Object)event, null, 5, null);
    }

    @SubscribeEvent
    public final void onEntityEffectExpired(@NotNull MobEffectEvent.Expired event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        LivingEntity livingEntity = event.getEntity();
        Intrinsics.checkNotNullExpressionValue((Object)livingEntity, (String)"getEntity(...)");
        EventKt.post$default(new LivingEntityEvent.EffectExpire(livingEntity, event.getEffectInstance(), null, 4, null), null, (Object)event, null, 5, null);
    }

    private static final void onEntityJoin$lambda$0(EntityJoinLevelEvent $event, Entity $newEntity) {
        $event.getLevel().m_7967_($newEntity);
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[TickEvent.Phase.values().length];
            try {
                nArray[TickEvent.Phase.START.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TickEvent.Phase.END.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

