/*
 * Decompiled with CFR 0.152.
 */
package dev.mayaqq.cynosure.forge.mixin;

import com.google.common.collect.ImmutableMap;
import com.llamalad7.mixinextras.injector.ModifyReturnValue;
import com.llamalad7.mixinextras.sugar.Local;
import dev.mayaqq.cynosure.events.api.MainBus;
import dev.mayaqq.cynosure.events.world.LoottableEvents;
import dev.mayaqq.cynosure.loot.LootilsKt;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.world.level.storage.loot.LootDataId;
import net.minecraft.world.level.storage.loot.LootDataManager;
import net.minecraft.world.level.storage.loot.LootTable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;

@Mixin(value={LootDataManager.class})
public class LootDataManagerMixin {
    @Shadow
    private Map<LootDataId<?>, ?> f_278415_;

    @ModifyReturnValue(method={"m_5540_(Lnet/minecraft/server/packs/resources/PreparableReloadListener$PreparationBarrier;Lnet/minecraft/server/packs/resources/ResourceManager;Lnet/minecraft/util/profiling/ProfilerFiller;Lnet/minecraft/util/profiling/ProfilerFiller;Ljava/util/concurrent/Executor;Ljava/util/concurrent/Executor;)Ljava/util/concurrent/CompletableFuture;"}, at={@At(value="RETURN")})
    private CompletableFuture<Void> addCynosureLootTables(CompletableFuture<Void> original, @Local(argsOnly=true) ResourceManager manager) {
        return original.thenRun(() -> this.cynosure$applyCynosureLootTables(manager, (LootDataManager)this));
    }

    @Unique
    private void cynosure$applyCynosureLootTables(ResourceManager resourceManager, LootDataManager lootManager) {
        ImmutableMap.Builder newTables = ImmutableMap.builder();
        this.f_278415_.forEach((dataKey, entry) -> {
            if (dataKey == LootDataManager.f_278474_) {
                newTables.put(dataKey, entry);
                return;
            }
            if (!(entry instanceof LootTable)) {
                newTables.put(dataKey, entry);
                return;
            }
            LootTable table = (LootTable)entry;
            LoottableEvents.Replace replace = new LoottableEvents.Replace(resourceManager, lootManager, dataKey.f_278500_(), table);
            MainBus.INSTANCE.post(replace);
            LootTable replacement = (LootTable)replace.getResult();
            if (replacement != null) {
                table = replacement;
            }
            LootTable.Builder builder = LootilsKt.copy(table);
            MainBus.INSTANCE.post(new LoottableEvents.Modify(resourceManager, lootManager, dataKey.f_278500_(), builder));
            LootTable newTable = builder.m_79167_();
            ResourceLocation id = table.getLootTableId();
            if (id != null) {
                newTable.setLootTableId(id);
            }
            newTables.put(dataKey, (Object)newTable);
        });
        this.f_278415_ = newTables.build();
        MainBus.INSTANCE.post(new LoottableEvents.AllLoaded(resourceManager, lootManager));
    }
}

