/*
 * Decompiled with CFR 0.152.
 */
package dev.mayaqq.cynosure.utils;

import java.util.EnumMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.apache.commons.lang3.mutable.MutableObject;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\u000f\u001a'\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u00000\u0003*\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0001\u00a2\u0006\u0004\b\u0004\u0010\u0005\u001a'\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00000\u0003*\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\b\u001a'\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00000\u0003*\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0006\u00a2\u0006\u0004\b\t\u0010\b\u001a\u0019\u0010\f\u001a\u00020\u0000*\u00020\u00002\u0006\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0004\b\f\u0010\r\u001a!\u0010\u0011\u001a\u00020\n*\u00020\n2\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u0001\u00a2\u0006\u0004\b\u0011\u0010\u0012\u001a\u0019\u0010\u0013\u001a\u00020\u000e*\u00020\u00002\u0006\u0010\u0010\u001a\u00020\u0001\u00a2\u0006\u0004\b\u0013\u0010\u0014\u001a\u001b\u0010\u0016\u001a\u00020\u0006*\u00020\u00062\u0006\u0010\u0015\u001a\u00020\u0006H\u0002\u00a2\u0006\u0004\b\u0016\u0010\u0017\u001a\u001b\u0010\u0018\u001a\u00020\u0006*\u00020\u00062\u0006\u0010\u0002\u001a\u00020\u0006H\u0002\u00a2\u0006\u0004\b\u0018\u0010\u0017\u001a\u0017\u0010\u001a\u001a\u00020\n2\u0006\u0010\u0019\u001a\u00020\u0006H\u0002\u00a2\u0006\u0004\b\u001a\u0010\u001b\u001a\u0017\u0010\u001c\u001a\u00020\n2\u0006\u0010\u0019\u001a\u00020\u0006H\u0002\u00a2\u0006\u0004\b\u001c\u0010\u001b\u00a8\u0006\u001d"}, d2={"Lnet/minecraft/world/phys/shapes/VoxelShape;", "Lnet/minecraft/core/Direction$Axis;", "initial", "", "allAxis", "(Lnet/minecraft/world/phys/shapes/VoxelShape;Lnet/minecraft/core/Direction$Axis;)Ljava/util/Map;", "Lnet/minecraft/core/Direction;", "allDirections", "(Lnet/minecraft/world/phys/shapes/VoxelShape;Lnet/minecraft/core/Direction;)Ljava/util/Map;", "allHorizontalDirections", "Lnet/minecraft/world/phys/Vec3;", "rotation", "rotatedCopy", "(Lnet/minecraft/world/phys/shapes/VoxelShape;Lnet/minecraft/world/phys/Vec3;)Lnet/minecraft/world/phys/shapes/VoxelShape;", "", "deg", "axis", "rotated", "(Lnet/minecraft/world/phys/Vec3;DLnet/minecraft/core/Direction$Axis;)Lnet/minecraft/world/phys/Vec3;", "length", "(Lnet/minecraft/world/phys/shapes/VoxelShape;Lnet/minecraft/core/Direction$Axis;)D", "initialDirection", "shiftToUp", "(Lnet/minecraft/core/Direction;Lnet/minecraft/core/Direction;)Lnet/minecraft/core/Direction;", "shiftHorizontalToSouth", "direction", "getDirectionRotationVec", "(Lnet/minecraft/core/Direction;)Lnet/minecraft/world/phys/Vec3;", "getHorizontalDirectionRotationVec", "cynosure_forge"})
public final class ShapeUtilsKt {
    @NotNull
    public static final Map<Direction.Axis, VoxelShape> allAxis(@NotNull VoxelShape $this$allAxis, @NotNull Direction.Axis initial) {
        Intrinsics.checkNotNullParameter((Object)$this$allAxis, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)initial, (String)"initial");
        Map map2 = new EnumMap(Direction.Axis.class);
        Direction initialDir = Direction.m_122387_((Direction.Axis)initial, (Direction.AxisDirection)Direction.AxisDirection.POSITIVE);
        for (Direction.Axis axis : EntriesMappings.entries$0) {
            Direction direction = Direction.m_122387_((Direction.Axis)axis, (Direction.AxisDirection)Direction.AxisDirection.POSITIVE);
            Intrinsics.checkNotNullExpressionValue((Object)direction, (String)"fromAxisAndDirection(...)");
            Intrinsics.checkNotNull((Object)initialDir);
            Vec3 dir = ShapeUtilsKt.getDirectionRotationVec(ShapeUtilsKt.shiftToUp(direction, initialDir));
            map2.put(axis, ShapeUtilsKt.rotatedCopy($this$allAxis, dir));
        }
        return map2;
    }

    public static /* synthetic */ Map allAxis$default(VoxelShape voxelShape, Direction.Axis axis, int i, Object object) {
        if ((i & 1) != 0) {
            axis = Direction.Axis.Y;
        }
        return ShapeUtilsKt.allAxis(voxelShape, axis);
    }

    @NotNull
    public static final Map<Direction, VoxelShape> allDirections(@NotNull VoxelShape $this$allDirections, @NotNull Direction initial) {
        Intrinsics.checkNotNullParameter((Object)$this$allDirections, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)initial, (String)"initial");
        Map map2 = new EnumMap(Direction.class);
        for (Direction dir : EntriesMappings.entries$1) {
            map2.put(dir, ShapeUtilsKt.rotatedCopy($this$allDirections, ShapeUtilsKt.getDirectionRotationVec(ShapeUtilsKt.shiftToUp(dir, initial))));
        }
        return map2;
    }

    public static /* synthetic */ Map allDirections$default(VoxelShape voxelShape, Direction direction, int i, Object object) {
        if ((i & 1) != 0) {
            direction = Direction.UP;
        }
        return ShapeUtilsKt.allDirections(voxelShape, direction);
    }

    @NotNull
    public static final Map<Direction, VoxelShape> allHorizontalDirections(@NotNull VoxelShape $this$allHorizontalDirections, @NotNull Direction initial) {
        Intrinsics.checkNotNullParameter((Object)$this$allHorizontalDirections, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)initial, (String)"initial");
        Map map2 = new EnumMap(Direction.class);
        for (Direction dir : EntriesMappings.entries$1) {
            map2.put(dir, ShapeUtilsKt.rotatedCopy($this$allHorizontalDirections, ShapeUtilsKt.getHorizontalDirectionRotationVec(ShapeUtilsKt.shiftHorizontalToSouth(dir, initial))));
        }
        return map2;
    }

    public static /* synthetic */ Map allHorizontalDirections$default(VoxelShape voxelShape, Direction direction, int i, Object object) {
        if ((i & 1) != 0) {
            direction = Direction.SOUTH;
        }
        return ShapeUtilsKt.allHorizontalDirections(voxelShape, direction);
    }

    @NotNull
    public static final VoxelShape rotatedCopy(@NotNull VoxelShape $this$rotatedCopy, @NotNull Vec3 rotation) {
        Intrinsics.checkNotNullParameter((Object)$this$rotatedCopy, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)rotation, (String)"rotation");
        if (Intrinsics.areEqual((Object)rotation, (Object)Vec3.f_82478_)) {
            return $this$rotatedCopy;
        }
        MutableObject result = new MutableObject((Object)Shapes.m_83040_());
        Vec3 center = new Vec3(8.0, 8.0, 8.0);
        $this$rotatedCopy.m_83286_((arg_0, arg_1, arg_2, arg_3, arg_4, arg_5) -> ShapeUtilsKt.rotatedCopy$lambda$0(center, rotation, result, arg_0, arg_1, arg_2, arg_3, arg_4, arg_5));
        Object object = result.getValue();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getValue(...)");
        return (VoxelShape)object;
    }

    @NotNull
    public static final Vec3 rotated(@NotNull Vec3 $this$rotated, double deg, @NotNull Direction.Axis axis) {
        Intrinsics.checkNotNullParameter((Object)$this$rotated, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)axis, (String)"axis");
        if (deg == 0.0) {
            return $this$rotated;
        }
        if ($this$rotated == Vec3.f_82478_) {
            return $this$rotated;
        }
        float angle = (float)(deg / (double)180.0f * Math.PI);
        double sin = Mth.m_14031_((float)angle);
        double cos = Mth.m_14089_((float)angle);
        double x = $this$rotated.f_82479_;
        double y = $this$rotated.f_82480_;
        double z = $this$rotated.f_82481_;
        return switch (WhenMappings.$EnumSwitchMapping$0[axis.ordinal()]) {
            case 1 -> new Vec3(x, y * cos - z * sin, z * cos + y * sin);
            case 2 -> new Vec3(x * cos + z * sin, y, z * cos - x * sin);
            case 3 -> new Vec3(x * cos - y * sin, y * cos + x * sin, z);
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    public static final double length(@NotNull VoxelShape $this$length, @NotNull Direction.Axis axis) {
        Intrinsics.checkNotNullParameter((Object)$this$length, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)axis, (String)"axis");
        return $this$length.m_83281_() ? 0.0 : $this$length.m_83297_(axis) - $this$length.m_83288_(axis);
    }

    private static final Direction shiftToUp(Direction $this$shiftToUp, Direction initialDirection) {
        Direction direction;
        switch (WhenMappings.$EnumSwitchMapping$1[initialDirection.ordinal()]) {
            case 1: {
                direction = $this$shiftToUp;
                break;
            }
            case 2: {
                Direction direction2 = $this$shiftToUp.m_122424_();
                direction = direction2;
                Intrinsics.checkNotNullExpressionValue((Object)direction2, (String)"getOpposite(...)");
                break;
            }
            default: {
                Direction.Axis rotateAxis = initialDirection.m_122434_() == Direction.Axis.Z ? Direction.Axis.X : Direction.Axis.Z;
                Direction direction3 = $this$shiftToUp.m_122421_() == Direction.AxisDirection.POSITIVE ? $this$shiftToUp.m_175362_(rotateAxis) : $this$shiftToUp.m_175364_(rotateAxis);
                Intrinsics.checkNotNull((Object)direction3);
                direction = direction3;
            }
        }
        return direction;
    }

    private static final Direction shiftHorizontalToSouth(Direction $this$shiftHorizontalToSouth, Direction initial) {
        Direction direction;
        switch (WhenMappings.$EnumSwitchMapping$1[initial.ordinal()]) {
            case 3: {
                direction = $this$shiftHorizontalToSouth;
                break;
            }
            case 4: {
                Direction direction2 = $this$shiftHorizontalToSouth.m_122424_();
                direction = direction2;
                Intrinsics.checkNotNullExpressionValue((Object)direction2, (String)"getOpposite(...)");
                break;
            }
            case 5: {
                Direction direction3 = $this$shiftHorizontalToSouth.m_122427_();
                direction = direction3;
                Intrinsics.checkNotNullExpressionValue((Object)direction3, (String)"getClockWise(...)");
                break;
            }
            case 6: {
                Direction direction4 = $this$shiftHorizontalToSouth.m_122428_();
                direction = direction4;
                Intrinsics.checkNotNullExpressionValue((Object)direction4, (String)"getCounterClockWise(...)");
                break;
            }
            default: {
                throw new IllegalStateException("Not a horizontal direction".toString());
            }
        }
        return direction;
    }

    private static final Vec3 getDirectionRotationVec(Direction direction) {
        Vec3 vec3;
        if (direction == Direction.UP) {
            Vec3 vec32 = Vec3.f_82478_;
            vec3 = vec32;
            Intrinsics.checkNotNullExpressionValue((Object)vec32, (String)"ZERO");
        } else {
            vec3 = new Vec3((double)(Direction.Plane.VERTICAL.test(direction) ? 180 : 90), -((double)((float)((int)Math.max((double)direction.m_122416_(), 0.0) & 3) * 90.0f)), 0.0);
        }
        return vec3;
    }

    private static final Vec3 getHorizontalDirectionRotationVec(Direction direction) {
        Vec3 vec3;
        if (direction == Direction.SOUTH) {
            Vec3 vec32 = Vec3.f_82478_;
            vec3 = vec32;
            Intrinsics.checkNotNullExpressionValue((Object)vec32, (String)"ZERO");
        } else {
            vec3 = new Vec3(0.0, -((double)((float)((int)Math.max((double)direction.m_122416_(), 0.0) & 3) * 90.0f)), 0.0);
        }
        return vec3;
    }

    private static final void rotatedCopy$lambda$0(Vec3 $center, Vec3 $rotation, MutableObject $result, double x1, double y1, double z1, double x2, double y2, double z2) {
        Vec3 v1 = new Vec3(x1, y1, z1).m_82490_(16.0).m_82546_($center);
        Vec3 v2 = new Vec3(x2, y2, z2).m_82490_(16.0).m_82546_($center);
        Vec3 vec3 = v1;
        Intrinsics.checkNotNull((Object)vec3);
        v1 = ShapeUtilsKt.rotated(vec3, (float)$rotation.f_82479_, Direction.Axis.X);
        v1 = ShapeUtilsKt.rotated(v1, (float)$rotation.f_82480_, Direction.Axis.Y);
        v1 = ShapeUtilsKt.rotated(v1, (float)$rotation.f_82481_, Direction.Axis.Z).m_82549_($center);
        vec3 = v2;
        Intrinsics.checkNotNull((Object)vec3);
        v2 = ShapeUtilsKt.rotated(vec3, (float)$rotation.f_82479_, Direction.Axis.X);
        v2 = ShapeUtilsKt.rotated(v2, (float)$rotation.f_82480_, Direction.Axis.Y);
        v2 = ShapeUtilsKt.rotated(v2, (float)$rotation.f_82481_, Direction.Axis.Z).m_82549_($center);
        VoxelShape rotated = Block.m_49796_((double)Math.min(v1.f_82479_, v2.f_82479_), (double)Math.min(v1.f_82480_, v2.f_82480_), (double)Math.min(v1.f_82481_, v2.f_82481_), (double)Math.max(v1.f_82479_, v2.f_82479_), (double)Math.max(v1.f_82480_, v2.f_82480_), (double)Math.max(v1.f_82481_, v2.f_82481_));
        $result.setValue((Object)Shapes.m_83110_((VoxelShape)((VoxelShape)$result.getValue()), (VoxelShape)rotated));
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public static final class EntriesMappings {
        public static final /* synthetic */ EnumEntries<Direction.Axis> entries$0;
        public static final /* synthetic */ EnumEntries<Direction> entries$1;

        static {
            entries$0 = EnumEntriesKt.enumEntries((Enum[])((Enum[])Direction.Axis.values()));
            entries$1 = EnumEntriesKt.enumEntries((Enum[])((Enum[])Direction.values()));
        }
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[Direction.Axis.values().length];
            try {
                nArray[Direction.Axis.X.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Direction.Axis.Y.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Direction.Axis.Z.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[Direction.values().length];
            try {
                nArray[Direction.UP.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Direction.DOWN.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Direction.SOUTH.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Direction.NORTH.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Direction.WEST.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Direction.EAST.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
        }
    }
}

