/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.herbalbrews.core.effects;

import java.util.List;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;

public class LifeleechEffect
extends MobEffect {
    private static final int RADIUS = 10;
    private static final int TRANSFER_INTERVAL = 160;

    public LifeleechEffect() {
        super(MobEffectCategory.BENEFICIAL, 65280);
    }

    public void m_6742_(LivingEntity entity, int amplifier) {
        Player player;
        if (entity instanceof Player && (player = (Player)entity).m_6084_()) {
            Level world = player.m_9236_();
            List nearbyPlayers = world.m_6443_(Player.class, player.m_20191_().m_82400_(10.0), this::isAffectedEntity);
            int playerCount = nearbyPlayers.size() - 1;
            int finalAmplifier = this.calculateFinalAmplifier(playerCount = Math.max(playerCount, 0));
            if (finalAmplifier > 0) {
                nearbyPlayers.stream().filter(p -> p.m_6084_() && p != player && !p.m_7500_()).forEach(p -> this.applyEffect((Player)p, finalAmplifier));
            }
            if (this.isTransferTime(entity)) {
                this.transferHealth(player);
            }
        }
    }

    private int calculateFinalAmplifier(int playerCount) {
        float baseAmplifier = 1.0f;
        float reductionPerPlayer = 0.1f;
        float calculatedAmplifier = baseAmplifier - (float)playerCount * reductionPerPlayer;
        calculatedAmplifier = Math.max(calculatedAmplifier, 0.0f);
        return Math.min(Math.round(calculatedAmplifier), 3);
    }

    private void applyEffect(Player player, int amplifier) {
        player.m_7292_(new MobEffectInstance((MobEffect)this, 200, amplifier, false, false, false));
    }

    private boolean isAffectedEntity(Player player) {
        return player.m_6084_() && !player.m_7500_();
    }

    private boolean isTransferTime(LivingEntity entity) {
        return entity.f_19797_ % 160 == 0;
    }

    private void transferHealth(Player player) {
        Level world = player.m_9236_();
        List enemies = world.m_6443_(LivingEntity.class, player.m_20191_().m_82400_(10.0), this::isEnemy);
        for (LivingEntity enemy : enemies) {
            if (!(enemy.m_21223_() > 0.0f)) continue;
            enemy.m_21153_(Math.max(enemy.m_21223_() - 1.0f, 0.0f));
            player.m_21153_(Math.min(player.m_21223_() + 1.0f, player.m_21233_()));
        }
    }

    private boolean isEnemy(LivingEntity entity) {
        return entity instanceof Monster;
    }

    public boolean m_6584_(int duration, int amplifier) {
        return true;
    }
}

