/*
 * Decompiled with CFR 0.152.
 */
package de.chrisimo.vegandelight;

import com.google.common.collect.Multimap;
import com.google.common.collect.MultimapBuilder;
import de.chrisimo.vegandelight.item.ModItems;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import org.jetbrains.annotations.ApiStatus;

public abstract class ReplacementMap {
    private static final Multimap<Item, Item> map = MultimapBuilder.hashKeys().arrayListValues().build();
    private static final Style textStyle;
    private static final Style itemNameStyle;

    public static void registerReplacement(Item replacement, Item original) {
        map.put((Object)replacement, (Object)original);
    }

    public static Collection<Item> replaces(Item item) {
        return map.get((Object)item);
    }

    @ApiStatus.Internal
    public static void addTooltipLines(Item item, List<Component> tooltip) {
        Collection<Item> replacedItem = ReplacementMap.replaces(item);
        if (replacedItem.isEmpty()) {
            return;
        }
        MutableComponent nameList = ReplacementMap.createItemList(replacedItem);
        tooltip.add(1, (Component)Component.m_237110_((String)"tooltip.vegandelight.replaces", (Object[])new Object[]{nameList.m_6270_(itemNameStyle)}).m_6270_(textStyle));
    }

    private static MutableComponent createItemList(Collection<Item> items) {
        MutableComponent nameList = Component.m_237119_();
        Iterator<Item> iter = items.iterator();
        nameList.m_7220_((Component)Component.m_237115_((String)iter.next().m_5524_()));
        iter.forEachRemaining(it -> nameList.m_130946_(", ").m_7220_((Component)Component.m_237115_((String)it.m_5524_())));
        return nameList;
    }

    static {
        ReplacementMap.registerReplacement((Item)ModItems.LEATHER_SUBSTITUTE.get(), Items.f_42454_);
        ReplacementMap.registerReplacement((Item)ModItems.SOYMILK_BUCKET.get(), Items.f_42455_);
        ReplacementMap.registerReplacement((Item)ModItems.SOYMILK_BOTTLE.get(), (Item)vectorwing.farmersdelight.common.registry.ModItems.MILK_BOTTLE.get());
        ReplacementMap.registerReplacement((Item)ModItems.SILKEN_TOFU.get(), Items.f_42521_);
        ReplacementMap.registerReplacement((Item)ModItems.MINCED_TOFU.get(), (Item)vectorwing.farmersdelight.common.registry.ModItems.MINCED_BEEF.get());
        ReplacementMap.registerReplacement((Item)ModItems.TOFU_PATTY.get(), (Item)vectorwing.farmersdelight.common.registry.ModItems.BEEF_PATTY.get());
        ReplacementMap.registerReplacement((Item)ModItems.TOFISH.get(), Items.f_42526_);
        ReplacementMap.registerReplacement((Item)ModItems.SMOKED_TOFISH.get(), Items.f_42527_);
        ReplacementMap.registerReplacement((Item)ModItems.COOKED_TOFISH.get(), Items.f_42530_);
        ReplacementMap.registerReplacement((Item)ModItems.COOKED_SMOKED_TOFISH.get(), Items.f_42531_);
        ReplacementMap.registerReplacement((Item)ModItems.TOFISH_ROLL.get(), (Item)vectorwing.farmersdelight.common.registry.ModItems.COD_ROLL.get());
        ReplacementMap.registerReplacement((Item)ModItems.SMOKED_TOFISH_ROLL.get(), (Item)vectorwing.farmersdelight.common.registry.ModItems.SALMON_ROLL.get());
        ReplacementMap.registerReplacement((Item)ModItems.TOFU_SLICES.get(), Items.f_42658_);
        ReplacementMap.registerReplacement((Item)ModItems.TOFU_SLICES.get(), Items.f_42581_);
        ReplacementMap.registerReplacement((Item)ModItems.SMOKED_TOFU_SLICES.get(), Items.f_42485_);
        ReplacementMap.registerReplacement((Item)ModItems.COOKED_TOFU_SLICES.get(), Items.f_42659_);
        ReplacementMap.registerReplacement((Item)ModItems.COOKED_TOFU_SLICES.get(), Items.f_42582_);
        ReplacementMap.registerReplacement((Item)ModItems.COOKED_SMOKED_TOFU_SLICES.get(), Items.f_42486_);
        textStyle = Style.f_131099_.m_178520_(0x555555).m_131155_(Boolean.valueOf(true));
        itemNameStyle = Style.f_131099_.m_178520_(0x999999).m_131155_(Boolean.valueOf(true));
    }
}

