/*
 * Decompiled with CFR 0.152.
 */
package de.chrisimo.vegandelight.block;

import de.chrisimo.vegandelight.block.custom.SoybeanCropBlock;
import de.chrisimo.vegandelight.item.ModItems;
import java.util.function.Supplier;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.FlowerBlock;
import net.minecraft.world.level.block.FlowerPotBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;

public class ModBlocks {
    public static final DeferredRegister<Block> BLOCKS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BLOCKS, (String)"vegandelight");
    public static final RegistryObject<Block> SOYBEAN_CROP = BLOCKS.register("soybean_crop", () -> new SoybeanCropBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50092_).m_60955_().m_60910_()));
    public static final RegistryObject<Block> WILD_SOYBEAN = ModBlocks.registerBlock("wild_soybean", () -> new FlowerBlock(() -> MobEffects.f_19621_, 5, BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50114_).m_60910_().m_60955_()));
    public static final RegistryObject<Block> POTTED_WILD_SOYBEAN = BLOCKS.register("potted_wild_soybean", () -> new FlowerPotBlock(() -> (FlowerPotBlock)Blocks.f_50276_, WILD_SOYBEAN, BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50235_).m_60955_()));
    public static final RegistryObject<Block> SOYBEAN_BAG = ModBlocks.registerBlock("soybean_bag", () -> new Block(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50041_)));

    private static <T extends Block> RegistryObject<T> registerBlock(String name, Supplier<T> block) {
        RegistryObject toReturn = BLOCKS.register(name, block);
        ModBlocks.registerBlockItem(name, toReturn);
        return toReturn;
    }

    private static <T extends Block> RegistryObject<Item> registerBlockItem(String name, RegistryObject<T> block) {
        return ModItems.ITEMS.register(name, () -> new BlockItem((Block)block.get(), new Item.Properties()));
    }

    public static void register(IEventBus eventBus) {
        BLOCKS.register(eventBus);
    }
}

