/*
 * Decompiled with CFR 0.152.
 */
package de.chrisimo.vegandelight.item;

import net.minecraft.core.Direction;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidType;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class VeganFluidHandler
implements IFluidHandlerItem,
ICapabilityProvider {
    private ItemStack current;
    private final Item full;
    private final Item empty;
    private final FluidStack fluidStack;
    private final FluidType type;
    private final int capacity;

    public VeganFluidHandler(Item full, Item empty, boolean defaultFull, Fluid fluid, int capacity) {
        if (defaultFull) {
            this.current = new ItemStack((ItemLike)full);
            this.fluidStack = new FluidStack(fluid, capacity);
        } else {
            this.current = new ItemStack((ItemLike)empty);
            this.fluidStack = FluidStack.EMPTY;
        }
        this.full = full;
        this.empty = empty;
        this.type = fluid.getFluidType();
        this.capacity = capacity;
    }

    @NotNull
    public ItemStack getContainer() {
        return this.current;
    }

    public int getTanks() {
        return 1;
    }

    @NotNull
    public FluidStack getFluidInTank(int tank) {
        return this.fluidStack;
    }

    public int getTankCapacity(int tank) {
        return this.capacity;
    }

    public boolean isFluidValid(int tank, FluidStack stack) {
        return stack.isFluidEqual(this.fluidStack);
    }

    public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
        if (this.current.m_41613_() != 1 || resource.getAmount() < this.capacity || !this.fluidStack.isEmpty() || resource.getFluid().getFluidType() != this.type) {
            return 0;
        }
        if (action.execute()) {
            this.current = new ItemStack((ItemLike)this.full);
        }
        return this.capacity;
    }

    @NotNull
    public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction action) {
        if (this.current.m_41613_() != 1 || resource.getAmount() < this.capacity) {
            return FluidStack.EMPTY;
        }
        if (!this.fluidStack.isEmpty() && FluidStack.areFluidStackTagsEqual((FluidStack)this.fluidStack, (FluidStack)resource)) {
            if (action.execute()) {
                this.current = new ItemStack((ItemLike)this.empty);
            }
            return this.fluidStack;
        }
        return FluidStack.EMPTY;
    }

    @NotNull
    public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
        if (this.current.m_41613_() != 1 || maxDrain < this.capacity) {
            return FluidStack.EMPTY;
        }
        if (!this.fluidStack.isEmpty()) {
            if (action.execute()) {
                this.current = new ItemStack((ItemLike)this.empty);
            }
            return this.fluidStack;
        }
        return FluidStack.EMPTY;
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        return ForgeCapabilities.FLUID_HANDLER_ITEM.orEmpty(cap, LazyOptional.of(() -> this));
    }
}

