/*
 * Decompiled with CFR 0.152.
 */
package net.player005.vegandelightfabric.labels;

import com.google.common.base.Stopwatch;
import com.google.common.collect.ImmutableCollection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.ChatFormatting;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.player005.recipe_modification.api.RecipeModification;
import net.player005.vegandelightfabric.labels.VeganNBT;
import net.player005.vegandelightfabric.labels.VeganTags;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;
import org.slf4j.LoggerFactory;

public class VeganLabels {
    private static final Map<Item, VeganStatus> veganFromRecipes = new HashMap<Item, VeganStatus>();
    private static boolean debugMode = false;

    @ApiStatus.Internal
    public static void initialize() {
        RecipeModification.registerGlobalResultModifier((recipe, result, recipeInput) -> {
            if (recipeInput != null) {
                ArrayList<ItemStack> list = new ArrayList<ItemStack>();
                for (int i = 0; i < recipeInput.m_6643_(); ++i) {
                    ItemStack stack = recipeInput.m_8020_(i);
                    if (stack.m_41619_()) continue;
                    list.add(stack);
                }
                VeganLabels.modifyRecipeResult(list, result);
            }
            return result;
        });
        Stopwatch timer = Stopwatch.createStarted();
        ArrayList<Item> traversedList = new ArrayList<Item>(BuiltInRegistries.f_257033_.m_13562_());
        for (Item item : BuiltInRegistries.f_257033_) {
            if (traversedList.contains(item)) continue;
            VeganLabels.scanRecipesRecursively(item, traversedList);
        }
        LoggerFactory.getLogger(VeganLabels.class).info("Scanned {} items for vegan recipes in {}", (Object)BuiltInRegistries.f_257033_.m_13562_(), (Object)timer);
    }

    public static VeganStatus isVegan(ItemStack itemStack) {
        Boolean fromComponent = VeganNBT.getVeganFromNBT(itemStack);
        if (fromComponent != null) {
            return VeganStatus.fromBoolean(fromComponent);
        }
        if (itemStack.m_204117_(VeganTags.VEGAN)) {
            return VeganStatus.VEGAN;
        }
        if (itemStack.m_204117_(VeganTags.NOT_VEGAN)) {
            return VeganStatus.NOT_VEGAN;
        }
        return veganFromRecipes.getOrDefault(itemStack.m_41720_(), VeganStatus.UNKNOWN);
    }

    public static void setIsVegan(ItemStack stack, boolean isVegan) {
        boolean isFood;
        boolean bl = isFood = stack.m_204117_(VeganTags.SHOULD_HAVE_DATA_COMPONENTS_ADDED) || stack.m_41780_() == UseAnim.EAT || stack.m_41780_() == UseAnim.DRINK;
        if (!isFood && !VeganNBT.containsSubstitute(stack)) {
            return;
        }
        VeganStatus currentStatus = VeganLabels.isVegan(stack);
        if (VeganNBT.hasVeganNBTTag(stack)) {
            return;
        }
        if (isVegan && (currentStatus == VeganStatus.VEGAN || currentStatus == VeganStatus.UNKNOWN)) {
            return;
        }
        if (!isVegan && currentStatus == VeganStatus.NOT_VEGAN) {
            return;
        }
        VeganNBT.setVeganInNBT(stack, isVegan);
    }

    private static void scanRecipesRecursively(Item item, List<Item> alreadyTraversed) {
        alreadyTraversed.add(item);
        ImmutableCollection recipes = RecipeModification.getRecipesByResult((Item)item);
        int veganRecipes = 0;
        int nonVeganRecipes = 0;
        for (Recipe recipe : recipes) {
            if (VeganLabels.recipeNotVegan(alreadyTraversed, recipe)) {
                ++nonVeganRecipes;
                continue;
            }
            ++veganRecipes;
        }
        VeganStatus result = VeganStatus.UNKNOWN;
        if (veganRecipes > nonVeganRecipes) {
            result = VeganStatus.VEGAN;
        }
        if (veganRecipes < nonVeganRecipes) {
            result = VeganStatus.NOT_VEGAN;
        }
        int differencePercentage = (int)(100.0f * (float)Math.abs(veganRecipes - nonVeganRecipes) / (float)recipes.size());
        if (recipes.size() > 1 && differencePercentage < 20) {
            result = VeganStatus.UNKNOWN;
        }
        veganFromRecipes.put(item, result);
    }

    private static boolean recipeNotVegan(List<Item> alreadyTraversed, Recipe<?> recipe) {
        for (Ingredient ingredient : recipe.m_7527_()) {
            int nonVeganItems = 0;
            int total = 0;
            for (ItemStack itemStack : ingredient.m_43908_()) {
                if (itemStack.m_204117_(VeganTags.VEGAN_ALTERNATIVE)) continue;
                VeganStatus vegan = VeganLabels.isVegan(itemStack);
                if (vegan == VeganStatus.UNKNOWN) {
                    Item unknownItem = itemStack.m_41720_();
                    if (!alreadyTraversed.contains(unknownItem)) {
                        VeganLabels.scanRecipesRecursively(unknownItem, alreadyTraversed);
                    }
                    vegan = veganFromRecipes.getOrDefault(unknownItem, VeganStatus.UNKNOWN);
                }
                if (vegan == VeganStatus.NOT_VEGAN) {
                    ++nonVeganItems;
                }
                ++total;
            }
            if (!((float)nonVeganItems / (float)total >= 0.5f)) continue;
            return true;
        }
        return false;
    }

    private static boolean shouldRenderTooltip(ItemStack itemStack) {
        return !Boolean.FALSE.equals(VeganNBT.getVeganFromNBT(itemStack)) && !itemStack.m_204117_(VeganTags.VEGAN_ALTERNATIVE) && VeganNBT.containsSubstitute(itemStack);
    }

    public static void addTooltipLines(ItemStack stack, List<Component> tooltip) {
        if (Boolean.FALSE.equals(VeganNBT.getVeganFromNBT(stack))) {
            tooltip.add(1, (Component)Component.m_237113_((String)"Not vegan").m_6270_(Style.f_131099_.m_131140_(ChatFormatting.GRAY).m_131155_(Boolean.valueOf(true))));
        }
        if (debugMode) {
            tooltip.add(1, (Component)Component.m_237113_((String)("Result: " + VeganLabels.isVegan(stack).name())));
            tooltip.add(1, (Component)Component.m_237113_((String)("Default from recipes: " + String.valueOf((Object)veganFromRecipes.get(stack.m_41720_())))));
            tooltip.add(1, (Component)Component.m_237113_((String)("Component: " + VeganNBT.getVeganFromNBT(stack))));
        }
        if (!VeganLabels.shouldRenderTooltip(stack)) {
            return;
        }
        tooltip.add(1, (Component)Component.m_237113_((String)"Vegan").m_6270_(Style.f_131099_.m_178520_(35908).m_131155_(Boolean.valueOf(true)).m_131136_(Boolean.valueOf(true))));
    }

    private static void modifyRecipeResult(List<ItemStack> recipeInput, ItemStack result) {
        boolean vegan = true;
        for (ItemStack item : recipeInput) {
            if (VeganLabels.isVegan(item) == VeganStatus.NOT_VEGAN) {
                vegan = false;
            }
            if (!item.m_204117_(VeganTags.VEGAN_ALTERNATIVE) && !VeganNBT.containsSubstitute(item)) continue;
            VeganNBT.setContainsSubstitute(result);
        }
        VeganLabels.setIsVegan(result, vegan);
    }

    public static enum VeganStatus {
        VEGAN,
        NOT_VEGAN,
        UNKNOWN;


        static VeganStatus fromBoolean(@Nullable Boolean b) {
            if (b == null) {
                return UNKNOWN;
            }
            return b != false ? VEGAN : NOT_VEGAN;
        }
    }
}

