/*
 * Decompiled with CFR 0.152.
 */
package fr.iglee42.createcasing.utils;

import com.simibubi.create.content.kinetics.base.HorizontalKineticBlock;
import com.simibubi.create.content.kinetics.base.RotatedPillarKineticBlock;
import fr.iglee42.createcasing.blocks.ConfigurableGearboxBlock;
import fr.iglee42.createcasing.config.ModConfigs;
import fr.iglee42.createcasing.utils.EncasableBlocks;
import fr.iglee42.createcasing.utils.WoodBlocks;
import net.createmod.catnip.data.Iterate;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.FORGE, modid="createcasing")
public class ItemChangeBlockManager {
    @SubscribeEvent
    public static <T extends Comparable<T>> void onRightClick(PlayerInteractEvent.RightClickBlock event) {
        Level level = event.getEntity().m_9236_();
        if (event.getItemStack().m_41619_()) {
            return;
        }
        if (level.m_8055_(event.getPos()).m_60795_()) {
            return;
        }
        BlockState state = level.m_8055_(event.getPos());
        if (EncasableBlocks.hasBlocksForCasing(event.getItemStack().m_41720_()) && ((Boolean)ModConfigs.common().kinetics.casingBlockSwappable.get()).booleanValue()) {
            EncasableBlocks casingSet = EncasableBlocks.getBlockByCasing(event.getItemStack().m_41720_());
            if (casingSet.isInSet(state)) {
                return;
            }
            if (EncasableBlocks.isGearbox(state)) {
                ItemChangeBlockManager.changeAxisBlock(event, state, level, casingSet.getGearbox().getDefaultState());
            }
            if (EncasableBlocks.isMixer(state)) {
                ItemChangeBlockManager.changeBlock(event, state, level, casingSet.getMixer().getDefaultState());
            }
            if (EncasableBlocks.isPress(state)) {
                ItemChangeBlockManager.changeHorizontalDirectionBlock(event, state, level, casingSet.getPress().getDefaultState());
            }
            if (EncasableBlocks.isDepot(state) && event.getFace() != Direction.UP) {
                ItemChangeBlockManager.changeBlock(event, state, level, casingSet.getDepot().getDefaultState());
            }
            if (EncasableBlocks.isChainDrive(state)) {
                ItemChangeBlockManager.changeAxisBlock(event, state, level, casingSet.getChainDrive().getDefaultState());
            }
            if (EncasableBlocks.isAdjustableChainDrive(state)) {
                ItemChangeBlockManager.changeAxisBlock(event, state, level, casingSet.getAdjustableChainDrive().getDefaultState());
            }
            if (EncasableBlocks.isConfigurableGearbox(state)) {
                BlockState newState = casingSet.getConfigurableGearbox().getDefaultState();
                for (Direction dir : Iterate.directions) {
                    BooleanProperty property = ConfigurableGearboxBlock.getPropertyByDirection(dir);
                    newState = (BlockState)newState.m_61124_((Property)property, (Comparable)((Boolean)state.m_61143_((Property)property)));
                }
                ItemChangeBlockManager.changeBlock(event, state, level, newState);
            }
            if (EncasableBlocks.isChainConveyor(state)) {
                ItemChangeBlockManager.changeBlock(event, state, level, casingSet.getChainConveyor().getDefaultState());
            }
        }
        if (WoodBlocks.hasBlocksForItem(event.getItemStack().m_41720_()) && ((Boolean)ModConfigs.common().kinetics.shaftCogwheelsSwappable.get()).booleanValue()) {
            WoodBlocks woodSet = WoodBlocks.getBlockByItem(event.getItemStack().m_41720_());
            if (woodSet.isInSet(state)) {
                return;
            }
            if (WoodBlocks.isShaft(state) && woodSet.hasShaft()) {
                ItemChangeBlockManager.changeAxisBlock(event, state, level, woodSet.getShaft().getDefaultState());
            }
            if (WoodBlocks.isCogwheel(state) && woodSet.hasCogwheel()) {
                ItemChangeBlockManager.changeAxisBlock(event, state, level, woodSet.getCogwheel().getDefaultState());
            }
            if (WoodBlocks.isLargeCogwheel(state) && woodSet.hasLargeCogwheel()) {
                ItemChangeBlockManager.changeAxisBlock(event, state, level, woodSet.getLargeCogwheel().getDefaultState());
            }
        }
    }

    private static void changeBlock(PlayerInteractEvent.RightClickBlock event, BlockState state, Level level, BlockState newBlock) {
        level.m_46597_(event.getPos(), newBlock);
        level.m_46796_(2001, event.getPos(), Block.m_49956_((BlockState)newBlock));
        event.setCancellationResult(InteractionResult.SUCCESS);
        event.setCanceled(true);
    }

    private static void changeHorizontalDirectionBlock(PlayerInteractEvent.RightClickBlock event, BlockState state, Level level, BlockState newBlock) {
        if (!(state.m_60734_() instanceof HorizontalKineticBlock)) {
            return;
        }
        Direction facing = (Direction)state.m_61143_(HorizontalKineticBlock.HORIZONTAL_FACING);
        ItemChangeBlockManager.changeBlock(event, state, level, (BlockState)newBlock.m_61124_(HorizontalKineticBlock.HORIZONTAL_FACING, (Comparable)facing));
    }

    private static void changeAxisBlock(PlayerInteractEvent.RightClickBlock event, BlockState state, Level level, BlockState newBlock) {
        if (!(state.m_60734_() instanceof RotatedPillarKineticBlock)) {
            return;
        }
        Direction.Axis axis = (Direction.Axis)state.m_61143_((Property)RotatedPillarKineticBlock.AXIS);
        ItemChangeBlockManager.changeBlock(event, state, level, (BlockState)newBlock.m_61124_((Property)RotatedPillarKineticBlock.AXIS, (Comparable)axis));
    }
}

