/*
 * Decompiled with CFR 0.152.
 */
package com.blackgear.platform.common.entity;

import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.SpawnPlacements;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.levelgen.Heightmap;
import org.jetbrains.annotations.Nullable;

public final class SpawnPlacement {
    public static <T extends Mob> void register(Supplier<EntityType<T>> entity, SpawnPlacements.Type placement, Heightmap.Types heightmap, SpawnPlacements.SpawnPredicate<T> spawnPredicate) {
        SpawnPlacements.Data data = new SpawnPlacements.Data(heightmap, placement, spawnPredicate);
        SpawnPlacement.registerOrReplaceEntityData(entity, data);
    }

    public static <T extends Mob> void register(Supplier<EntityType<T>> entity, SpawnPlacementType placement, Heightmap.Types heightmap, SpawnPlacements.SpawnPredicate<T> spawnPredicate) {
        SpawnPlacements.Data data = new SpawnPlacements.Data(heightmap, SpawnPlacements.Type.NO_RESTRICTIONS, (entityType, level, spawnType, pos, random) -> placement.isSpawnPositionValid((LevelReader)level, pos, entityType) && spawnPredicate.m_217080_((EntityType)entity.get(), level, spawnType, pos, random));
        SpawnPlacement.registerOrReplaceEntityData(entity, data);
    }

    private static <T extends Mob> void registerOrReplaceEntityData(Supplier<EntityType<T>> entity, SpawnPlacements.Data data) {
        SpawnPlacements.Data entry = SpawnPlacements.f_21750_.put(entity.get(), data);
        if (entry != null) {
            SpawnPlacements.f_21750_.replace(entity.get(), data);
        }
    }

    public static interface SpawnPlacementType {
        public boolean isSpawnPositionValid(LevelReader var1, BlockPos var2, @Nullable EntityType<?> var3);
    }
}

