/*
 * Decompiled with CFR 0.152.
 */
package net.orcinus.galosphere.client.renderer;

import com.google.common.collect.Maps;
import java.util.Map;
import net.minecraft.Util;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.orcinus.galosphere.Galosphere;
import net.orcinus.galosphere.client.model.SparkleModel;
import net.orcinus.galosphere.entities.Sparkle;
import net.orcinus.galosphere.init.GModelLayers;

@OnlyIn(value=Dist.CLIENT)
public class SparkleRenderer
extends MobRenderer<Sparkle, EntityModel<Sparkle>> {
    private static final Map<Sparkle.CrystalType, ResourceLocation> TEXTURE_BY_TYPE = (Map)Util.m_137469_((Object)Maps.newHashMap(), map -> {
        for (Sparkle.CrystalType type : Sparkle.CrystalType.BY_ID) {
            map.put(type, Galosphere.id(String.format("textures/entity/sparkle/%s_sparkle.png", type.getName())));
        }
    });
    private static final ResourceLocation TEXTURE = Galosphere.id("textures/entity/sparkle/sparkle.png");

    public SparkleRenderer(EntityRendererProvider.Context context) {
        super(context, new SparkleModel(context.m_174023_(GModelLayers.SPARKLE)), 0.6f);
    }

    public ResourceLocation getTextureLocation(Sparkle entity) {
        return entity.getCrystaltype() == Sparkle.CrystalType.NONE ? TEXTURE : TEXTURE_BY_TYPE.get((Object)entity.getCrystaltype());
    }
}

