/*
 * Decompiled with CFR 0.152.
 */
package net.orcinus.galosphere.entities.ai.tasks;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.orcinus.galosphere.blocks.CordycepsBlock;
import net.orcinus.galosphere.entities.Specterpillar;
import net.orcinus.galosphere.init.GBlocks;
import net.orcinus.galosphere.init.GMemoryModuleTypes;

public class Burrow
extends Behavior<Specterpillar> {
    public Burrow() {
        super((Map)ImmutableMap.of((Object)MemoryModuleType.f_26381_, (Object)MemoryStatus.VALUE_ABSENT, (Object)((MemoryModuleType)GMemoryModuleTypes.CAN_BURY.get()), (Object)MemoryStatus.VALUE_PRESENT, (Object)((MemoryModuleType)GMemoryModuleTypes.NEAREST_LICHEN_MOSS.get()), (Object)MemoryStatus.VALUE_PRESENT), Mth.m_14167_((float)65.0f));
    }

    protected boolean checkExtraStartConditions(ServerLevel serverLevel, Specterpillar livingEntity) {
        return livingEntity.m_20096_() && this.getTargetPos(livingEntity).isPresent() && this.getTargetPos(livingEntity).get().m_123333_((Vec3i)livingEntity.m_20183_()) <= 0;
    }

    protected boolean canStillUse(ServerLevel serverLevel, Specterpillar livingEntity, long l) {
        Optional<BlockPos> targetPos = this.getTargetPos(livingEntity);
        if (targetPos.isEmpty()) {
            return false;
        }
        BlockPos blockPos = targetPos.get();
        if (serverLevel.m_8055_(blockPos).m_60795_() && serverLevel.m_8055_(blockPos.m_7495_()).m_60713_((Block)GBlocks.LICHEN_MOSS.get())) {
            return true;
        }
        livingEntity.m_20124_(Pose.STANDING);
        livingEntity.m_6274_().m_21936_((MemoryModuleType)GMemoryModuleTypes.NEAREST_LICHEN_MOSS.get());
        return false;
    }

    protected void start(ServerLevel serverLevel, Specterpillar livingEntity, long l) {
        this.getTargetPos(livingEntity).ifPresent(blockPos -> {
            if (blockPos.m_123333_((Vec3i)livingEntity.m_20183_()) <= 0 && livingEntity.m_20096_()) {
                livingEntity.m_20124_(Pose.DIGGING);
            }
        });
    }

    protected void stop(ServerLevel serverLevel, Specterpillar livingEntity, long l) {
        if (this.m_7773_(l)) {
            this.getTargetPos(livingEntity).filter(blockPos -> serverLevel.m_8055_(blockPos).m_60795_()).ifPresentOrElse(pos -> {
                serverLevel.m_7731_(pos, (BlockState)((BlockState)((Block)GBlocks.LICHEN_CORDYCEPS.get()).m_49966_().m_61124_((Property)CordycepsBlock.ALIVE_STAGE, (Comparable)Integer.valueOf(1))).m_61124_((Property)CordycepsBlock.ALIVE, (Comparable)Boolean.valueOf(true)), 2);
                livingEntity.m_146870_();
            }, () -> livingEntity.m_6274_().m_21936_((MemoryModuleType)GMemoryModuleTypes.NEAREST_LICHEN_MOSS.get()));
        }
    }

    public Optional<BlockPos> getTargetPos(Specterpillar specterpillar) {
        return specterpillar.m_6274_().m_21952_((MemoryModuleType)GMemoryModuleTypes.NEAREST_LICHEN_MOSS.get());
    }
}

