/*
 * Decompiled with CFR 0.152.
 */
package net.orcinus.galosphere.mixin.client;

import net.minecraft.client.Camera;
import net.minecraft.client.renderer.FogRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FogType;
import net.orcinus.galosphere.init.GMobEffects;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;

@Mixin(value={FogRenderer.class})
public class FogRendererMixin {
    @Unique
    private static float distance = 24.0f;

    @Inject(at={@At(value="INVOKE", target="Lcom/mojang/blaze3d/systems/RenderSystem;setShaderFogStart(F)V", shift=At.Shift.BEFORE)}, method={"setupFog"}, locals=LocalCapture.CAPTURE_FAILHARD)
    private static void G$setupFog(Camera camera, FogRenderer.FogMode fogMode, float f, boolean bl, float g, CallbackInfo ci, FogType fogType, Entity entity, FogRenderer.FogData fogData) {
        Entity cameraEntity = camera.m_90592_();
        if (FogRendererMixin.renderShadowPhase(cameraEntity) && entity instanceof LivingEntity) {
            boolean lock;
            LivingEntity livingEntity = (LivingEntity)entity;
            boolean bl2 = lock = FogRendererMixin.getViewBlockingState(livingEntity) != null;
            if (distance == f && !lock) {
                return;
            }
            if (distance > 12.0f && lock) {
                distance -= 2.0f;
            }
            if (!lock && distance < f) {
                distance += 1.0f;
            }
            float h = distance;
            fogData.f_234200_ = fogData.f_234199_ == FogRenderer.FogMode.FOG_SKY ? 0.0f : h * 0.75f;
            fogData.f_234201_ = h;
        }
    }

    @Unique
    private static boolean renderShadowPhase(Entity entity) {
        LivingEntity livingEntity;
        return entity instanceof LivingEntity && (livingEntity = (LivingEntity)entity).m_21023_((MobEffect)GMobEffects.ASTRAL.get());
    }

    @Unique
    @Nullable
    private static BlockState getViewBlockingState(LivingEntity player) {
        BlockPos.MutableBlockPos mutableBlockPos = new BlockPos.MutableBlockPos();
        for (int i = 0; i < 8; ++i) {
            double d = player.m_20185_() + (double)(((float)(i % 2) - 0.5f) * player.m_20205_() * 0.8f);
            double e = player.m_20188_() + (double)(((float)((i >> 1) % 2) - 0.5f) * 0.1f);
            double f = player.m_20189_() + (double)(((float)((i >> 2) % 2) - 0.5f) * player.m_20205_() * 0.8f);
            mutableBlockPos.m_122169_(d, e, f);
            BlockState blockState = player.m_9236_().m_8055_((BlockPos)mutableBlockPos);
            if (blockState.m_60799_() == RenderShape.INVISIBLE || !blockState.m_60831_((BlockGetter)player.m_9236_(), (BlockPos)mutableBlockPos)) continue;
            return blockState;
        }
        return null;
    }
}

