/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.blueprint.common.remolder.data;

import com.teamabnormals.blueprint.common.remolder.Remold;
import com.teamabnormals.blueprint.common.remolder.data.DataType;
import com.teamabnormals.blueprint.common.remolder.data.Molding;
import java.util.HashMap;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.annotation.Nullable;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Opcodes;
import org.objectweb.asm.Type;

public interface DataAccessor
extends Consumer<Remold.Fields>,
Opcodes {
    public static final DataAccessor ROOT = new Parentless(){

        @Override
        public void set(Molding<?> molding, String owner, MethodVisitor method, DataAccessor value) {
            value.visit(molding, owner, method);
            method.visitVarInsn(58, 2);
        }

        @Override
        public void visit(Molding<?> molding, String owner, MethodVisitor method) {
            method.visitVarInsn(25, 2);
        }

        @Override
        public void accept(Remold.Fields fields) {
        }

        @Override
        public DataType getDataType() {
            return DataType.ELEMENT;
        }

        public String toString() {
            return "ROOT_DATA_ACCESSOR";
        }
    };
    public static final DataAccessor META = new Parentless(){

        @Override
        public void set(Molding<?> molding, String owner, MethodVisitor method, DataAccessor value) {
            value.visit(molding, owner, method);
            method.visitVarInsn(58, 3);
        }

        @Override
        public void visit(Molding<?> molding, String owner, MethodVisitor method) {
            method.visitVarInsn(25, 3);
        }

        @Override
        public void accept(Remold.Fields fields) {
        }

        @Override
        public DataType getDataType() {
            return DataType.ELEMENT;
        }

        public String toString() {
            return "META_DATA_ACCESSOR";
        }
    };
    public static final DataAccessor VARIABLES = new Parentless(){

        @Override
        public void set(Molding<?> molding, String owner, MethodVisitor method, DataAccessor value) {
            throw new UnsupportedOperationException("Cannot re-assign the variables object to a new value");
        }

        @Override
        public void visit(Molding<?> molding, String owner, MethodVisitor method) {
            method.visitVarInsn(25, 4);
        }

        @Override
        public void accept(Remold.Fields fields) {
        }

        @Override
        public DataType getDataType() {
            return DataType.ELEMENT;
        }

        public String toString() {
            return "VARIABLES_DATA_ACCESSOR";
        }
    };
    public static final BiConsumer<Molding<?>, MethodVisitor> NOOP_VISITOR = (molding, method) -> {};
    public static final BiConsumer<Molding<?>, MethodVisitor> NUMBER_2_BOOLEAN_VISITOR = (molding, method) -> DataAccessor.number2Boolean(method);
    public static final BiConsumer<Molding<?>, MethodVisitor> NUMBER_2_CHAR_VISITOR = (molding, method) -> DataAccessor.number2Char(method);
    public static final BiConsumer<Molding<?>, MethodVisitor> NUMBER_2_BYTE_VISITOR = (molding, method) -> DataAccessor.number2Byte(method);
    public static final BiConsumer<Molding<?>, MethodVisitor> NUMBER_2_SHORT_VISITOR = (molding, method) -> DataAccessor.number2Short(method);
    public static final BiConsumer<Molding<?>, MethodVisitor> NUMBER_2_INT_VISITOR = (molding, method) -> DataAccessor.number2Int(method);
    public static final BiConsumer<Molding<?>, MethodVisitor> NUMBER_2_LONG_VISITOR = (molding, method) -> DataAccessor.number2Long(method);
    public static final BiConsumer<Molding<?>, MethodVisitor> NUMBER_2_FLOAT_VISITOR = (molding, method) -> DataAccessor.number2Float(method);
    public static final BiConsumer<Molding<?>, MethodVisitor> NUMBER_2_DOUBLE_VISITOR = (molding, method) -> DataAccessor.number2Double(method);

    public static void ifneResult(MethodVisitor method) {
        Label trueResult = new Label();
        method.visitJumpInsn(154, trueResult);
        method.visitInsn(3);
        Label end = new Label();
        method.visitJumpInsn(167, end);
        method.visitLabel(trueResult);
        method.visitInsn(4);
        method.visitLabel(end);
    }

    public static void boolean2Int(MethodVisitor method) {
        method.visitInsn(3);
        method.visitMethodInsn(184, "java/lang/Boolean", "compare", "(ZZ)I", false);
    }

    public static void boolean2Long(MethodVisitor method) {
        Label trueLabel = new Label();
        method.visitJumpInsn(154, trueLabel);
        method.visitInsn(9);
        Label endLabel = new Label();
        method.visitJumpInsn(167, endLabel);
        method.visitLabel(trueLabel);
        method.visitInsn(10);
        method.visitLabel(endLabel);
    }

    public static void boolean2Float(MethodVisitor method) {
        Label trueLabel = new Label();
        method.visitJumpInsn(154, trueLabel);
        method.visitInsn(11);
        Label endLabel = new Label();
        method.visitJumpInsn(167, endLabel);
        method.visitLabel(trueLabel);
        method.visitInsn(12);
        method.visitLabel(endLabel);
    }

    public static void boolean2Double(MethodVisitor method) {
        Label trueLabel = new Label();
        method.visitJumpInsn(154, trueLabel);
        method.visitInsn(14);
        Label endLabel = new Label();
        method.visitJumpInsn(167, endLabel);
        method.visitLabel(trueLabel);
        method.visitInsn(15);
        method.visitLabel(endLabel);
    }

    public static void long2Boolean(MethodVisitor method) {
        method.visitInsn(9);
        method.visitInsn(148);
        DataAccessor.ifneResult(method);
    }

    public static void float2Boolean(MethodVisitor method) {
        method.visitInsn(11);
        method.visitInsn(149);
        DataAccessor.ifneResult(method);
    }

    public static void double2Boolean(MethodVisitor method) {
        method.visitInsn(14);
        method.visitInsn(151);
        DataAccessor.ifneResult(method);
    }

    public static void int2Float(MethodVisitor method) {
        method.visitInsn(134);
    }

    public static void int2Double(MethodVisitor method) {
        method.visitInsn(135);
    }

    public static void int2Byte(MethodVisitor method) {
        method.visitInsn(145);
    }

    public static void int2Char(MethodVisitor method) {
        method.visitInsn(146);
    }

    public static void int2Short(MethodVisitor method) {
        method.visitInsn(147);
    }

    public static void float2Int(MethodVisitor method) {
        method.visitInsn(139);
    }

    public static void float2Long(MethodVisitor method) {
        method.visitInsn(140);
    }

    public static void float2Double(MethodVisitor method) {
        method.visitInsn(141);
    }

    public static void long2Int(MethodVisitor method) {
        method.visitInsn(136);
    }

    public static void long2Float(MethodVisitor method) {
        method.visitInsn(137);
    }

    public static void long2Double(MethodVisitor method) {
        method.visitInsn(138);
    }

    public static void double2Int(MethodVisitor method) {
        method.visitInsn(142);
    }

    public static void double2Long(MethodVisitor method) {
        method.visitInsn(143);
    }

    public static void double2Float(MethodVisitor method) {
        method.visitInsn(144);
    }

    public static void number2Boolean(MethodVisitor method) {
        method.visitMethodInsn(182, "java/lang/Number", "doubleValue", "()D", false);
        DataAccessor.double2Boolean(method);
    }

    public static void number2Char(MethodVisitor method) {
        method.visitMethodInsn(182, "java/lang/Number", "charValue", "()C", false);
    }

    public static void number2Byte(MethodVisitor method) {
        method.visitMethodInsn(182, "java/lang/Number", "byteValue", "()B", false);
    }

    public static void number2Short(MethodVisitor method) {
        method.visitMethodInsn(182, "java/lang/Number", "shortValue", "()S", false);
    }

    public static void number2Int(MethodVisitor method) {
        method.visitMethodInsn(182, "java/lang/Number", "intValue", "()I", false);
    }

    public static void number2Long(MethodVisitor method) {
        method.visitMethodInsn(182, "java/lang/Number", "longValue", "()J", false);
    }

    public static void number2Float(MethodVisitor method) {
        method.visitMethodInsn(182, "java/lang/Number", "floatValue", "()F", false);
    }

    public static void number2Double(MethodVisitor method) {
        method.visitMethodInsn(182, "java/lang/Number", "doubleValue", "()D", false);
    }

    public static void int2Long(MethodVisitor method) {
        method.visitInsn(133);
    }

    public static void boxBoolean(MethodVisitor method) {
        method.visitMethodInsn(184, "java/lang/Boolean", "valueOf", "(Z)Ljava/lang/Boolean;", false);
    }

    public static void boxChar(MethodVisitor method) {
        method.visitMethodInsn(184, "java/lang/Character", "valueOf", "(C)Ljava/lang/Character;", false);
    }

    public static void unboxBoolean(MethodVisitor method) {
        method.visitMethodInsn(182, "java/lang/Boolean", "booleanValue", "()Z", false);
    }

    public static void unboxCharacter(MethodVisitor method) {
        method.visitMethodInsn(182, "java/lang/Character", "charValue", "()C", false);
    }

    public static void boxByte(MethodVisitor method) {
        method.visitMethodInsn(184, "java/lang/Byte", "valueOf", "(B)Ljava/lang/Byte;", false);
    }

    public static void unboxByte(MethodVisitor method) {
        method.visitMethodInsn(182, "java/lang/Byte", "byteValue", "()B", false);
    }

    public static void boxShort(MethodVisitor method) {
        method.visitMethodInsn(184, "java/lang/Short", "valueOf", "(S)Ljava/lang/Short;", false);
    }

    public static void unboxShort(MethodVisitor method) {
        method.visitMethodInsn(182, "java/lang/Short", "shortValue", "()S", false);
    }

    public static void boxInt(MethodVisitor method) {
        method.visitMethodInsn(184, "java/lang/Integer", "valueOf", "(I)Ljava/lang/Integer;", false);
    }

    public static void unboxInteger(MethodVisitor method) {
        method.visitMethodInsn(182, "java/lang/Integer", "intValue", "()I", false);
    }

    public static void boxLong(MethodVisitor method) {
        method.visitMethodInsn(184, "java/lang/Long", "valueOf", "(J)Ljava/lang/Long;", false);
    }

    public static void unboxLong(MethodVisitor method) {
        method.visitMethodInsn(182, "java/lang/Long", "longValue", "()J", false);
    }

    public static void boxFloat(MethodVisitor method) {
        method.visitMethodInsn(184, "java/lang/Float", "valueOf", "(F)Ljava/lang/Float;", false);
    }

    public static void unboxFloat(MethodVisitor method) {
        method.visitMethodInsn(182, "java/lang/Float", "floatValue", "()F", false);
    }

    public static void boxDouble(MethodVisitor method) {
        method.visitMethodInsn(184, "java/lang/Double", "valueOf", "(D)Ljava/lang/Double;", false);
    }

    public static void unboxDouble(MethodVisitor method) {
        method.visitMethodInsn(182, "java/lang/Double", "doubleValue", "()D", false);
    }

    public static void stringLength(MethodVisitor method) {
        method.visitMethodInsn(182, "java/lang/String", "length", "()I", false);
    }

    public static BiConsumer<Molding<?>, MethodVisitor> stringValueOfVisitor(Type type) {
        TypeVisitors.Visitors visitorsForType = TypeVisitors.getVisitors(type);
        if (visitorsForType != null) {
            return visitorsForType.stringConverter();
        }
        int sort = type.getSort();
        if (sort == 10 || sort == 9) {
            return (molding, method) -> method.visitMethodInsn(184, "java/lang/String", "valueOf", "(Ljava/lang/Object;)Ljava/lang/String;", false);
        }
        throw new IllegalArgumentException("Don't know how to convert " + type + " to string");
    }

    public static Parentless string(final String value) {
        return new Parentless(){

            @Override
            public void visit(Molding<?> molding, String owner, MethodVisitor method) {
                method.visitLdcInsn((Object)value);
            }

            @Override
            public void accept(Remold.Fields fields) {
            }

            @Override
            public DataType getDataType() {
                return DataType.STRING;
            }
        };
    }

    public static Parentless booleanValue(boolean value) {
        return new Const(value ? 4 : 3, value, DataType.BOOLEAN);
    }

    public static Parentless charValue(char value) {
        return value <= '\u0005' ? new Const(value + 3, Character.valueOf(value), DataType.CHAR) : new Ldc(Character.valueOf(value), DataType.CHAR);
    }

    public static Parentless byteValue(byte value) {
        return value >= -1 && value <= 5 ? new Const(value + 3, value, DataType.BYTE) : new Ldc(value, DataType.BYTE);
    }

    public static Parentless shortValue(short value) {
        return value >= -1 && value <= 5 ? new Const(value + 3, value, DataType.SHORT) : new Ldc(value, DataType.SHORT);
    }

    public static Parentless intValue(int value) {
        return value >= -1 && value <= 5 ? new Const(value + 3, value, DataType.INT) : new Ldc(value, DataType.INT);
    }

    public static Parentless longValue(long value) {
        if (value == 0L) {
            return new Const(9, value, DataType.LONG);
        }
        if (value == 1L) {
            return new Const(10, value, DataType.LONG);
        }
        return new Ldc(value, DataType.LONG);
    }

    public static Parentless floatValue(float value) {
        int opcode;
        if (value == 0.0f) {
            opcode = 11;
        } else if (value == 1.0f) {
            opcode = 12;
        } else if (value == 2.0f) {
            opcode = 13;
        } else {
            return new Ldc(Float.valueOf(value), DataType.FLOAT);
        }
        return new Const(opcode, Float.valueOf(value), DataType.FLOAT);
    }

    public static Parentless doubleValue(double value) {
        if (value == 0.0) {
            return new Const(14, value, DataType.DOUBLE);
        }
        if (value == 1.0) {
            return new Const(15, value, DataType.DOUBLE);
        }
        return new Ldc(value, DataType.DOUBLE);
    }

    public static Child objectElement(DataAccessor parent, DataAccessor keyAccessor) {
        return new Child(parent, keyAccessor, false);
    }

    public static Child arrayElement(DataAccessor parent, DataAccessor indexAccessor) {
        return new Child(parent, indexAccessor, true);
    }

    public static Child lastArrayElement(DataAccessor parent) {
        return new Child(parent, DataAccessor.map(parent, DataType.INT, (molding, method) -> {
            molding.arrayLength((MethodVisitor)method);
            method.visitInsn(4);
            method.visitInsn(100);
        }), true){

            @Override
            public void add(Molding<?> molding, String owner, MethodVisitor method, DataAccessor value) {
                molding.append(method, methodVisitor -> this.visitParent(molding, owner, (MethodVisitor)methodVisitor), methodVisitor -> value.visit(molding, owner, (MethodVisitor)methodVisitor));
            }
        };
    }

    public static ParentlessMapping map(DataAccessor dataAccessor, DataType type, BiConsumer<Molding<?>, MethodVisitor> visitor) {
        return new ParentlessMapping(dataAccessor, type, visitor);
    }

    public static ParentlessInsertion insert(DataAccessor dataAccessor, DataType type, VisitorInserter inserter) {
        return new ParentlessInsertion(dataAccessor, type, inserter);
    }

    public static Parentless data(DataAccessor dataAccessor) {
        VisitorInserter inserter;
        DataType dataType = dataAccessor.getDataType();
        if (dataType.elementType() != DataType.ElementType.NONE) {
            throw new UnsupportedOperationException("Cannot convert data element to data element");
        }
        Type type = dataType.getTrueType(null);
        TypeVisitors.Visitors visitorsForType = TypeVisitors.getVisitors(type);
        if (visitorsForType != null) {
            inserter = visitorsForType.elementInserter();
        } else {
            Class<?> clazz;
            try {
                clazz = Class.forName(type.getClassName());
            }
            catch (AssertionError | ClassNotFoundException exception) {
                throw new UnsupportedOperationException("Don't know how to convert " + type + " to data element");
            }
            if (!Number.class.isAssignableFrom(clazz)) {
                throw new UnsupportedOperationException("Don't know how to convert " + clazz + " to data element");
            }
            inserter = Molding::numberElement;
        }
        return DataAccessor.insert(dataAccessor, DataType.ELEMENT, inserter);
    }

    public static ParentlessMapping str(DataAccessor dataAccessor) {
        DataType dataType = dataAccessor.getDataType();
        return DataAccessor.map(dataAccessor, DataType.STRING, dataType.elementType() != DataType.ElementType.NONE ? Molding::elementToString : DataAccessor.stringValueOfVisitor(dataType.getTrueType(null)));
    }

    public static BiConsumer<Molding<?>, MethodVisitor> tryToGetNumberVisitorForType(Type type, String visitorType, BiConsumer<Molding<?>, MethodVisitor> numberVisitor) {
        Class<?> clazz;
        try {
            clazz = Class.forName(type.getClassName());
        }
        catch (AssertionError | ClassNotFoundException exception) {
            throw new UnsupportedOperationException("Don't know how to convert " + type + " to " + visitorType);
        }
        if (!Number.class.isAssignableFrom(clazz)) {
            throw new UnsupportedOperationException("Don't know how to convert " + clazz + " to " + visitorType);
        }
        return numberVisitor;
    }

    public static DataAccessor convertViaTypeVisitors(DataAccessor dataAccessor, DataType type, BiConsumer<Molding<?>, MethodVisitor> elementVisitor, Function<TypeVisitors.Visitors, BiConsumer<Molding<?>, MethodVisitor>> converterFromVisitors, BiConsumer<Molding<?>, MethodVisitor> numberVisitor) {
        Type trueType;
        TypeVisitors.Visitors visitorsForType;
        DataType dataType = dataAccessor.getDataType();
        BiConsumer<Molding<?>, MethodVisitor> visitor = dataType.elementType() != DataType.ElementType.NONE ? elementVisitor : ((visitorsForType = TypeVisitors.getVisitors(trueType = dataType.getTrueType(null))) != null ? converterFromVisitors.apply(visitorsForType) : DataAccessor.tryToGetNumberVisitorForType(trueType, DataType.toString(dataType), numberVisitor));
        return DataAccessor.map(dataAccessor, type, visitor);
    }

    public static DataAccessor convertToBoolean(DataAccessor dataAccessor) {
        return DataAccessor.convertViaTypeVisitors(dataAccessor, DataType.BOOLEAN, Molding::elementToBoolean, TypeVisitors.Visitors::booleanConverter, NUMBER_2_BOOLEAN_VISITOR);
    }

    public static DataAccessor convertToBooleanWrapper(DataAccessor dataAccessor) {
        return DataAccessor.map(DataAccessor.convertToBoolean(dataAccessor), DataType.BOOLEAN_WRAPPER, (molding, method) -> DataAccessor.boxBoolean(method));
    }

    public static DataAccessor convertToChar(DataAccessor dataAccessor) {
        Constant constant;
        Object object;
        if (dataAccessor instanceof Constant && (object = (constant = (Constant)dataAccessor).getValue()) instanceof Number) {
            Number number = (Number)object;
            if (number instanceof Integer) {
                return DataAccessor.charValue((char)number.intValue());
            }
            if (number instanceof Long) {
                return DataAccessor.charValue((char)number.longValue());
            }
            if (number instanceof Double) {
                return DataAccessor.charValue((char)number.doubleValue());
            }
            if (number instanceof Float) {
                return DataAccessor.charValue((char)number.floatValue());
            }
            if (number instanceof Short) {
                return DataAccessor.charValue((char)number.shortValue());
            }
            if (number instanceof Byte) {
                return DataAccessor.charValue((char)number.byteValue());
            }
        }
        return DataAccessor.convertViaTypeVisitors(dataAccessor, DataType.CHAR, Molding::elementToChar, TypeVisitors.Visitors::charConverter, NUMBER_2_CHAR_VISITOR);
    }

    public static DataAccessor convertToCharWrapper(DataAccessor dataAccessor) {
        return DataAccessor.map(DataAccessor.convertToChar(dataAccessor), DataType.CHAR_WRAPPER, (molding, method) -> DataAccessor.boxChar(method));
    }

    public static DataAccessor convertToByte(DataAccessor dataAccessor) {
        Constant constant;
        Object object;
        if (dataAccessor instanceof Constant && (object = (constant = (Constant)dataAccessor).getValue()) instanceof Number) {
            Number number = (Number)object;
            return DataAccessor.byteValue(number.byteValue());
        }
        return DataAccessor.convertViaTypeVisitors(dataAccessor, DataType.BYTE, Molding::elementToByte, TypeVisitors.Visitors::byteConverter, NUMBER_2_BYTE_VISITOR);
    }

    public static DataAccessor convertToByteWrapper(DataAccessor dataAccessor) {
        return DataAccessor.map(DataAccessor.convertToByte(dataAccessor), DataType.BYTE_WRAPPER, (molding, method) -> DataAccessor.boxByte(method));
    }

    public static DataAccessor convertToShort(DataAccessor dataAccessor) {
        Constant constant;
        Object object;
        if (dataAccessor instanceof Constant && (object = (constant = (Constant)dataAccessor).getValue()) instanceof Number) {
            Number number = (Number)object;
            return DataAccessor.shortValue(number.shortValue());
        }
        return DataAccessor.convertViaTypeVisitors(dataAccessor, DataType.SHORT, Molding::elementToShort, TypeVisitors.Visitors::shortConverter, NUMBER_2_SHORT_VISITOR);
    }

    public static DataAccessor convertToShortWrapper(DataAccessor dataAccessor) {
        return DataAccessor.map(DataAccessor.convertToShort(dataAccessor), DataType.SHORT_WRAPPER, (molding, method) -> DataAccessor.boxShort(method));
    }

    public static DataAccessor convertToInt(DataAccessor dataAccessor) {
        Constant constant;
        Object object;
        if (dataAccessor instanceof Constant && (object = (constant = (Constant)dataAccessor).getValue()) instanceof Number) {
            Number number = (Number)object;
            return DataAccessor.intValue(number.intValue());
        }
        return DataAccessor.convertViaTypeVisitors(dataAccessor, DataType.INT, Molding::elementToInt, TypeVisitors.Visitors::intConverter, NUMBER_2_INT_VISITOR);
    }

    public static DataAccessor convertToIntWrapper(DataAccessor dataAccessor) {
        return DataAccessor.map(DataAccessor.convertToInt(dataAccessor), DataType.INT_WRAPPER, (molding, method) -> DataAccessor.boxInt(method));
    }

    public static DataAccessor convertToLong(DataAccessor dataAccessor) {
        Constant constant;
        Object object;
        if (dataAccessor instanceof Constant && (object = (constant = (Constant)dataAccessor).getValue()) instanceof Number) {
            Number number = (Number)object;
            return DataAccessor.longValue(number.longValue());
        }
        return DataAccessor.convertViaTypeVisitors(dataAccessor, DataType.LONG, Molding::elementToLong, TypeVisitors.Visitors::longConverter, NUMBER_2_LONG_VISITOR);
    }

    public static DataAccessor convertToLongWrapper(DataAccessor dataAccessor) {
        return DataAccessor.map(DataAccessor.convertToLong(dataAccessor), DataType.LONG_WRAPPER, (molding, method) -> DataAccessor.boxLong(method));
    }

    public static DataAccessor convertToFloat(DataAccessor dataAccessor) {
        Constant constant;
        Object object;
        if (dataAccessor instanceof Constant && (object = (constant = (Constant)dataAccessor).getValue()) instanceof Number) {
            Number number = (Number)object;
            return DataAccessor.floatValue(number.floatValue());
        }
        return DataAccessor.convertViaTypeVisitors(dataAccessor, DataType.FLOAT, Molding::elementToFloat, TypeVisitors.Visitors::floatConverter, NUMBER_2_FLOAT_VISITOR);
    }

    public static DataAccessor convertToFloatWrapper(DataAccessor dataAccessor) {
        return DataAccessor.map(DataAccessor.convertToFloat(dataAccessor), DataType.FLOAT_WRAPPER, (molding, method) -> DataAccessor.boxFloat(method));
    }

    public static DataAccessor convertToDouble(DataAccessor dataAccessor) {
        Constant constant;
        Object object;
        if (dataAccessor instanceof Constant && (object = (constant = (Constant)dataAccessor).getValue()) instanceof Number) {
            Number number = (Number)object;
            return DataAccessor.doubleValue(number.doubleValue());
        }
        return DataAccessor.convertViaTypeVisitors(dataAccessor, DataType.DOUBLE, Molding::elementToDouble, TypeVisitors.Visitors::doubleConverter, NUMBER_2_DOUBLE_VISITOR);
    }

    public static DataAccessor convertToDoubleWrapper(DataAccessor dataAccessor) {
        return DataAccessor.map(DataAccessor.convertToDouble(dataAccessor), DataType.DOUBLE_WRAPPER, (molding, method) -> DataAccessor.boxDouble(method));
    }

    default public void add(Molding<?> molding, String owner, MethodVisitor method, DataAccessor value) {
        molding.add(method, methodVisitor -> this.visitParent(molding, owner, (MethodVisitor)methodVisitor), methodVisitor -> this.visitIdentifier(molding, owner, (MethodVisitor)methodVisitor), methodVisitor -> value.visit(molding, owner, (MethodVisitor)methodVisitor), this.isIdentifierAnIndex());
    }

    default public void remove(Molding<?> molding, String owner, MethodVisitor method) {
        molding.remove(method, methodVisitor -> this.visitParent(molding, owner, (MethodVisitor)methodVisitor), methodVisitor -> this.visitIdentifier(molding, owner, (MethodVisitor)methodVisitor), this.isIdentifierAnIndex());
    }

    default public void set(Molding<?> molding, String owner, MethodVisitor method, DataAccessor value) {
        molding.set(method, methodVisitor -> this.visitParent(molding, owner, (MethodVisitor)methodVisitor), methodVisitor -> this.visitIdentifier(molding, owner, (MethodVisitor)methodVisitor), methodVisitor -> value.visit(molding, owner, (MethodVisitor)methodVisitor), this.isIdentifierAnIndex());
    }

    public void visitParent(Molding<?> var1, String var2, MethodVisitor var3);

    public void visitIdentifier(Molding<?> var1, String var2, MethodVisitor var3);

    public boolean isIdentifierAnIndex();

    public void visit(Molding<?> var1, String var2, MethodVisitor var3);

    @Override
    public void accept(Remold.Fields var1);

    public DataType getDataType();

    public static final class TypeVisitors {
        private static final HashMap<Type, Visitors> MAP = new HashMap();
        public static final Visitors BOOLEAN_VISITORS;
        public static final Visitors BOOLEAN_WRAPPER_VISITORS;
        public static final Visitors CHAR_VISITORS;
        public static final Visitors CHAR_WRAPPER_VISITORS;
        public static final Visitors BYTE_VISITORS;
        public static final Visitors BYTE_WRAPPER_VISITORS;
        public static final Visitors SHORT_VISITORS;
        public static final Visitors SHORT_WRAPPER_VISITORS;
        public static final Visitors INT_VISITORS;
        public static final Visitors INT_WRAPPER_VISITORS;
        public static final Visitors LONG_VISITORS;
        public static final Visitors LONG_WRAPPER_VISITORS;
        public static final Visitors FLOAT_VISITORS;
        public static final Visitors FLOAT_WRAPPER_VISITORS;
        public static final Visitors DOUBLE_VISITORS;
        public static final Visitors DOUBLE_WRAPPER_VISITORS;
        public static final Visitors STRING_VISITORS;

        public static synchronized Visitors register(Type type, Visitors visitors) {
            MAP.put(type, visitors);
            return visitors;
        }

        @Nullable
        public static Visitors getVisitors(Type type) {
            return MAP.get(type);
        }

        static {
            BiConsumer<Molding<?>, MethodVisitor> booleanToInt = (molding, method) -> DataAccessor.boolean2Int(method);
            BOOLEAN_VISITORS = TypeVisitors.register(Type.BOOLEAN_TYPE, new Visitors(Molding::booleanElementFromPrimitive, (molding, method) -> method.visitMethodInsn(184, "java/lang/String", "valueOf", "(Z)Ljava/lang/String;", false), NOOP_VISITOR, booleanToInt, booleanToInt, booleanToInt, booleanToInt, (molding, method) -> DataAccessor.boolean2Long(method), (molding, method) -> DataAccessor.boolean2Float(method), (molding, method) -> DataAccessor.boolean2Double(method)));
            BiConsumer<Molding<?>, MethodVisitor> booleanWrapperToInt = (molding, method) -> {
                DataAccessor.unboxBoolean(method);
                DataAccessor.boolean2Int(method);
            };
            BOOLEAN_WRAPPER_VISITORS = TypeVisitors.register(DataType.BOOLEAN_TYPE, new Visitors(Molding::booleanElementFromWrapper, (molding, method) -> {
                DataAccessor.unboxBoolean(method);
                method.visitMethodInsn(184, "java/lang/String", "valueOf", "(Z)Ljava/lang/String;", false);
            }, (molding, method) -> DataAccessor.unboxBoolean(method), booleanWrapperToInt, booleanWrapperToInt, booleanWrapperToInt, booleanWrapperToInt, (molding, method) -> {
                DataAccessor.unboxBoolean(method);
                DataAccessor.boolean2Long(method);
            }, (molding, method) -> {
                DataAccessor.unboxBoolean(method);
                DataAccessor.boolean2Float(method);
            }, (molding, method) -> {
                DataAccessor.unboxBoolean(method);
                DataAccessor.boolean2Double(method);
            }));
            BiConsumer<Molding<?>, MethodVisitor> ifneResult = (molding, method) -> DataAccessor.ifneResult(method);
            BiConsumer<Molding<?>, MethodVisitor> i2b = (molding, method) -> DataAccessor.int2Byte(method);
            BiConsumer<Molding<?>, MethodVisitor> i2s = (molding, method) -> DataAccessor.int2Short(method);
            BiConsumer<Molding<?>, MethodVisitor> i2l = (molding, method) -> DataAccessor.int2Long(method);
            BiConsumer<Molding<?>, MethodVisitor> i2f = (molding, method) -> DataAccessor.int2Float(method);
            BiConsumer<Molding<?>, MethodVisitor> i2d = (molding, method) -> DataAccessor.int2Double(method);
            CHAR_VISITORS = TypeVisitors.register(Type.CHAR_TYPE, new Visitors(Molding::characterElementFromPrimitive, (molding, method) -> method.visitMethodInsn(184, "java/lang/String", "valueOf", "(C)Ljava/lang/String;", false), ifneResult, NOOP_VISITOR, i2b, i2s, NOOP_VISITOR, i2l, i2f, i2d));
            BiConsumer<Molding<?>, MethodVisitor> unboxCharacter = (molding, method) -> DataAccessor.unboxCharacter(method);
            CHAR_WRAPPER_VISITORS = TypeVisitors.register(DataType.CHARACTER_TYPE, new Visitors(Molding::characterElementFromWrapper, (molding, method) -> {
                DataAccessor.unboxCharacter(method);
                method.visitMethodInsn(184, "java/lang/String", "valueOf", "(C)Ljava/lang/String;", false);
            }, (molding, method) -> {
                DataAccessor.unboxCharacter(method);
                DataAccessor.ifneResult(method);
            }, unboxCharacter, (molding, method) -> {
                DataAccessor.unboxCharacter(method);
                DataAccessor.int2Byte(method);
            }, (molding, method) -> {
                DataAccessor.unboxCharacter(method);
                DataAccessor.int2Short(method);
            }, unboxCharacter, (molding, method) -> {
                DataAccessor.unboxCharacter(method);
                DataAccessor.int2Long(method);
            }, (molding, method) -> {
                DataAccessor.unboxCharacter(method);
                DataAccessor.int2Float(method);
            }, (molding, method) -> {
                DataAccessor.unboxCharacter(method);
                DataAccessor.int2Double(method);
            }));
            BiConsumer<Molding<?>, MethodVisitor> i2c = (molding, method) -> DataAccessor.int2Char(method);
            BYTE_VISITORS = TypeVisitors.register(Type.BYTE_TYPE, new Visitors(Molding::byteElementFromPrimitive, (molding, method) -> method.visitMethodInsn(184, "java/lang/String", "valueOf", "(I)Ljava/lang/String;", false), ifneResult, i2c, NOOP_VISITOR, NOOP_VISITOR, NOOP_VISITOR, i2l, i2f, i2d));
            BiConsumer<Molding<?>, MethodVisitor> unboxByte = (molding, method) -> DataAccessor.unboxByte(method);
            BYTE_WRAPPER_VISITORS = TypeVisitors.register(DataType.BYTE_TYPE, new Visitors(Molding::byteElementFromWrapper, (molding, method) -> {
                DataAccessor.unboxByte(method);
                method.visitMethodInsn(184, "java/lang/String", "valueOf", "(I)Ljava/lang/String;", false);
            }, (molding, method) -> {
                DataAccessor.unboxByte(method);
                DataAccessor.ifneResult(method);
            }, (molding, method) -> {
                DataAccessor.unboxByte(method);
                DataAccessor.int2Char(method);
            }, unboxByte, unboxByte, unboxByte, (molding, method) -> {
                DataAccessor.unboxByte(method);
                DataAccessor.int2Long(method);
            }, (molding, method) -> {
                DataAccessor.unboxByte(method);
                DataAccessor.int2Float(method);
            }, (molding, method) -> {
                DataAccessor.unboxByte(method);
                DataAccessor.int2Double(method);
            }));
            SHORT_VISITORS = TypeVisitors.register(Type.SHORT_TYPE, new Visitors(Molding::shortElementFromPrimitive, (molding, method) -> method.visitMethodInsn(184, "java/lang/String", "valueOf", "(I)Ljava/lang/String;", false), ifneResult, i2c, i2b, NOOP_VISITOR, NOOP_VISITOR, i2l, i2f, i2d));
            BiConsumer<Molding<?>, MethodVisitor> unboxShort = (molding, method) -> DataAccessor.unboxShort(method);
            SHORT_WRAPPER_VISITORS = TypeVisitors.register(DataType.SHORT_TYPE, new Visitors(Molding::shortElementFromWrapper, (molding, method) -> {
                DataAccessor.unboxShort(method);
                method.visitMethodInsn(184, "java/lang/String", "valueOf", "(I)Ljava/lang/String;", false);
            }, (molding, method) -> {
                DataAccessor.unboxShort(method);
                DataAccessor.ifneResult(method);
            }, (molding, method) -> {
                DataAccessor.unboxShort(method);
                DataAccessor.int2Char(method);
            }, (molding, method) -> {
                DataAccessor.unboxShort(method);
                DataAccessor.int2Byte(method);
            }, unboxShort, unboxShort, (molding, method) -> {
                DataAccessor.unboxShort(method);
                DataAccessor.int2Long(method);
            }, (molding, method) -> {
                DataAccessor.unboxShort(method);
                DataAccessor.int2Float(method);
            }, (molding, method) -> {
                DataAccessor.unboxShort(method);
                DataAccessor.int2Double(method);
            }));
            INT_VISITORS = TypeVisitors.register(Type.INT_TYPE, new Visitors(Molding::intElementFromPrimitive, (molding, method) -> method.visitMethodInsn(184, "java/lang/String", "valueOf", "(I)Ljava/lang/String;", false), ifneResult, i2c, i2b, i2s, NOOP_VISITOR, i2l, i2f, i2d));
            INT_WRAPPER_VISITORS = TypeVisitors.register(DataType.INTEGER_TYPE, new Visitors(Molding::intElementFromWrapper, (molding, method) -> {
                DataAccessor.unboxInteger(method);
                method.visitMethodInsn(184, "java/lang/String", "valueOf", "(I)Ljava/lang/String;", false);
            }, (molding, method) -> {
                DataAccessor.unboxInteger(method);
                DataAccessor.ifneResult(method);
            }, (molding, method) -> {
                DataAccessor.unboxInteger(method);
                DataAccessor.int2Char(method);
            }, (molding, method) -> {
                DataAccessor.unboxInteger(method);
                DataAccessor.int2Byte(method);
            }, (molding, method) -> {
                DataAccessor.unboxInteger(method);
                DataAccessor.int2Short(method);
            }, (molding, method) -> DataAccessor.unboxInteger(method), (molding, method) -> {
                DataAccessor.unboxInteger(method);
                DataAccessor.int2Long(method);
            }, (molding, method) -> {
                DataAccessor.unboxInteger(method);
                DataAccessor.int2Float(method);
            }, (molding, method) -> {
                DataAccessor.unboxInteger(method);
                DataAccessor.int2Double(method);
            }));
            LONG_VISITORS = TypeVisitors.register(Type.LONG_TYPE, new Visitors(Molding::longElementFromPrimitive, (molding, method) -> method.visitMethodInsn(184, "java/lang/String", "valueOf", "(J)Ljava/lang/String;", false), (molding, method) -> DataAccessor.long2Boolean(method), (molding, method) -> {
                DataAccessor.long2Int(method);
                DataAccessor.int2Char(method);
            }, (molding, method) -> {
                DataAccessor.long2Int(method);
                DataAccessor.int2Byte(method);
            }, (molding, method) -> {
                DataAccessor.long2Int(method);
                DataAccessor.int2Short(method);
            }, (molding, method) -> DataAccessor.long2Int(method), NOOP_VISITOR, (molding, method) -> DataAccessor.long2Float(method), (molding, method) -> DataAccessor.long2Double(method)));
            LONG_WRAPPER_VISITORS = TypeVisitors.register(DataType.LONG_TYPE, new Visitors(Molding::longElementFromWrapper, (molding, method) -> {
                DataAccessor.unboxLong(method);
                method.visitMethodInsn(184, "java/lang/String", "valueOf", "(J)Ljava/lang/String;", false);
            }, (molding, method) -> {
                DataAccessor.unboxLong(method);
                DataAccessor.long2Boolean(method);
            }, (molding, method) -> {
                DataAccessor.unboxLong(method);
                DataAccessor.long2Int(method);
                DataAccessor.int2Char(method);
            }, (molding, method) -> {
                DataAccessor.unboxLong(method);
                DataAccessor.long2Int(method);
                DataAccessor.int2Byte(method);
            }, (molding, method) -> {
                DataAccessor.unboxLong(method);
                DataAccessor.long2Int(method);
                DataAccessor.int2Short(method);
            }, (molding, method) -> {
                DataAccessor.unboxLong(method);
                DataAccessor.long2Int(method);
            }, (molding, method) -> DataAccessor.unboxLong(method), (molding, method) -> {
                DataAccessor.unboxLong(method);
                DataAccessor.long2Float(method);
            }, (molding, method) -> {
                DataAccessor.unboxLong(method);
                DataAccessor.long2Double(method);
            }));
            FLOAT_VISITORS = TypeVisitors.register(Type.FLOAT_TYPE, new Visitors(Molding::floatElementFromPrimitive, (molding, method) -> method.visitMethodInsn(184, "java/lang/String", "valueOf", "(F)Ljava/lang/String;", false), (molding, method) -> DataAccessor.float2Boolean(method), (molding, method) -> {
                DataAccessor.float2Int(method);
                DataAccessor.int2Char(method);
            }, (molding, method) -> {
                DataAccessor.float2Int(method);
                DataAccessor.int2Byte(method);
            }, (molding, method) -> {
                DataAccessor.float2Int(method);
                DataAccessor.int2Short(method);
            }, (molding, method) -> DataAccessor.float2Int(method), (molding, method) -> DataAccessor.float2Long(method), NOOP_VISITOR, (molding, method) -> DataAccessor.float2Double(method)));
            FLOAT_WRAPPER_VISITORS = TypeVisitors.register(DataType.FLOAT_TYPE, new Visitors(Molding::floatElementFromWrapper, (molding, method) -> {
                DataAccessor.unboxFloat(method);
                method.visitMethodInsn(184, "java/lang/String", "valueOf", "(F)Ljava/lang/String;", false);
            }, (molding, method) -> {
                DataAccessor.unboxFloat(method);
                DataAccessor.float2Boolean(method);
            }, (molding, method) -> {
                DataAccessor.unboxFloat(method);
                DataAccessor.float2Int(method);
                DataAccessor.int2Char(method);
            }, (molding, method) -> {
                DataAccessor.unboxFloat(method);
                DataAccessor.float2Int(method);
                DataAccessor.int2Byte(method);
            }, (molding, method) -> {
                DataAccessor.unboxFloat(method);
                DataAccessor.float2Int(method);
                DataAccessor.int2Short(method);
            }, (molding, method) -> {
                DataAccessor.unboxFloat(method);
                DataAccessor.float2Int(method);
            }, (molding, method) -> {
                DataAccessor.unboxFloat(method);
                DataAccessor.float2Long(method);
            }, (molding, method) -> DataAccessor.unboxFloat(method), (molding, method) -> {
                DataAccessor.unboxFloat(method);
                DataAccessor.float2Double(method);
            }));
            DOUBLE_VISITORS = TypeVisitors.register(Type.DOUBLE_TYPE, new Visitors(Molding::doubleElementFromPrimitive, (molding, method) -> method.visitMethodInsn(184, "java/lang/String", "valueOf", "(D)Ljava/lang/String;", false), (molding, method) -> DataAccessor.double2Boolean(method), (molding, method) -> {
                DataAccessor.double2Int(method);
                DataAccessor.int2Char(method);
            }, (molding, method) -> {
                DataAccessor.double2Int(method);
                DataAccessor.int2Byte(method);
            }, (molding, method) -> {
                DataAccessor.double2Int(method);
                DataAccessor.int2Short(method);
            }, (molding, method) -> DataAccessor.double2Int(method), (molding, method) -> DataAccessor.double2Long(method), (molding, method) -> DataAccessor.double2Float(method), NOOP_VISITOR));
            DOUBLE_WRAPPER_VISITORS = TypeVisitors.register(DataType.DOUBLE_TYPE, new Visitors(Molding::doubleElementFromWrapper, (molding, method) -> {
                DataAccessor.unboxDouble(method);
                method.visitMethodInsn(184, "java/lang/String", "valueOf", "(D)Ljava/lang/String;", false);
            }, (molding, method) -> {
                DataAccessor.unboxDouble(method);
                DataAccessor.double2Boolean(method);
            }, (molding, method) -> {
                DataAccessor.unboxDouble(method);
                DataAccessor.double2Int(method);
                DataAccessor.int2Char(method);
            }, (molding, method) -> {
                DataAccessor.unboxDouble(method);
                DataAccessor.double2Int(method);
                DataAccessor.int2Byte(method);
            }, (molding, method) -> {
                DataAccessor.unboxDouble(method);
                DataAccessor.double2Int(method);
                DataAccessor.int2Short(method);
            }, (molding, method) -> {
                DataAccessor.unboxDouble(method);
                DataAccessor.double2Int(method);
            }, (molding, method) -> {
                DataAccessor.unboxDouble(method);
                DataAccessor.double2Long(method);
            }, (molding, method) -> {
                DataAccessor.unboxDouble(method);
                DataAccessor.double2Float(method);
            }, (molding, method) -> DataAccessor.unboxDouble(method)));
            STRING_VISITORS = TypeVisitors.register(DataType.STRING_TYPE, new Visitors(Molding::stringElement, NOOP_VISITOR, (molding, method) -> {
                method.visitMethodInsn(182, "java/lang/String", "isEmpty", "()Z", false);
                Label isNotEmpty = new Label();
                method.visitJumpInsn(153, isNotEmpty);
                method.visitInsn(3);
                Label end = new Label();
                method.visitJumpInsn(167, end);
                method.visitLabel(isNotEmpty);
                method.visitInsn(4);
                method.visitLabel(end);
            }, (molding, method) -> {
                method.visitInsn(3);
                method.visitMethodInsn(182, "java/lang/String", "charAt", "(I)C", false);
            }, (molding, method) -> method.visitMethodInsn(184, "java/lang/Byte", "parseByte", "(Ljava/lang/String;)B", false), (molding, method) -> method.visitMethodInsn(184, "java/lang/Short", "parseShort", "(Ljava/lang/String;)S", false), (molding, method) -> method.visitMethodInsn(184, "java/lang/Integer", "parseInt", "(Ljava/lang/String;)I", false), (molding, method) -> method.visitMethodInsn(184, "java/lang/Long", "parseLong", "(Ljava/lang/String;)J", false), (molding, method) -> method.visitMethodInsn(184, "java/lang/Float", "parseFloat", "(Ljava/lang/String;)F", false), (molding, method) -> method.visitMethodInsn(184, "java/lang/Double", "parseDouble", "(Ljava/lang/String;)D", false)));
        }

        record Visitors(VisitorInserter elementInserter, BiConsumer<Molding<?>, MethodVisitor> stringConverter, BiConsumer<Molding<?>, MethodVisitor> booleanConverter, BiConsumer<Molding<?>, MethodVisitor> charConverter, BiConsumer<Molding<?>, MethodVisitor> byteConverter, BiConsumer<Molding<?>, MethodVisitor> shortConverter, BiConsumer<Molding<?>, MethodVisitor> intConverter, BiConsumer<Molding<?>, MethodVisitor> longConverter, BiConsumer<Molding<?>, MethodVisitor> floatConverter, BiConsumer<Molding<?>, MethodVisitor> doubleConverter) {
        }
    }

    public static final class Const
    extends Constant {
        private final int opcode;

        public Const(int opcode, Object value, DataType type) {
            super(value, type);
            this.opcode = opcode;
        }

        @Override
        public void visit(Molding<?> molding, String owner, MethodVisitor method) {
            method.visitInsn(this.opcode);
        }
    }

    public static final class Ldc
    extends Constant {
        public Ldc(Object value, DataType type) {
            super(value, type);
        }

        @Override
        public void visit(Molding<?> molding, String owner, MethodVisitor method) {
            method.visitLdcInsn(this.getValue());
        }
    }

    public static class Child
    implements DataAccessor {
        private final DataAccessor parent;
        private final DataAccessor identifier;
        private final boolean isIdentifierAnIndex;

        public Child(DataAccessor parent, DataAccessor identifier, boolean isIdentifierAnIndex) {
            this.parent = parent;
            this.identifier = identifier;
            this.isIdentifierAnIndex = isIdentifierAnIndex;
        }

        @Override
        public void visitParent(Molding<?> molding, String owner, MethodVisitor method) {
            this.parent.visit(molding, owner, method);
        }

        @Override
        public void visitIdentifier(Molding<?> molding, String owner, MethodVisitor method) {
            this.identifier.visit(molding, owner, method);
        }

        @Override
        public boolean isIdentifierAnIndex() {
            return this.isIdentifierAnIndex;
        }

        @Override
        public void visit(Molding<?> molding, String owner, MethodVisitor method) {
            molding.get(method, methodVisitor -> this.visitParent(molding, owner, (MethodVisitor)methodVisitor), methodVisitor -> this.visitIdentifier(molding, owner, (MethodVisitor)methodVisitor), this.isIdentifierAnIndex());
        }

        @Override
        public void accept(Remold.Fields fields) {
            this.parent.accept(fields);
            this.identifier.accept(fields);
        }

        @Override
        public DataType getDataType() {
            return DataType.ELEMENT;
        }
    }

    public record ParentlessMapping(DataAccessor accessor, DataType type, BiConsumer<Molding<?>, MethodVisitor> visitor) implements Parentless
    {
        @Override
        public void visit(Molding<?> molding, String owner, MethodVisitor method) {
            this.accessor.visit(molding, owner, method);
            this.visitor.accept(molding, method);
        }

        @Override
        public void accept(Remold.Fields fields) {
            this.accessor.accept(fields);
        }

        @Override
        public DataType getDataType() {
            return this.type;
        }
    }

    public record ParentlessInsertion(DataAccessor dataAccessor, DataType type, VisitorInserter inserter) implements Parentless
    {
        @Override
        public void visit(Molding<?> molding, String owner, MethodVisitor method) {
            this.inserter.insert(molding, method, methodVisitor -> this.dataAccessor.visit(molding, owner, (MethodVisitor)methodVisitor));
        }

        @Override
        public void accept(Remold.Fields fields) {
            this.dataAccessor.accept(fields);
        }

        @Override
        public DataType getDataType() {
            return this.type;
        }
    }

    @FunctionalInterface
    public static interface VisitorInserter {
        public void insert(Molding<?> var1, MethodVisitor var2, Consumer<MethodVisitor> var3);
    }

    public static abstract class Constant
    implements Parentless {
        private final Object value;
        private final DataType type;

        public Constant(Object value, DataType type) {
            this.value = value;
            this.type = type;
        }

        @Override
        public void accept(Remold.Fields fields) {
        }

        public Object getValue() {
            return this.value;
        }

        @Override
        public DataType getDataType() {
            return this.type;
        }
    }

    public static interface Parentless
    extends DataAccessor {
        @Override
        default public void visitParent(Molding<?> molding, String owner, MethodVisitor method) {
        }

        @Override
        default public void visitIdentifier(Molding<?> molding, String owner, MethodVisitor method) {
        }

        @Override
        default public boolean isIdentifierAnIndex() {
            return false;
        }
    }
}

