/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.blueprint.core.api.conditions;

import com.google.common.collect.Maps;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import com.teamabnormals.blueprint.core.api.conditions.config.IConfigPredicate;
import com.teamabnormals.blueprint.core.api.conditions.config.IConfigPredicateSerializer;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.common.crafting.conditions.ICondition;
import net.minecraftforge.common.crafting.conditions.IConditionSerializer;

public class ConfigValueCondition
implements ICondition {
    private final ForgeConfigSpec.ConfigValue<?> value;
    private final String valueID;
    private final Map<IConfigPredicate, Boolean> predicates;
    private final boolean inverted;
    private final ResourceLocation location;

    public ConfigValueCondition(ResourceLocation location, ForgeConfigSpec.ConfigValue<?> value, String valueID, Map<IConfigPredicate, Boolean> predicates, boolean inverted) {
        this.location = location;
        this.value = value;
        this.valueID = valueID;
        this.predicates = predicates;
        this.inverted = inverted;
    }

    public ConfigValueCondition(String modid, String valueID, Map<IConfigPredicate, Boolean> predicates, boolean inverted) {
        this(new ResourceLocation(modid, "config"), null, valueID, predicates, inverted);
    }

    public ConfigValueCondition(String modid, String valueID, boolean inverted) {
        this(modid, valueID, Maps.newHashMap(), inverted);
    }

    public ConfigValueCondition(String modid, String valueID) {
        this(modid, valueID, false);
    }

    public ResourceLocation getID() {
        return this.location;
    }

    public boolean test(ICondition.IContext context) {
        boolean returnValue;
        Map<IConfigPredicate, Boolean> predicates = this.predicates;
        ForgeConfigSpec.ConfigValue<?> value = this.value;
        if (predicates.size() > 0) {
            returnValue = predicates.keySet().stream().allMatch(c -> ((Boolean)predicates.get(c)).booleanValue() != c.test(value));
        } else {
            Object object = value.get();
            if (object instanceof Boolean) {
                Boolean bool = (Boolean)object;
                returnValue = bool;
            } else {
                throw new IllegalStateException("Predicates required for non-boolean ConfigLootCondition, but none found");
            }
        }
        return this.inverted != returnValue;
    }

    public static class Serializer
    implements IConditionSerializer<ConfigValueCondition> {
        public static final Hashtable<ResourceLocation, IConfigPredicateSerializer<?>> CONFIG_PREDICATE_SERIALIZERS = new Hashtable();
        private final Map<String, ForgeConfigSpec.ConfigValue<?>> configValues;
        private final ResourceLocation location;

        public Serializer(String modId, Map<String, ForgeConfigSpec.ConfigValue<?>> configValues) {
            this.location = new ResourceLocation(modId, "config");
            this.configValues = configValues;
        }

        public void write(JsonObject json, ConfigValueCondition value) {
            json.addProperty("value", value.valueID);
            if (!value.predicates.isEmpty()) {
                JsonArray predicates = new JsonArray();
                json.add("predicates", (JsonElement)predicates);
                for (Map.Entry<IConfigPredicate, Boolean> predicatePair : value.predicates.entrySet()) {
                    IConfigPredicate predicate = predicatePair.getKey();
                    ResourceLocation predicateID = predicate.getID();
                    JsonObject object = new JsonObject();
                    predicates.add((JsonElement)object);
                    object.addProperty("type", predicateID.toString());
                    CONFIG_PREDICATE_SERIALIZERS.get(predicateID).write(object, predicate);
                    object.addProperty("inverted", predicatePair.getValue());
                }
            }
            if (value.inverted) {
                json.addProperty("inverted", Boolean.valueOf(true));
            }
        }

        public ConfigValueCondition read(JsonObject json) {
            if (!json.has("value")) {
                throw new JsonSyntaxException("Missing 'value', expected to find a string");
            }
            String name = GsonHelper.m_13906_((JsonObject)json, (String)"value");
            ForgeConfigSpec.ConfigValue<?> configValue = this.configValues.get(name);
            if (configValue == null) {
                throw new JsonSyntaxException("No config value of name '" + name + "' found");
            }
            HashMap<IConfigPredicate, Boolean> predicates = new HashMap<IConfigPredicate, Boolean>();
            if (GsonHelper.m_13900_((JsonObject)json, (String)"predicates")) {
                for (JsonElement predicateElement : GsonHelper.m_13933_((JsonObject)json, (String)"predicates")) {
                    if (!predicateElement.isJsonObject()) {
                        throw new JsonSyntaxException("Predicates must be an array of JsonObjects");
                    }
                    JsonObject predicateObject = predicateElement.getAsJsonObject();
                    ResourceLocation type = new ResourceLocation(GsonHelper.m_13906_((JsonObject)predicateObject, (String)"type"));
                    IConfigPredicateSerializer<?> serializer = CONFIG_PREDICATE_SERIALIZERS.get(type);
                    if (serializer == null) {
                        throw new JsonSyntaxException("Unknown predicate type: " + type);
                    }
                    predicates.put((IConfigPredicate)serializer.read(predicateObject), predicateObject.has("inverted") && GsonHelper.m_13912_((JsonObject)predicateObject, (String)"inverted"));
                }
            } else if (!(configValue.get() instanceof Boolean)) {
                throw new JsonSyntaxException("Missing 'predicates' for non-boolean config value '" + name + "', expected to find an array");
            }
            return new ConfigValueCondition(this.location, configValue, name, predicates, json.has("inverted") && GsonHelper.m_13912_((JsonObject)json, (String)"inverted"));
        }

        public ResourceLocation getID() {
            return this.location;
        }
    }
}

