/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.blueprint.core.util.item;

import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.registries.ForgeRegistries;

public class ItemStackBuilder {
    private final ItemStack stack;
    private final CompoundTag tag;

    public ItemStackBuilder(ItemStack stack) {
        this.stack = stack;
        this.tag = stack.m_41784_();
    }

    public ItemStackBuilder(ItemLike item) {
        this(new ItemStack(item));
    }

    public ItemStackBuilder setCount(int count) {
        this.stack.m_41764_(count);
        return this;
    }

    public ItemStackBuilder grow(int amount) {
        this.stack.m_41769_(amount);
        return this;
    }

    public ItemStackBuilder shrink(int amount) {
        this.stack.m_41774_(amount);
        return this;
    }

    public ItemStackBuilder setUnbreakable() {
        this.tag.m_128379_("Unbreakable", true);
        return this;
    }

    public ItemStackBuilder addEnchantment(Enchantment enchantment, int level) {
        this.stack.m_41663_(enchantment, level);
        return this;
    }

    public ItemStackBuilder setName(@Nullable Component text) {
        this.stack.m_41714_(text);
        return this;
    }

    public ItemStackBuilder addLore(Component text) {
        ListTag loreListTag;
        CompoundTag display = this.stack.m_41698_("display");
        if (display.m_128425_("Lore", 9)) {
            loreListTag = display.m_128437_("Lore", 8);
        } else {
            loreListTag = new ListTag();
            display.m_128365_("Lore", (Tag)loreListTag);
        }
        loreListTag.add((Object)StringTag.m_129297_((String)Component.Serializer.m_130703_((Component)text)));
        return this;
    }

    public ItemStackBuilder addAttributeModifier(Attribute attribute, AttributeModifier modifier, @Nullable EquipmentSlot slot) {
        this.stack.m_41643_(attribute, modifier, slot);
        return this;
    }

    public ItemStackBuilder addAttributeModifier(Attribute attribute, AttributeModifier modifier, EquipmentSlot ... slots) {
        for (EquipmentSlot slot : slots) {
            this.stack.m_41643_(attribute, modifier, slot);
        }
        return this;
    }

    public ItemStackBuilder addPredicate(String key, String predicate) {
        ListTag predicateList;
        if (this.tag.m_128425_(key, 9)) {
            predicateList = this.tag.m_128437_(key, 8);
        } else {
            predicateList = new ListTag();
            this.tag.m_128365_(key, (Tag)predicateList);
        }
        predicateList.add((Object)StringTag.m_129297_((String)predicate));
        return this;
    }

    public ItemStackBuilder addCanDestroy(Block block) {
        return this.addPredicate("CanDestroy", ForgeRegistries.BLOCKS.getKey((Object)block).toString());
    }

    public ItemStackBuilder addCanPlaceOn(Block block) {
        return this.addPredicate("CanPlaceOn", ForgeRegistries.BLOCKS.getKey((Object)block).toString());
    }

    public ItemStack build() {
        return this.stack.m_41777_();
    }
}

