/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.blueprint.core.util.registry;

import com.mojang.datafixers.util.Pair;
import com.teamabnormals.blueprint.common.item.BlueprintBoatItem;
import com.teamabnormals.blueprint.common.item.FuelItem;
import com.teamabnormals.blueprint.core.registry.BlueprintBoatTypes;
import com.teamabnormals.blueprint.core.util.registry.AbstractSubRegistryHelper;
import com.teamabnormals.blueprint.core.util.registry.RegistryHelper;
import java.util.function.Supplier;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.DoubleHighBlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.StandingAndWallBlockItem;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.common.ForgeSpawnEggItem;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;

public class ItemSubRegistryHelper
extends AbstractSubRegistryHelper<Item> {
    public ItemSubRegistryHelper(RegistryHelper parent, DeferredRegister<Item> deferredRegister) {
        super(parent, deferredRegister);
    }

    public ItemSubRegistryHelper(RegistryHelper parent) {
        super(parent, DeferredRegister.create((IForgeRegistry)ForgeRegistries.ITEMS, (String)parent.getModId()));
    }

    public static BlockItem createStandingAndWallBlockItem(Block floorBlock, Block wallBlock, Direction direction) {
        return new StandingAndWallBlockItem(floorBlock, wallBlock, new Item.Properties(), direction);
    }

    public static BlockItem createDoubleHighBlockItem(Block blockForInput) {
        return new DoubleHighBlockItem(blockForInput, new Item.Properties());
    }

    public static FuelItem createFuelItem(int burnTime) {
        return new FuelItem(burnTime, new Item.Properties());
    }

    public static BlockItem createSimpleBlockItem(Block blockForInput) {
        return new BlockItem(blockForInput, new Item.Properties());
    }

    public static Item.Properties createSimpleItemProperty(int stackSize) {
        return new Item.Properties().m_41487_(stackSize);
    }

    public <I extends Item> RegistryObject<I> createItem(String name, Supplier<? extends I> supplier) {
        return this.deferredRegister.register(name, supplier);
    }

    public RegistryObject<ForgeSpawnEggItem> createSpawnEggItem(String entityName, Supplier<EntityType<? extends Mob>> supplier, int primaryColor, int secondaryColor) {
        return this.deferredRegister.register(entityName + "_spawn_egg", () -> new ForgeSpawnEggItem(supplier, primaryColor, secondaryColor, new Item.Properties()));
    }

    public Pair<RegistryObject<Item>, RegistryObject<Item>> createBoatAndChestBoatItem(String wood, RegistryObject<Block> block, boolean raft) {
        ResourceLocation name = new ResourceLocation(this.parent.getModId(), wood);
        RegistryObject boat = this.deferredRegister.register(wood + "_boat", () -> new BlueprintBoatItem(false, name, ItemSubRegistryHelper.createSimpleItemProperty(1)));
        RegistryObject chestBoat = this.deferredRegister.register(wood + "_chest_boat", () -> new BlueprintBoatItem(true, name, ItemSubRegistryHelper.createSimpleItemProperty(1)));
        BlueprintBoatTypes.registerType(name, (Supplier<Item>)boat, (Supplier<Item>)chestBoat, block, raft);
        return Pair.of((Object)boat, (Object)chestBoat);
    }

    public Pair<RegistryObject<Item>, RegistryObject<Item>> createBoatAndChestBoatItem(String wood, RegistryObject<Block> block) {
        return this.createBoatAndChestBoatItem(wood, block, false);
    }
}

