/*
 * Decompiled with CFR 0.152.
 */
package com.faboslav.friendsandfoes.common.entity.ai.brain.task.coppergolem;

import com.faboslav.friendsandfoes.common.entity.CopperGolemEntity;
import com.faboslav.friendsandfoes.common.entity.ai.brain.CopperGolemBrain;
import com.faboslav.friendsandfoes.common.init.FriendsAndFoesMemoryModuleTypes;
import com.faboslav.friendsandfoes.common.tag.FriendsAndFoesTags;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.TimeUtil;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.memory.MemoryStatus;

public final class CopperGolemLocateButtonTask
extends Behavior<CopperGolemEntity> {
    public CopperGolemLocateButtonTask() {
        super(Map.of(FriendsAndFoesMemoryModuleTypes.COPPER_GOLEM_PRESS_BUTTON_COOLDOWN.get(), MemoryStatus.VALUE_ABSENT, FriendsAndFoesMemoryModuleTypes.COPPER_GOLEM_BUTTON_POS.get(), MemoryStatus.VALUE_ABSENT, FriendsAndFoesMemoryModuleTypes.COPPER_GOLEM_IS_OXIDIZED.get(), MemoryStatus.VALUE_ABSENT));
    }

    protected void run(ServerLevel world, CopperGolemEntity copperGolem, long time) {
        BlockPos buttonBlockPos = this.findNearestRandomButton(copperGolem);
        if (buttonBlockPos == null) {
            CopperGolemBrain.setPressButtonCooldown(copperGolem, TimeUtil.m_145020_((int)10, (int)10));
            return;
        }
        ResourceKey registryKey = copperGolem.m_9236_().m_46472_();
        copperGolem.m_6274_().m_21879_(FriendsAndFoesMemoryModuleTypes.COPPER_GOLEM_BUTTON_POS.get(), (Object)GlobalPos.m_122643_((ResourceKey)registryKey, (BlockPos)buttonBlockPos));
    }

    private BlockPos findNearestRandomButton(CopperGolemEntity copperGolem) {
        int horizontalRange = 16;
        int verticalRange = 8;
        List<BlockPos> buttons = this.findAllButtonsInRange(copperGolem.m_20183_(), horizontalRange, verticalRange, blockPos -> copperGolem.m_9236_().m_8055_(blockPos).m_204336_(FriendsAndFoesTags.COPPER_BUTTONS));
        if (buttons.isEmpty()) {
            return null;
        }
        return buttons.get(copperGolem.m_217043_().m_188503_(buttons.size()));
    }

    private List<BlockPos> findAllButtonsInRange(BlockPos copperGolemPos, int horizontalRange, int verticalRange, Predicate<BlockPos> condition) {
        ArrayList<BlockPos> buttons = new ArrayList<BlockPos>();
        for (BlockPos blockPos : BlockPos.m_121925_((BlockPos)copperGolemPos, (int)horizontalRange, (int)verticalRange, (int)horizontalRange)) {
            BlockPos.MutableBlockPos possibleButtonBlockPos = blockPos.m_122032_();
            if (!condition.test((BlockPos)possibleButtonBlockPos)) continue;
            buttons.add((BlockPos)possibleButtonBlockPos);
        }
        return buttons;
    }
}

