/*
 * Decompiled with CFR 0.152.
 */
package com.faboslav.friendsandfoes.common.mixin;

import com.faboslav.friendsandfoes.common.client.render.entity.renderer.PlayerIllusionEntityRenderer;
import com.faboslav.friendsandfoes.common.entity.PlayerIllusionEntity;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.world.entity.Entity;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={EntityRenderDispatcher.class})
public abstract class EntityRenderDispatcherMixin {
    private static final Map<String, EntityRendererProvider<PlayerIllusionEntity>> PLAYER_ILLUSION_RENDERER_FACTORIES = ImmutableMap.of((Object)"default", context -> new PlayerIllusionEntityRenderer(context, false), (Object)"slim", context -> new PlayerIllusionEntityRenderer(context, true));
    @Unique
    private Map<String, EntityRenderer<? extends PlayerIllusionEntity>> illusionModelRenderers = ImmutableMap.of();

    @Inject(method={"getRenderer"}, at={@At(value="HEAD")}, cancellable=true)
    public <T extends Entity> void friendsandfoes_getRenderer(T entity, CallbackInfoReturnable<EntityRenderer<? super T>> cir) {
        if (entity instanceof PlayerIllusionEntity) {
            String string = ((PlayerIllusionEntity)entity).getModel();
            EntityRenderer<? extends PlayerIllusionEntity> entityRenderer = this.illusionModelRenderers.get(string);
            entityRenderer = entityRenderer != null ? entityRenderer : this.illusionModelRenderers.get("default");
            cir.setReturnValue(entityRenderer);
        }
    }

    @ModifyVariable(method={"reload"}, ordinal=0, at=@At(value="LOAD"))
    public EntityRendererProvider.Context friendsandfoes_reload(EntityRendererProvider.Context context) {
        this.illusionModelRenderers = EntityRenderDispatcherMixin.friendsandfoes_reloadPlayerIllusionRenderers(context);
        return context;
    }

    private static Map<String, EntityRenderer<? extends PlayerIllusionEntity>> friendsandfoes_reloadPlayerIllusionRenderers(EntityRendererProvider.Context ctx) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        PLAYER_ILLUSION_RENDERER_FACTORIES.forEach((type, factory) -> {
            try {
                builder.put(type, (Object)factory.m_174009_(ctx));
            }
            catch (Exception exception) {
                throw new IllegalArgumentException("Failed to create player illusion model for " + type, exception);
            }
        });
        return builder.build();
    }
}

