/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.moonlight.core.misc;

import it.unimi.dsi.fastutil.objects.Object2ObjectArrayMap;
import java.util.ArrayList;
import java.util.Map;
import java.util.function.BiFunction;
import net.mehvahdjukaar.moonlight.api.platform.PlatHelper;
import net.mehvahdjukaar.moonlight.core.Moonlight;
import net.mehvahdjukaar.moonlight.core.misc.FakeLevel;
import net.mehvahdjukaar.moonlight.core.misc.FakeServerLevel;
import net.minecraft.core.RegistryAccess;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.VisibleForTesting;

public class FakeLevelManager {
    protected static final Map<String, Level> INSTANCES = new Object2ObjectArrayMap();

    @ApiStatus.Internal
    @VisibleForTesting
    public static void invalidateAll() {
        new ArrayList<Level>(INSTANCES.values()).forEach(FakeLevelManager::invalidate);
    }

    public static boolean invalidate(Level level) {
        boolean removed = INSTANCES.entrySet().removeIf(e -> e.getValue() == level);
        if (level != null) {
            PlatHelper.invokeLevelUnload(level);
        }
        try {
            if (level instanceof FakeServerLevel) {
                level.close();
            }
        }
        catch (Exception e2) {
            if (PlatHelper.isDev()) {
                throw new RuntimeException(e2);
            }
            Moonlight.LOGGER.error("An error occurred while closing fake level", (Throwable)e2);
        }
        return removed;
    }

    @Deprecated(forRemoval=true)
    public static void invalidate(String name) {
    }

    public static FakeLevel getDefaultClient(Level original) {
        return FakeLevelManager.getClient("dummy_world", original, FakeLevel::new);
    }

    public static <T extends FakeLevel> T getClient(String id, Level original, BiFunction<String, RegistryAccess, FakeLevel> constructor) {
        Object finalId = id = "client_" + (String)id;
        return (T)((Object)((FakeLevel)INSTANCES.computeIfAbsent((String)id, arg_0 -> FakeLevelManager.lambda$getClient$1(constructor, (String)finalId, original, arg_0))));
    }

    public static FakeServerLevel getDefaultServer(ServerLevel original) {
        return FakeLevelManager.getServer("dummy_world", original, FakeServerLevel::new);
    }

    public static <T extends FakeServerLevel> T getServer(String id, ServerLevel original, BiFunction<String, ServerLevel, FakeServerLevel> constructor) {
        Object finalId = id = "server_" + (String)id;
        return (T)((Object)((FakeServerLevel)INSTANCES.computeIfAbsent((String)id, arg_0 -> FakeLevelManager.lambda$getServer$2(constructor, (String)finalId, original, arg_0))));
    }

    public static Level get(String id, Level original, BiFunction<String, RegistryAccess, FakeLevel> clientConstr, BiFunction<String, ServerLevel, FakeServerLevel> serverConstr) {
        if (original instanceof ServerLevel) {
            ServerLevel sl = (ServerLevel)original;
            return FakeLevelManager.getServer(id, sl, serverConstr);
        }
        return FakeLevelManager.getClient(id, original, clientConstr);
    }

    public static Level getDefault(Level original) {
        if (original instanceof ServerLevel) {
            ServerLevel sl = (ServerLevel)original;
            return FakeLevelManager.getDefaultServer(sl);
        }
        return FakeLevelManager.getDefaultClient(original);
    }

    private static /* synthetic */ Level lambda$getServer$2(BiFunction constructor, String finalId, ServerLevel original, String k) {
        return (Level)constructor.apply(finalId, original);
    }

    private static /* synthetic */ Level lambda$getClient$1(BiFunction constructor, String finalId, Level original, String k) {
        return (Level)constructor.apply(finalId, original.m_9598_());
    }

    public static interface ILevelLike {
        public Level cast();
    }
}

