/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.api.client.registry.display;

import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import me.shedaniel.math.Rectangle;
import me.shedaniel.rei.api.client.gui.DisplayRenderer;
import me.shedaniel.rei.api.client.gui.Renderer;
import me.shedaniel.rei.api.client.gui.SimpleDisplayRenderer;
import me.shedaniel.rei.api.client.gui.widgets.Widget;
import me.shedaniel.rei.api.client.gui.widgets.Widgets;
import me.shedaniel.rei.api.client.registry.display.DisplayCategoryView;
import me.shedaniel.rei.api.common.category.CategoryIdentifier;
import me.shedaniel.rei.api.common.display.Display;
import me.shedaniel.rei.api.common.display.DisplayMerger;
import me.shedaniel.rei.api.common.entry.EntryIngredient;
import me.shedaniel.rei.api.common.util.Identifiable;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

@OnlyIn(value=Dist.CLIENT)
public interface DisplayCategory<T extends Display>
extends DisplayCategoryView<T>,
Identifiable {
    public CategoryIdentifier<? extends T> getCategoryIdentifier();

    public Component getTitle();

    public Renderer getIcon();

    @Override
    @ApiStatus.OverrideOnly
    default public DisplayRenderer getDisplayRenderer(T display) {
        return SimpleDisplayRenderer.from(display.getInputEntries(), display.getOutputEntries());
    }

    @Override
    @ApiStatus.OverrideOnly
    default public List<Widget> setupDisplay(T display, Rectangle bounds) {
        return Collections.singletonList(Widgets.createRecipeBase(bounds));
    }

    default public int getDisplayHeight() {
        return 66;
    }

    default public int getDisplayWidth(T display) {
        return 150;
    }

    default public int getMaximumDisplaysPerPage() {
        return 99;
    }

    default public int getFixedDisplaysPerPage() {
        return -1;
    }

    @Nullable
    default public DisplayMerger<T> getDisplayMerger() {
        return null;
    }

    public static <T extends Display> DisplayMerger<T> getContentMerger() {
        return new DisplayMerger<T>(){

            @Override
            public boolean canMerge(T first, T second) {
                if (!first.getCategoryIdentifier().equals(second.getCategoryIdentifier())) {
                    return false;
                }
                if (!this.equals(first.getInputEntries(), second.getInputEntries())) {
                    return false;
                }
                return this.equals(first.getOutputEntries(), second.getOutputEntries());
            }

            @Override
            public int hashOf(T display) {
                return display.getCategoryIdentifier().hashCode() * 31 * 31 * 31 + display.getInputEntries().hashCode() * 31 * 31 + display.getOutputEntries().hashCode();
            }

            private boolean equals(List<EntryIngredient> l1, List<EntryIngredient> l2) {
                if (l1.size() != l2.size()) {
                    return false;
                }
                Iterator<EntryIngredient> it1 = l1.iterator();
                Iterator<EntryIngredient> it2 = l2.iterator();
                while (it1.hasNext() && it2.hasNext()) {
                    if (it1.next().equals(it2.next())) continue;
                    return false;
                }
                return true;
            }
        };
    }

    @Override
    default public ResourceLocation getIdentifier() {
        return this.getCategoryIdentifier().getIdentifier();
    }
}

