/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.impl.client.config;

import java.util.ArrayList;
import java.util.List;
import me.shedaniel.autoconfig.AutoConfig;
import me.shedaniel.autoconfig.ConfigData;
import me.shedaniel.autoconfig.annotation.Config;
import me.shedaniel.autoconfig.serializer.JanksonConfigSerializer;
import me.shedaniel.cloth.clothconfig.shadowed.blue.endless.jankson.Jankson;
import me.shedaniel.rei.api.client.favorites.FavoriteEntry;
import me.shedaniel.rei.impl.client.config.ConfigManagerImpl;
import me.shedaniel.rei.impl.client.config.ConfigObjectImpl;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.InteractionResult;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public class FavoritesConfigManager {
    private static final FavoritesConfigManager INSTANCE = new FavoritesConfigManager();
    private FavoritesConfigObject object;

    public FavoritesConfigManager() {
        AutoConfig.register(FavoritesConfigObject.class, (definition, configClass) -> new JanksonConfigSerializer(definition, configClass, ConfigManagerImpl.buildJankson(Jankson.builder())));
    }

    public static FavoritesConfigManager getInstance() {
        return INSTANCE;
    }

    public void saveConfig() {
        AutoConfig.getConfigHolder(FavoritesConfigObject.class).registerLoadListener((configHolder, configObject) -> {
            this.object = configObject;
            return InteractionResult.PASS;
        });
        AutoConfig.getConfigHolder(FavoritesConfigObject.class).save();
    }

    public FavoritesConfigObject getConfig() {
        if (this.object == null) {
            this.object = (FavoritesConfigObject)AutoConfig.getConfigHolder(FavoritesConfigObject.class).getConfig();
        }
        return this.object;
    }

    public void syncFrom(ConfigManagerImpl manager) {
        ConfigObjectImpl.Basics basics = manager.getConfig().basics;
        FavoritesConfigObject config = this.getConfig();
        config.favorites.addAll(basics.favorites);
        config.hiddenFavorites.addAll(basics.hiddenFavorites);
        config.displays.addAll(basics.displayHistory);
        basics.favorites.clear();
        basics.hiddenFavorites.clear();
        basics.displayHistory.clear();
        manager.saveConfig();
        this.saveConfig();
    }

    @Config(name="roughlyenoughitems/favorites")
    @OnlyIn(value=Dist.CLIENT)
    public static final class FavoritesConfigObject
    implements ConfigData {
        public List<FavoriteEntry> favorites = new ArrayList<FavoriteEntry>();
        public List<FavoriteEntry> hiddenFavorites = new ArrayList<FavoriteEntry>();
        public List<CompoundTag> displays = new ArrayList<CompoundTag>();
    }
}

