/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.impl.client.config.entries;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Supplier;
import me.shedaniel.clothconfig2.gui.widget.DynamicElementListWidget;
import me.shedaniel.clothconfig2.gui.widget.DynamicEntryListWidget;
import me.shedaniel.rei.api.client.entry.filtering.FilteringRule;
import me.shedaniel.rei.api.client.entry.filtering.FilteringRuleType;
import me.shedaniel.rei.api.client.entry.filtering.FilteringRuleTypeRegistry;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarratableEntry;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.locale.Language;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;

public class FilteringAddRuleScreen
extends Screen {
    private final List<FilteringRule<?>> rules;
    private RulesList rulesList;
    Screen parent;

    public FilteringAddRuleScreen(List<FilteringRule<?>> rules) {
        super((Component)Component.m_237115_((String)"config.roughlyenoughitems.filteringRulesScreen.new"));
        this.rules = rules;
    }

    public void m_7856_() {
        super.m_7856_();
        MutableComponent backText = Component.m_237113_((String)"\u21a9 ").m_7220_((Component)Component.m_237115_((String)"gui.back"));
        this.m_142416_((GuiEventListener)new Button(4, 4, Minecraft.m_91087_().f_91062_.m_92852_((FormattedText)backText) + 10, 20, (Component)backText, button -> {
            this.f_96541_.m_91152_(this.parent);
            this.parent = null;
        }, Supplier::get){});
        this.rulesList = (RulesList)this.m_7787_((GuiEventListener)new RulesList(this.f_96541_, this.f_96543_, this.f_96544_, 30, this.f_96544_, f_279548_));
        for (FilteringRuleType rule : FilteringRuleTypeRegistry.getInstance()) {
            if (rule.isSingular()) continue;
            this.rulesList.addItem(new DefaultRuleEntry(this.parent, this.rules, (FilteringRule<?>)rule.createNew(), null));
        }
        this.rulesList.selectItem((DynamicEntryListWidget.Entry)((RuleEntry)((Object)this.rulesList.m_6702_().get(0))));
    }

    public void m_88315_(GuiGraphics graphics, int mouseX, int mouseY, float delta) {
        this.rulesList.m_88315_(graphics, mouseX, mouseY, delta);
        super.m_88315_(graphics, mouseX, mouseY, delta);
        graphics.m_280648_(this.f_96547_, this.f_96539_.m_7532_(), (int)((float)this.f_96543_ / 2.0f - (float)this.f_96547_.m_92852_((FormattedText)this.f_96539_) / 2.0f), 12, -1);
    }

    public void m_7379_() {
        this.f_96541_.m_91152_(this.parent);
    }

    public static class RulesList
    extends DynamicElementListWidget<RuleEntry> {
        private boolean inFocus;

        public RulesList(Minecraft client, int width, int height, int top, int bottom, ResourceLocation backgroundLocation) {
            super(client, width, height, top, bottom, backgroundLocation);
        }

        protected boolean isSelected(int index) {
            return Objects.equals(this.getSelectedItem(), this.m_6702_().get(index));
        }

        protected int addItem(RuleEntry item) {
            return super.addItem((DynamicEntryListWidget.Entry)item);
        }

        public int getItemWidth() {
            return this.width - 40;
        }

        protected int getScrollbarPosition() {
            return this.width - 14;
        }
    }

    public static class DefaultRuleEntry
    extends RuleEntry {
        private final Button addButton;
        private final Function<Screen, Screen> screenFunction;

        public DefaultRuleEntry(Screen parent, List<FilteringRule<?>> rules, FilteringRule<?> rule, Function<Screen, Screen> screenFunction) {
            super(rule);
            this.screenFunction = screenFunction == null ? rule.getType().createEntryScreen(rule) : screenFunction;
            this.addButton = new Button(0, 0, 20, 20, Component.m_130674_((String)" + "), button -> {
                Minecraft.m_91087_().m_91152_(this.screenFunction.apply(parent));
                rules.add(0, rule);
            }, Supplier::get){};
            this.addButton.f_93623_ = this.screenFunction != null;
        }

        public void render(GuiGraphics graphics, int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean isHovered, float delta) {
            Minecraft client = Minecraft.m_91087_();
            Component title = this.getRule().getType().getTitle(this.getRule());
            int i = client.f_91062_.m_92852_((FormattedText)title);
            if (i > entryWidth - 28) {
                FormattedText titleTrimmed = FormattedText.m_130773_((FormattedText[])new FormattedText[]{client.f_91062_.m_92854_((FormattedText)title, entryWidth - 28 - client.f_91062_.m_92895_("...")), FormattedText.m_130775_((String)"...")});
                graphics.m_280648_(client.f_91062_, Language.m_128107_().m_5536_(titleTrimmed), x + 2, y + 1, 0xFFFFFF);
            } else {
                graphics.m_280648_(client.f_91062_, title.m_7532_(), x + 2, y + 1, 0xFFFFFF);
            }
            Component subtitle = this.getRule().getType().getSubtitle(this.getRule());
            i = client.f_91062_.m_92852_((FormattedText)subtitle);
            if (i > entryWidth - 28) {
                FormattedText subtitleTrimmed = FormattedText.m_130773_((FormattedText[])new FormattedText[]{client.f_91062_.m_92854_((FormattedText)subtitle, entryWidth - 28 - client.f_91062_.m_92895_("...")), FormattedText.m_130775_((String)"...")});
                graphics.m_280648_(client.f_91062_, Language.m_128107_().m_5536_(subtitleTrimmed), x + 2, y + 12, 0x808080);
            } else {
                graphics.m_280648_(client.f_91062_, subtitle.m_7532_(), x + 2, y + 12, 0x808080);
            }
            this.addButton.m_252865_(x + entryWidth - 25);
            this.addButton.m_253211_(y + 1);
            this.addButton.m_88315_(graphics, mouseX, mouseY, delta);
        }

        public List<? extends GuiEventListener> m_6702_() {
            return Collections.singletonList(this.addButton);
        }

        public List<? extends NarratableEntry> narratables() {
            return Collections.singletonList(this.addButton);
        }
    }

    public static abstract class RuleEntry
    extends DynamicElementListWidget.ElementEntry<RuleEntry> {
        private final FilteringRule<?> rule;

        public RuleEntry(FilteringRule<?> rule) {
            this.rule = rule;
        }

        public FilteringRule<?> getRule() {
            return this.rule;
        }

        public int getItemHeight() {
            return 26;
        }
    }
}

