/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.impl.client.gui.performance;

import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import me.shedaniel.clothconfig2.gui.widget.DynamicElementListWidget;
import me.shedaniel.clothconfig2.gui.widget.DynamicEntryListWidget;
import me.shedaniel.math.Rectangle;
import me.shedaniel.rei.RoughlyEnoughItemsCore;
import me.shedaniel.rei.api.common.plugins.REIPlugin;
import me.shedaniel.rei.api.common.plugins.REIPluginProvider;
import me.shedaniel.rei.api.common.util.CollectionUtils;
import me.shedaniel.rei.impl.client.gui.modules.Menu;
import me.shedaniel.rei.impl.client.gui.modules.entries.ToggleMenuEntry;
import me.shedaniel.rei.impl.client.gui.performance.entry.PerformanceEntryImpl;
import me.shedaniel.rei.impl.client.gui.performance.entry.SubCategoryListEntry;
import me.shedaniel.rei.impl.client.gui.screen.ScreenWithMenu;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextColor;
import net.minecraft.util.FormattedCharSequence;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class PerformanceScreen
extends ScreenWithMenu {
    private Runnable onClose;
    private PerformanceEntryListWidget list;
    private SortType sortType = SortType.ORDER;

    public PerformanceScreen(Runnable onClose) {
        super((Component)Component.m_237115_((String)"text.rei.performance"));
        this.onClose = onClose;
    }

    public static FormattedCharSequence formatTime(long time, boolean total) {
        TimeUnit unit = PerformanceScreen.chooseUnit(time);
        double value = (double)time / (double)TimeUnit.NANOSECONDS.convert(1L, unit);
        return Component.m_237113_((String)(String.format(Locale.ROOT, "%.4g", value) + " " + PerformanceScreen.abbreviate(unit))).m_130938_(style -> style.m_131148_(TextColor.m_131266_((int)PerformanceScreen.chooseColor(TimeUnit.MILLISECONDS.convert(time, TimeUnit.NANOSECONDS), total)))).m_7532_();
    }

    private static int chooseColor(long time, boolean total) {
        if (time > (long)(total ? 2500 : 1000)) {
            return 0xFF5555;
        }
        if (time > (long)(total ? 700 : 300)) {
            return 16754176;
        }
        if (time > (long)(total ? 200 : 100)) {
            return 16773143;
        }
        return 0x12FF22;
    }

    private static TimeUnit chooseUnit(long nanos) {
        if (TimeUnit.DAYS.convert(nanos, TimeUnit.NANOSECONDS) > 0L) {
            return TimeUnit.DAYS;
        }
        if (TimeUnit.HOURS.convert(nanos, TimeUnit.NANOSECONDS) > 0L) {
            return TimeUnit.HOURS;
        }
        if (TimeUnit.MINUTES.convert(nanos, TimeUnit.NANOSECONDS) > 0L) {
            return TimeUnit.MINUTES;
        }
        if (TimeUnit.SECONDS.convert(nanos, TimeUnit.NANOSECONDS) > 0L) {
            return TimeUnit.SECONDS;
        }
        if (TimeUnit.MILLISECONDS.convert(nanos, TimeUnit.NANOSECONDS) > 0L) {
            return TimeUnit.MILLISECONDS;
        }
        if (TimeUnit.MICROSECONDS.convert(nanos, TimeUnit.NANOSECONDS) > 0L) {
            return TimeUnit.MICROSECONDS;
        }
        return TimeUnit.NANOSECONDS;
    }

    private static String abbreviate(TimeUnit unit) {
        switch (unit) {
            case NANOSECONDS: {
                return "ns";
            }
            case MICROSECONDS: {
                return "\u03bcs";
            }
            case MILLISECONDS: {
                return "ms";
            }
            case SECONDS: {
                return "s";
            }
            case MINUTES: {
                return "min";
            }
            case HOURS: {
                return "h";
            }
            case DAYS: {
                return "d";
            }
        }
        throw new AssertionError();
    }

    public void m_7856_() {
        MutableComponent backText = Component.m_237113_((String)"\u21a9 ").m_7220_((Component)Component.m_237115_((String)"gui.back"));
        this.m_142416_((GuiEventListener)new Button(4, 4, Minecraft.m_91087_().f_91062_.m_92852_((FormattedText)backText) + 10, 20, (Component)backText, button -> {
            this.onClose.run();
            this.onClose = null;
        }, Supplier::get){});
        MutableComponent text = Component.m_237115_((String)"text.rei.sort");
        Rectangle bounds = new Rectangle(this.f_96543_ - 4 - Minecraft.m_91087_().f_91062_.m_92852_((FormattedText)text) - 10, 4, Minecraft.m_91087_().f_91062_.m_92852_((FormattedText)text) + 10, 20);
        this.m_142416_((GuiEventListener)new Button(bounds.x, bounds.y, bounds.width, bounds.height, (Component)text, button -> this.setMenu(new Menu(bounds, CollectionUtils.map(SortType.values(), type -> ToggleMenuEntry.of((Component)Component.m_237110_((String)"text.rei.sort.by", (Object[])new Object[]{type.name().toLowerCase(Locale.ROOT)}), () -> false, o -> {
            this.closeMenu();
            this.sortType = type;
            this.m_6575_(this.f_96541_, this.f_96543_, this.f_96544_);
        })), false)), Supplier::get){});
        this.list = new PerformanceEntryListWidget();
        long[] totalTime = new long[]{0L};
        ArrayList<SubCategoryListEntry> subCategories = new ArrayList<SubCategoryListEntry>();
        RoughlyEnoughItemsCore.PERFORMANCE_LOGGER.getStages().forEach((stage, inner) -> {
            long separateTime;
            ArrayList<PerformanceEntry> entries = new ArrayList<PerformanceEntry>();
            inner.times().forEach((obj, time) -> entries.add(new PerformanceEntryImpl((Component)Component.m_237113_((String)(obj instanceof Pair ? this.getNameOfPlugin(obj) : Objects.toString(obj))), (long)time)));
            Collection<Long> values = inner.times().values();
            Map<Object, Long> map = inner.times();
            synchronized (map) {
                separateTime = values.stream().collect(Collectors.summarizingLong(value -> value)).getSum();
            }
            if (inner.totalNano() - separateTime > 1000000L) {
                entries.add(new PerformanceEntryImpl((Component)Component.m_237113_((String)"Miscellaneous Operations"), inner.totalNano() - separateTime));
            }
            totalTime[0] = totalTime[0] + Math.max(inner.totalNano(), separateTime);
            if (this.sortType == SortType.DURATION) {
                entries.sort(Comparator.comparingLong(value -> value.time).reversed());
            }
            subCategories.add(new SubCategoryListEntry((Component)Component.m_237113_((String)stage), entries, Math.max(inner.totalNano(), separateTime), false));
        });
        if (this.sortType == SortType.DURATION) {
            subCategories.sort(Comparator.comparingLong(SubCategoryListEntry::getTotalTime).reversed());
        }
        subCategories.forEach(this.list::addItem);
        this.list.m_6702_().add(0, new PerformanceEntryImpl((Component)Component.m_237113_((String)"Total Load Time"), totalTime[0]));
        this.m_7787_((GuiEventListener)this.list);
    }

    private String getNameOfPlugin(Object obj) {
        String pluginName;
        Pair pair = (Pair)obj;
        REIPluginProvider provider = (REIPluginProvider)pair.getFirst();
        REIPlugin plugin = (REIPlugin)pair.getSecond();
        Object providerName = provider.getPluginProviderName();
        if (provider.provide().size() >= 1 && !((String)providerName).equals(pluginName = plugin.getPluginProviderName())) {
            providerName = pluginName + " of " + (String)providerName;
        }
        return providerName;
    }

    @Override
    public void m_88315_(GuiGraphics graphics, int mouseX, int mouseY, float delta) {
        this.m_280039_(graphics);
        this.list.m_88315_(graphics, mouseX, mouseY, delta);
        graphics.m_280648_(this.f_96547_, this.f_96539_.m_7532_(), (int)((float)this.f_96543_ / 2.0f - (float)this.f_96547_.m_92852_((FormattedText)this.f_96539_) / 2.0f), 12, -1);
        super.m_88315_(graphics, mouseX, mouseY, delta);
    }

    private static enum SortType {
        ORDER,
        DURATION;

    }

    private class PerformanceEntryListWidget
    extends DynamicElementListWidget<PerformanceEntry> {
        public PerformanceEntryListWidget() {
            super(PerformanceScreen.this.f_96541_, PerformanceScreen.this.f_96543_, PerformanceScreen.this.f_96544_, 30, PerformanceScreen.this.f_96544_, Screen.f_279548_);
        }

        public int getItemWidth() {
            return this.width;
        }

        public int addItem(PerformanceEntry item) {
            return super.addItem((DynamicEntryListWidget.Entry)item);
        }

        protected int getScrollbarPosition() {
            return this.width - 6;
        }
    }

    public static abstract class PerformanceEntry
    extends DynamicElementListWidget.ElementEntry<PerformanceEntry> {
    }
}

