/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.plugin.client.favorites;

import com.mojang.serialization.DataResult;
import com.mojang.serialization.Lifecycle;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import me.shedaniel.math.Rectangle;
import me.shedaniel.rei.api.client.REIRuntime;
import me.shedaniel.rei.api.client.config.ConfigObject;
import me.shedaniel.rei.api.client.favorites.CompoundFavoriteRenderer;
import me.shedaniel.rei.api.client.favorites.FavoriteEntry;
import me.shedaniel.rei.api.client.favorites.FavoriteEntryType;
import me.shedaniel.rei.api.client.favorites.FavoriteMenuEntry;
import me.shedaniel.rei.api.client.gui.Renderer;
import me.shedaniel.rei.api.client.gui.widgets.Tooltip;
import me.shedaniel.rei.api.client.gui.widgets.TooltipContext;
import me.shedaniel.rei.api.common.util.CollectionUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.Holder;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.Nullable;

public class TimeFavoriteEntry
extends FavoriteEntry {
    public static final ResourceLocation ID = new ResourceLocation("roughlyenoughitems", "time");
    public static final String TRANSLATION_KEY = "favorite.section.time";
    private static final ResourceLocation CHEST_GUI_TEXTURE = new ResourceLocation("roughlyenoughitems", "textures/gui/recipecontainer.png");
    public static final String KEY = "mode";
    @Nullable
    private final Time time;

    public TimeFavoriteEntry(@Nullable Time time) {
        this.time = time;
    }

    @Override
    public boolean isInvalid() {
        return false;
    }

    @Override
    public Renderer getRenderer(boolean showcase) {
        if (this.time == null) {
            List renderers = IntStream.range(0, 4).mapToObj(TimeFavoriteEntry::getRenderer).collect(Collectors.toList());
            return new CompoundFavoriteRenderer(showcase, renderers, () -> this.nextTime().ordinal()){

                @Override
                @Nullable
                public Tooltip getTooltip(TooltipContext context) {
                    return Tooltip.create(context.getPoint(), new Component[]{Component.m_237115_((String)"text.rei.time_button.tooltip.dropdown")});
                }

                public boolean equals(Object o) {
                    if (this == o) {
                        return true;
                    }
                    if (o == null || this.getClass() != o.getClass()) {
                        return false;
                    }
                    return this.hashCode() == o.hashCode();
                }

                public int hashCode() {
                    return Objects.hash(this.getClass(), this.showcase);
                }
            };
        }
        return TimeFavoriteEntry.getRenderer(this.time.ordinal());
    }

    private Time nextTime() {
        ClientLevel level = Minecraft.m_91087_().f_91073_;
        long dayTime = level.m_46468_();
        if (dayTime <= 1000L) {
            return Time.MORN;
        }
        if (dayTime <= 6000L) {
            return Time.NOON;
        }
        if (dayTime <= 12000L) {
            return Time.EVENING;
        }
        if (dayTime <= 18000L) {
            return Time.NIGHT;
        }
        return Time.MORN;
    }

    private static Renderer getRenderer(int id) {
        final Time time = Time.values()[id];
        return new Renderer(){

            @Override
            public void render(GuiGraphics graphics, Rectangle bounds, int mouseX, int mouseY, float delta) {
                int color;
                int n = color = bounds.contains(mouseX, mouseY) ? -1118482 : -5592406;
                if (bounds.width > 4 && bounds.height > 4) {
                    graphics.m_280168_().m_85836_();
                    graphics.m_280168_().m_252880_((float)bounds.getCenterX(), (float)bounds.getCenterY(), 0.0f);
                    graphics.m_280168_().m_85841_((float)bounds.getWidth() / 18.0f, (float)bounds.getHeight() / 18.0f, 1.0f);
                    this.renderTimeIcon(graphics, time, 0, 0, color);
                    graphics.m_280168_().m_85849_();
                }
            }

            private void renderTimeIcon(GuiGraphics graphics, Time time2, int centerX, int centerY, int color) {
                graphics.m_280163_(CHEST_GUI_TEXTURE, centerX - 7, centerY - 7, (float)(time2.ordinal() * 14 + 42), 14.0f, 14, 14, 256, 256);
            }

            @Override
            @Nullable
            public Tooltip getTooltip(TooltipContext context) {
                return Tooltip.create(context.getPoint(), new Component[]{Component.m_237110_((String)"text.rei.time_button.tooltip.entry", (Object[])new Object[]{Component.m_237115_((String)("text.rei.time_button.name." + time.name().toLowerCase(Locale.ROOT)))})});
            }

            public boolean equals(Object o) {
                if (this == o) {
                    return true;
                }
                if (o == null || this.getClass() != o.getClass()) {
                    return false;
                }
                return this.hashCode() == o.hashCode();
            }

            public int hashCode() {
                return Objects.hash(new Object[]{this.getClass(), false, time});
            }
        };
    }

    @Override
    public boolean doAction(int button) {
        if (button == 0) {
            Time time = this.time;
            if (time == null) {
                time = this.nextTime();
            }
            Minecraft.m_91087_().f_91074_.f_108617_.m_246623_(StringUtils.removeStart((String)ConfigObject.getInstance().getTimeCommand().replaceAll("\\{time}", time.getPart().toLowerCase(Locale.ROOT)), (String)"/"));
            Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_263171_((Holder)SoundEvents.f_12490_, (float)1.0f));
            return true;
        }
        return false;
    }

    @Override
    public Optional<Supplier<Collection<FavoriteMenuEntry>>> getMenuEntries() {
        if (this.time == null) {
            return Optional.of(this::_getMenuEntries);
        }
        return Optional.empty();
    }

    private Collection<FavoriteMenuEntry> _getMenuEntries() {
        return CollectionUtils.map(Time.values(), TimeMenuEntry::new);
    }

    @Override
    public long hashIgnoreAmount() {
        return this.time == null ? 31290831290L : (long)this.time.ordinal();
    }

    @Override
    public FavoriteEntry copy() {
        return this;
    }

    @Override
    public ResourceLocation getType() {
        return ID;
    }

    @Override
    public boolean isSame(FavoriteEntry other) {
        if (!(other instanceof TimeFavoriteEntry)) {
            return false;
        }
        TimeFavoriteEntry that = (TimeFavoriteEntry)other;
        return Objects.equals((Object)this.time, (Object)that.time);
    }

    public static enum Time {
        MORN("1000"),
        NOON("6000"),
        EVENING("12000"),
        NIGHT("18000");

        String part;

        private Time(String part) {
            this.part = part;
        }

        public String getPart() {
            return this.part;
        }
    }

    public static class TimeMenuEntry
    extends FavoriteMenuEntry {
        public final String text;
        public final Time time;
        private int x;
        private int y;
        private int width;
        private boolean selected;
        private boolean containsMouse;
        private boolean rendering;
        private int textWidth = -69;

        public TimeMenuEntry(Time time) {
            this.text = I18n.m_118938_((String)("text.rei.time_button.name." + time.name().toLowerCase(Locale.ROOT)), (Object[])new Object[0]);
            this.time = time;
        }

        private int getTextWidth() {
            if (this.textWidth == -69) {
                this.textWidth = Math.max(0, this.font.m_92895_(this.text));
            }
            return this.textWidth;
        }

        @Override
        public int getEntryWidth() {
            return this.getTextWidth() + 4;
        }

        @Override
        public int getEntryHeight() {
            return 12;
        }

        public List<? extends GuiEventListener> m_6702_() {
            return Collections.emptyList();
        }

        @Override
        public void updateInformation(int xPos, int yPos, boolean selected, boolean containsMouse, boolean rendering, int width) {
            this.x = xPos;
            this.y = yPos;
            this.selected = selected;
            this.containsMouse = containsMouse;
            this.rendering = rendering;
            this.width = width;
        }

        public void m_88315_(GuiGraphics graphics, int mouseX, int mouseY, float delta) {
            if (this.selected) {
                graphics.m_280509_(this.x, this.y, this.x + this.width, this.y + 12, -12237499);
            }
            if (this.selected && this.containsMouse) {
                REIRuntime.getInstance().queueTooltip(Tooltip.create(new Component[]{Component.m_237110_((String)"text.rei.time_button.tooltip.entry", (Object[])new Object[]{this.text})}));
            }
            graphics.m_280056_(this.font, this.text, this.x + 2, this.y + 2, this.selected ? 0xFFFFFF : 0x888888, false);
        }

        public boolean m_6375_(double mouseX, double mouseY, int button) {
            if (this.rendering && mouseX >= (double)this.x && mouseX <= (double)(this.x + this.width) && mouseY >= (double)this.y && mouseY <= (double)(this.y + 12)) {
                Minecraft.m_91087_().f_91074_.f_108617_.m_246623_(StringUtils.removeStart((String)ConfigObject.getInstance().getTimeCommand().replaceAll("\\{time}", this.time.getPart().toLowerCase(Locale.ROOT)), (String)"/"));
                this.minecraft.m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_263171_((Holder)SoundEvents.f_12490_, (float)1.0f));
                this.closeMenu();
                return true;
            }
            return super.m_6375_(mouseX, mouseY, button);
        }
    }

    public static enum Type implements FavoriteEntryType<TimeFavoriteEntry>
    {
        INSTANCE;


        @Override
        public DataResult<TimeFavoriteEntry> read(CompoundTag object) {
            String stringValue = object.m_128461_(TimeFavoriteEntry.KEY);
            Time type = stringValue.equals("NOT_SET") ? null : Time.valueOf(stringValue);
            return DataResult.success((Object)new TimeFavoriteEntry(type), (Lifecycle)Lifecycle.stable());
        }

        @Override
        public DataResult<TimeFavoriteEntry> fromArgs(Object ... args) {
            if (args.length == 0) {
                return DataResult.error(() -> "Cannot create GameModeFavoriteEntry from empty args!");
            }
            Object object = args[0];
            if (!(object instanceof Time)) {
                return DataResult.error(() -> "Creation of GameModeFavoriteEntry from args expected Time as the first argument!");
            }
            Time type = (Time)((Object)object);
            return DataResult.success((Object)new TimeFavoriteEntry(type), (Lifecycle)Lifecycle.stable());
        }

        @Override
        public CompoundTag save(TimeFavoriteEntry entry, CompoundTag tag) {
            tag.m_128359_(TimeFavoriteEntry.KEY, entry.time == null ? "NOT_SET" : entry.time.name());
            return tag;
        }
    }
}

