/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.plugin.common.displays;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import me.shedaniel.rei.api.common.category.CategoryIdentifier;
import me.shedaniel.rei.api.common.display.Display;
import me.shedaniel.rei.api.common.display.DisplaySerializer;
import me.shedaniel.rei.api.common.entry.EntryIngredient;
import me.shedaniel.rei.api.common.entry.EntryStack;
import me.shedaniel.rei.plugin.common.BuiltinPlugin;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;

public class DefaultInformationDisplay
implements Display {
    private EntryIngredient entryStacks;
    private List<Component> texts;
    private Component name;

    protected DefaultInformationDisplay(EntryIngredient entryStacks, Component name) {
        this.entryStacks = entryStacks;
        this.name = name;
        this.texts = Lists.newArrayList();
    }

    public static DefaultInformationDisplay createFromEntries(EntryIngredient entryStacks, Component name) {
        return new DefaultInformationDisplay(entryStacks, name);
    }

    public static DefaultInformationDisplay createFromEntry(EntryStack<?> entryStack, Component name) {
        return DefaultInformationDisplay.createFromEntries(EntryIngredient.of(entryStack), name);
    }

    @Override
    public List<EntryIngredient> getInputEntries() {
        return Collections.singletonList(this.entryStacks);
    }

    @Override
    public List<EntryIngredient> getOutputEntries() {
        return Collections.singletonList(this.entryStacks);
    }

    public DefaultInformationDisplay line(Component line) {
        this.texts.add(line);
        return this;
    }

    public DefaultInformationDisplay lines(Component ... lines) {
        this.texts.addAll(Arrays.asList(lines));
        return this;
    }

    public DefaultInformationDisplay lines(Collection<Component> lines) {
        this.texts.addAll(lines);
        return this;
    }

    public EntryIngredient getEntryStacks() {
        return this.entryStacks;
    }

    public Component getName() {
        return this.name;
    }

    public List<Component> getTexts() {
        return this.texts;
    }

    @Override
    public CategoryIdentifier<?> getCategoryIdentifier() {
        return BuiltinPlugin.INFO;
    }

    public static DisplaySerializer<DefaultInformationDisplay> serializer() {
        return new DisplaySerializer<DefaultInformationDisplay>(){

            @Override
            public CompoundTag save(CompoundTag tag, DefaultInformationDisplay display) {
                tag.m_128365_("stacks", (Tag)display.getEntryStacks().saveIngredient());
                tag.m_128359_("name", Component.Serializer.m_130703_((Component)display.getName()));
                ListTag descriptions = new ListTag();
                for (Component text : display.getTexts()) {
                    descriptions.add((Object)StringTag.m_129297_((String)Component.Serializer.m_130703_((Component)text)));
                }
                tag.m_128365_("descriptions", (Tag)descriptions);
                return tag;
            }

            @Override
            public DefaultInformationDisplay read(CompoundTag tag) {
                EntryIngredient stacks = EntryIngredient.read(tag.m_128437_("stacks", 10));
                MutableComponent name = Component.Serializer.m_130701_((String)tag.m_128461_("name"));
                ArrayList<Component> descriptions = new ArrayList<Component>();
                for (Tag descriptionTag : tag.m_128437_("descriptions", 8)) {
                    descriptions.add((Component)Component.Serializer.m_130701_((String)descriptionTag.m_7916_()));
                }
                return new DefaultInformationDisplay(stacks, (Component)name).lines(descriptions);
            }
        };
    }
}

