/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.plugin.common.displays.anvil;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.OptionalInt;
import me.shedaniel.rei.api.common.category.CategoryIdentifier;
import me.shedaniel.rei.api.common.display.basic.BasicDisplay;
import me.shedaniel.rei.api.common.entry.EntryIngredient;
import me.shedaniel.rei.api.common.util.EntryIngredients;
import me.shedaniel.rei.plugin.common.BuiltinPlugin;
import me.shedaniel.rei.plugin.common.displays.anvil.AnvilRecipe;
import net.minecraft.client.Minecraft;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AnvilMenu;
import net.minecraft.world.item.ItemStack;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.ApiStatus;

public class DefaultAnvilDisplay
extends BasicDisplay {
    private final OptionalInt cost;

    public DefaultAnvilDisplay(AnvilRecipe recipe) {
        this(Arrays.asList(EntryIngredients.ofItemStacks(recipe.getLeftInput()), EntryIngredients.ofItemStacks(recipe.getRightInputs())), Collections.singletonList(EntryIngredients.ofItemStacks(recipe.getOutputs())), Optional.ofNullable(recipe.getId()), recipe.getCost());
    }

    public DefaultAnvilDisplay(List<EntryIngredient> inputs, List<EntryIngredient> outputs, Optional<ResourceLocation> location) {
        this(inputs, outputs, location, OptionalInt.empty());
    }

    public DefaultAnvilDisplay(List<EntryIngredient> inputs, List<EntryIngredient> outputs, Optional<ResourceLocation> location, CompoundTag tag) {
        this(inputs, outputs, location, tag.m_128441_("Cost") ? OptionalInt.of(tag.m_128451_("Cost")) : OptionalInt.empty());
    }

    public DefaultAnvilDisplay(List<EntryIngredient> inputs, List<EntryIngredient> outputs, Optional<ResourceLocation> location, OptionalInt cost) {
        super(inputs, outputs, location);
        this.cost = cost;
    }

    @Override
    public CategoryIdentifier<?> getCategoryIdentifier() {
        return BuiltinPlugin.ANVIL;
    }

    public OptionalInt getCost() {
        return this.cost;
    }

    public static BasicDisplay.Serializer<DefaultAnvilDisplay> serializer() {
        return BasicDisplay.Serializer.of(DefaultAnvilDisplay::new, (display, tag) -> {
            if (display.getCost().isPresent()) {
                tag.m_128405_("Cost", display.getCost().getAsInt());
            }
        });
    }

    @ApiStatus.Experimental
    @ApiStatus.Internal
    public static Optional<Pair<ItemStack, Integer>> calculateOutput(ItemStack left, ItemStack right) {
        try {
            if (Minecraft.m_91087_().f_91074_ == null) {
                return Optional.empty();
            }
            AnvilMenu menu = new AnvilMenu(0, new Inventory((Player)Minecraft.m_91087_().f_91074_));
            menu.m_182406_(0, menu.m_182425_(), left);
            menu.m_182406_(1, menu.m_182425_(), right);
            ItemStack output = menu.m_38853_(2).m_7993_().m_41777_();
            if (!output.m_41619_()) {
                return Optional.of(Pair.of((Object)output, (Object)menu.m_39028_()));
            }
            return Optional.empty();
        }
        catch (Throwable ignored) {
            return Optional.empty();
        }
    }
}

