/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.plugin.common.runtime;

import dev.architectury.event.CompoundEventResult;
import dev.architectury.fluid.FluidStack;
import java.util.Optional;
import java.util.stream.Stream;
import me.shedaniel.rei.api.common.entry.EntryStack;
import me.shedaniel.rei.api.common.entry.type.EntryTypeRegistry;
import me.shedaniel.rei.api.common.entry.type.VanillaEntryTypes;
import me.shedaniel.rei.api.common.fluid.FluidSupportProvider;
import me.shedaniel.rei.api.common.plugins.REIServerPlugin;
import me.shedaniel.rei.api.common.transfer.info.stack.PlayerInventorySlotAccessor;
import me.shedaniel.rei.api.common.transfer.info.stack.SlotAccessor;
import me.shedaniel.rei.api.common.transfer.info.stack.SlotAccessorRegistry;
import me.shedaniel.rei.api.common.transfer.info.stack.VanillaSlotAccessor;
import me.shedaniel.rei.plugin.client.entry.FluidEntryDefinition;
import me.shedaniel.rei.plugin.client.entry.ItemEntryDefinition;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public class DefaultRuntimePlugin
implements REIServerPlugin {
    public static final ResourceLocation PLUGIN = new ResourceLocation("roughlyenoughitems", "default_runtime_plugin");

    @Override
    public void registerEntryTypes(EntryTypeRegistry registry) {
        registry.register(VanillaEntryTypes.ITEM, new ItemEntryDefinition());
        registry.register(VanillaEntryTypes.FLUID, new FluidEntryDefinition());
        registry.registerBridge(VanillaEntryTypes.ITEM, VanillaEntryTypes.FLUID, input -> {
            Optional<Stream<EntryStack<FluidStack>>> stream = FluidSupportProvider.getInstance().itemToFluids(input);
            if (!stream.isPresent()) {
                return CompoundEventResult.pass();
            }
            return CompoundEventResult.interruptTrue(stream.get());
        });
    }

    @Override
    public void registerSlotAccessors(SlotAccessorRegistry registry) {
        registry.register(new ResourceLocation("roughlyenoughitems", "vanilla"), slotAccessor -> slotAccessor instanceof VanillaSlotAccessor, new SlotAccessorRegistry.Serializer(){

            @Override
            public SlotAccessor read(AbstractContainerMenu menu, Player player, CompoundTag tag) {
                int slot = tag.m_128451_("Slot");
                return new VanillaSlotAccessor((Slot)menu.f_38839_.get(slot));
            }

            @Override
            @Nullable
            public CompoundTag save(AbstractContainerMenu menu, Player player, SlotAccessor accessor) {
                if (!(accessor instanceof VanillaSlotAccessor)) {
                    throw new IllegalArgumentException("Cannot save non-vanilla slot accessor!");
                }
                CompoundTag tag = new CompoundTag();
                tag.m_128405_("Slot", ((VanillaSlotAccessor)accessor).getSlot().f_40219_);
                return tag;
            }
        });
        registry.register(new ResourceLocation("roughlyenoughitems", "player"), slotAccessor -> slotAccessor instanceof PlayerInventorySlotAccessor, new SlotAccessorRegistry.Serializer(){

            @Override
            public SlotAccessor read(AbstractContainerMenu menu, Player player, CompoundTag tag) {
                int slot = tag.m_128451_("Slot");
                return new PlayerInventorySlotAccessor(player, slot);
            }

            @Override
            @Nullable
            public CompoundTag save(AbstractContainerMenu menu, Player player, SlotAccessor accessor) {
                if (!(accessor instanceof PlayerInventorySlotAccessor)) {
                    throw new IllegalArgumentException("Cannot save non-player slot accessor!");
                }
                CompoundTag tag = new CompoundTag();
                tag.m_128405_("Slot", ((PlayerInventorySlotAccessor)accessor).getIndex());
                return tag;
            }
        });
    }
}

