/*
 * Decompiled with CFR 0.152.
 */
package com.teamresourceful.resourcefullib.forge;

import com.electronwill.nightconfig.core.UnmodifiableConfig;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.teamresourceful.resourcefullib.common.comptibility.CompatabilityManager;
import com.teamresourceful.resourcefullib.common.lib.Constants;
import java.util.List;
import java.util.Map;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.loading.FMLLoader;
import net.minecraftforge.forgespi.language.IModInfo;

public class ForgeCompatibilityHandler {
    private static final String KEY = "resourcefullib:compatibility";

    public static void load() {
        for (IModInfo mod : ModList.get().getMods()) {
            if (!mod.getModProperties().containsKey(KEY)) continue;
            try {
                ForgeCompatibilityHandler.initMod(mod, mod.getModProperties());
            }
            catch (Exception e) {
                Constants.LOGGER.error("Resourceful Lib failed to load compatibility for mod: " + mod.getDisplayName());
                e.printStackTrace();
            }
        }
    }

    private static void initMod(IModInfo mod, Map<String, Object> metadata) {
        JsonArray array = ForgeCompatibilityHandler.toJsonElement(metadata.get(KEY)).getAsJsonArray();
        CompatabilityManager.check(mod.getModId(), FMLLoader.getDist().isClient(), array);
    }

    private static JsonElement toJsonElement(Object o) {
        if (o instanceof String) {
            String string = (String)o;
            return new JsonPrimitive(string);
        }
        if (o instanceof Number) {
            Number number = (Number)o;
            return new JsonPrimitive(number);
        }
        if (o instanceof Boolean) {
            Boolean bool = (Boolean)o;
            return new JsonPrimitive(bool);
        }
        if (o instanceof List) {
            List list = (List)o;
            JsonArray array = new JsonArray();
            for (Object entry : list) {
                array.add(ForgeCompatibilityHandler.toJsonElement(entry));
            }
            return array;
        }
        if (o instanceof UnmodifiableConfig) {
            UnmodifiableConfig config = (UnmodifiableConfig)o;
            Map map = config.valueMap();
            JsonObject object = new JsonObject();
            for (Map.Entry entry : map.entrySet()) {
                object.add((String)entry.getKey(), ForgeCompatibilityHandler.toJsonElement(entry.getValue()));
            }
            return object;
        }
        return JsonNull.INSTANCE;
    }
}

