/*
 * Decompiled with CFR 0.152.
 */
package net.player005.recipe_modification.api;

import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeType;
import net.player005.recipe_modification.api.RecipeModification;

public interface RecipeFilter {
    public static final RecipeFilter ALWAYS_APPLY = (recipe, registryAccess) -> true;

    public boolean shouldApply(Recipe<?> var1, RegistryAccess var2);

    public static RecipeFilter acceptsIngredient(ItemStack item) {
        return (recipe, registryAccess) -> {
            for (Ingredient ingredient : recipe.m_7527_()) {
                if (!ingredient.test(item)) continue;
                return true;
            }
            return false;
        };
    }

    public static RecipeFilter resultItemIs(Item item) {
        return (recipe, registryAccess) -> RecipeModification.tryGetResult(recipe, registryAccess).m_150930_(item);
    }

    public static RecipeFilter resultItemIs(TagKey<Item> itemTag) {
        return (recipe, registryAccess) -> recipe.m_8043_(registryAccess).m_204117_(itemTag);
    }

    public static RecipeFilter resultItemMatches(ItemPredicate predicate) {
        return (recipe, registryAccess) -> predicate.m_45049_(recipe.m_8043_(registryAccess));
    }

    public static RecipeFilter idEquals(ResourceLocation id) {
        return (recipe, registryAccess) -> recipe.m_6423_().equals((Object)id);
    }

    public static RecipeFilter namespaceEquals(String group) {
        return (recipe, registryAccess) -> recipe.m_6423_().m_135827_().equals(group);
    }

    public static RecipeFilter isType(RecipeType<?> recipeType) {
        return (recipe, registryAccess) -> recipe.m_6671_().equals(recipeType);
    }

    public static RecipeFilter and(RecipeFilter ... filters) {
        return (recipe, registryAccess) -> {
            for (RecipeFilter filter : filters) {
                if (filter.shouldApply(recipe, registryAccess)) continue;
                return false;
            }
            return true;
        };
    }

    public static RecipeFilter or(RecipeFilter ... filters) {
        return (recipe, registryAccess) -> {
            for (RecipeFilter filter : filters) {
                if (!filter.shouldApply(recipe, registryAccess)) continue;
                return true;
            }
            return false;
        };
    }

    public static RecipeFilter not(RecipeFilter filter) {
        return (recipe, registryAccess) -> !filter.shouldApply(recipe, registryAccess);
    }
}

