/*
 * Decompiled with CFR 0.152.
 */
package com.copycatsplus.copycats.content.copycat.layer;

import com.copycatsplus.copycats.CCShapes;
import com.copycatsplus.copycats.Copycats;
import com.copycatsplus.copycats.foundation.copycat.CCWaterloggedCopycatBlock;
import com.copycatsplus.copycats.foundation.copycat.ICopycatBlock;
import com.copycatsplus.copycats.foundation.copycat.IStateType;
import com.copycatsplus.copycats.utility.BlockUtils;
import com.simibubi.create.api.schematic.requirement.SpecialBlockItemRequirement;
import com.simibubi.create.content.contraptions.StructureTransform;
import com.simibubi.create.content.equipment.wrench.IWrenchable;
import com.simibubi.create.content.schematics.requirement.ItemRequirement;
import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class CopycatLayerBlock
extends CCWaterloggedCopycatBlock
implements SpecialBlockItemRequirement,
IStateType {
    public static final DirectionProperty FACING = BlockStateProperties.f_61372_;
    public static final IntegerProperty LAYERS = BlockStateProperties.f_61417_;

    public CopycatLayerBlock(BlockBehaviour.Properties pProperties) {
        super(pProperties);
        this.m_49959_((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)Direction.UP));
    }

    @Override
    public BlockState m_5573_(BlockPlaceContext context) {
        BlockState stateForPlacement = super.m_5573_(context);
        if (stateForPlacement == null) {
            return null;
        }
        BlockPos blockPos = context.m_8083_();
        BlockState state = context.m_43725_().m_8055_(blockPos);
        if (state.m_60713_((Block)this)) {
            if ((Integer)state.m_61143_((Property)LAYERS) < 8) {
                return (BlockState)state.m_61122_((Property)LAYERS);
            }
            Copycats.LOGGER.warn("Can't figure out where to place a layer! Please file an issue if you see this.");
            return state;
        }
        return (BlockState)stateForPlacement.m_61124_((Property)FACING, (Comparable)context.m_7820_().m_122424_());
    }

    public boolean m_6864_(@NotNull BlockState pState, BlockPlaceContext pUseContext) {
        ItemStack itemstack = pUseContext.m_43722_();
        if (!itemstack.m_150930_(this.m_5456_())) {
            return false;
        }
        if ((Integer)pState.m_61143_((Property)LAYERS) == 8) {
            return false;
        }
        return pState.m_61143_((Property)FACING) == pUseContext.m_43719_();
    }

    @Override
    public InteractionResult onSneakWrenched(BlockState state, UseOnContext context) {
        if ((Integer)state.m_61143_((Property)LAYERS) <= 1) {
            return super.onSneakWrenched(state, context);
        }
        Level world = context.m_43725_();
        BlockPos pos = context.m_8083_();
        Player player = context.m_43723_();
        if (world instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)world;
            if (player != null && !player.m_7500_()) {
                List drops = Block.m_49874_((BlockState)((BlockState)state.m_61124_((Property)LAYERS, (Comparable)Integer.valueOf(1))), (ServerLevel)serverLevel, (BlockPos)pos, (BlockEntity)world.m_7702_(pos), (Entity)player, (ItemStack)context.m_43722_());
                for (ItemStack drop : drops) {
                    player.m_150109_().m_150079_(drop);
                }
            }
            BlockPos up = pos.m_121945_(Direction.UP);
            world.m_46597_(pos, ((BlockState)state.m_61124_((Property)LAYERS, (Comparable)Integer.valueOf((Integer)state.m_61143_((Property)LAYERS) - 1))).m_60728_(Direction.UP, world.m_8055_(up), (LevelAccessor)world, pos, up));
            IWrenchable.playRemoveSound((Level)world, (BlockPos)pos);
        }
        return InteractionResult.SUCCESS;
    }

    public ItemRequirement getRequiredItems(BlockState state, BlockEntity blockEntity) {
        return ICopycatBlock.getRequiredItemsForLayer(state, LAYERS);
    }

    @Override
    public BlockState transform(BlockState state, StructureTransform transform) {
        return (BlockState)state.m_61124_((Property)FACING, (Comparable)BlockUtils.transformFacing(transform, (Direction)state.m_61143_((Property)FACING)));
    }

    public boolean m_7357_(@NotNull BlockState pState, @NotNull BlockGetter pLevel, @NotNull BlockPos pPos, @NotNull PathComputationType pType) {
        return switch (pType) {
            case PathComputationType.LAND -> {
                if ((Integer)pState.m_61143_((Property)LAYERS) < 5 && ((Direction)pState.m_61143_((Property)FACING)).equals((Object)Direction.UP)) {
                    yield true;
                }
                yield false;
            }
            default -> false;
        };
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> pBuilder) {
        super.m_7926_((StateDefinition.Builder<Block, BlockState>)pBuilder.m_61104_(new Property[]{FACING}).m_61104_(new Property[]{LAYERS}));
    }

    @NotNull
    public VoxelShape m_5940_(BlockState pState, @NotNull BlockGetter pLevel, @NotNull BlockPos pPos, @NotNull CollisionContext pContext) {
        return CCShapes.LAYER.get(pState.m_61143_((Property)FACING)).get(pState.m_61143_((Property)LAYERS)).toShape();
    }

    public boolean supportsExternalFaceHiding(BlockState state) {
        return true;
    }

    @Override
    public boolean hidesNeighborFace(BlockGetter level, BlockPos pos, BlockState state, BlockState neighborState, Direction dir) {
        return ICopycatBlock.hidesNeighborFace(level, pos, state, neighborState, dir);
    }

    public boolean m_7923_(BlockState state) {
        return true;
    }

    public float m_7749_(BlockState state, BlockGetter level, BlockPos pos) {
        return (Integer)state.m_61143_((Property)LAYERS) == 8 ? 0.2f : 1.0f;
    }
}

