/*
 * Decompiled with CFR 0.152.
 */
package com.blackgear.vanillabackport.common.api.variant;

import com.blackgear.vanillabackport.common.api.variant.SpawnCondition;
import com.blackgear.vanillabackport.common.api.variant.SpawnContext;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryCodecs;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureStart;

public record StructureCheck(HolderSet<Structure> requiredStructures) implements SpawnCondition
{
    public static final Codec<StructureCheck> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)RegistryCodecs.m_206277_((ResourceKey)Registries.f_256944_).fieldOf("structures").forGetter(StructureCheck::requiredStructures)).apply((Applicative)instance, StructureCheck::new));

    @Override
    public boolean test(SpawnContext context) {
        return this.getStructureWithPieceAt(context, arg_0 -> this.requiredStructures.m_203333_(arg_0)).m_73603_();
    }

    private StructureStart getStructureWithPieceAt(SpawnContext context, Predicate<Holder<Structure>> predicate) {
        StructureManager manager = context.level().m_6018_().m_215010_();
        BlockPos pos = context.pos();
        Registry registry = manager.m_220521_().m_175515_(Registries.f_256944_);
        List starts = manager.m_220477_(new ChunkPos(pos), structure -> registry.m_203300_(registry.m_7447_(structure)).map(predicate::test).orElse(false));
        for (StructureStart start : starts) {
            if (!manager.m_220497_(pos, start)) continue;
            return start;
        }
        return StructureStart.f_73561_;
    }

    @Override
    public Codec<? extends SpawnCondition> codec() {
        return CODEC;
    }
}

