/*
 * Decompiled with CFR 0.152.
 */
package com.blackgear.vanillabackport.common.worldgen.generation;

import com.blackgear.platform.common.worldgen.modifier.BiomeContext;
import com.blackgear.platform.common.worldgen.modifier.BiomeWriter;
import com.blackgear.vanillabackport.common.registries.ModBiomes;
import com.blackgear.vanillabackport.common.worldgen.generation.FeatureManager;
import com.blackgear.vanillabackport.common.worldgen.placements.SpringToLifePlacements;
import com.blackgear.vanillabackport.core.VanillaBackport;
import com.blackgear.vanillabackport.core.data.tags.ModBiomeTags;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.level.biome.MobSpawnSettings;

public class SpringToLifeFeatureManager
extends FeatureManager {
    public SpringToLifeFeatureManager(BiomeContext context, BiomeWriter writer) {
        super(context, writer);
    }

    @Override
    public void bootstrap() {
        this.addIf((Boolean)VanillaBackport.COMMON_CONFIG.hasCamelSpawns.get(), (BiomeContext context, BiomeWriter writer) -> this.getOrCreateBiomeBuilder(ModBiomeTags.SPAWNS_CAMELS).add(() -> writer.addSpawn(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData(EntityType.f_243976_, 1, 1, 1))));
        this.addIf((Boolean)VanillaBackport.COMMON_CONFIG.hasBushes.get(), (BiomeContext context, BiomeWriter writer) -> this.getOrCreateBiomeBuilder(ModBiomeTags.SPAWNS_BUSHES).add(() -> this.addVegetation(SpringToLifePlacements.PATCH_BUSH)));
        this.addIf((Boolean)VanillaBackport.COMMON_CONFIG.hasFireflyBushes.get(), (BiomeContext context, BiomeWriter writer) -> {
            this.getOrCreateBiomeBuilder(ModBiomeTags.SPAWNS_FIREFLY_BUSHES).add(() -> this.addVegetation(SpringToLifePlacements.PATCH_FIREFLY_BUSH_NEAR_WATER));
            this.getOrCreateBiomeBuilder(context.is(ModBiomeTags.SPAWNS_FIREFLY_BUSHES_SWAMP) && !context.is(ModBiomeTags.SPAWNS_FIREFLY_BUSHES)).add(() -> this.addVegetation(SpringToLifePlacements.PATCH_FIREFLY_BUSH_SWAMP)).add(() -> this.addVegetation(SpringToLifePlacements.PATCH_FIREFLY_BUSH_NEAR_WATER_SWAMP));
        });
        this.addIf((Boolean)VanillaBackport.COMMON_CONFIG.hasWildflowers.get(), (BiomeContext context, BiomeWriter writer) -> {
            this.getOrCreateBiomeBuilder(ModBiomeTags.SPAWNS_NOISE_BASED_WILDFLOWERS).add(() -> this.addVegetation(SpringToLifePlacements.WILDFLOWERS_MEADOW));
            this.getOrCreateBiomeBuilder(ModBiomeTags.SPAWNS_WILDFLOWERS).add(() -> this.addVegetation(SpringToLifePlacements.WILDFLOWERS_BIRCH_FOREST));
        });
        this.addIf((Boolean)VanillaBackport.COMMON_CONFIG.hasDryGrass.get(), (BiomeContext context, BiomeWriter writer) -> {
            this.getOrCreateBiomeBuilder(ModBiomeTags.SPAWNS_DRY_GRASS).add(() -> this.addVegetation(SpringToLifePlacements.PATCH_DRY_GRASS_DESERT));
            this.getOrCreateBiomeBuilder(ModBiomeTags.SPAWNS_DRY_GRASS_RARELY).add(() -> this.addVegetation(SpringToLifePlacements.PATCH_DRY_GRASS_BADLANDS));
        });
        this.addIf((Boolean)VanillaBackport.COMMON_CONFIG.hasFallenTrees.get(), (BiomeContext context, BiomeWriter writer) -> {
            this.getOrCreateBiomeBuilder(ModBiomeTags.SPAWNS_FALLEN_OAK_TREES).add(() -> this.addVegetation(SpringToLifePlacements.PLACED_FALLEN_OAK_TREE));
            this.getOrCreateBiomeBuilder((BiomeContext ctx) -> ctx.is(ModBiomeTags.SPAWNS_FALLEN_BIRCH_TREES_RARELY) && !ctx.is(ModBiomes.PALE_GARDEN)).add(() -> this.addVegetation(SpringToLifePlacements.PLACED_RARE_FALLEN_BIRCH_TREE));
            this.getOrCreateBiomeBuilder(ModBiomeTags.SPAWNS_FALLEN_BIRCH_TREES).add(() -> this.addVegetation(SpringToLifePlacements.PLACED_FALLEN_BIRCH_TREE));
            this.getOrCreateBiomeBuilder(ModBiomeTags.SPAWNS_FALLEN_SUPER_BIRCH_TREES).add(() -> this.addVegetation(SpringToLifePlacements.PLACED_FALLEN_SUPER_BIRCH_TREE));
            this.getOrCreateBiomeBuilder(ModBiomeTags.SPAWNS_FALLEN_JUNGLE_TREES).add(() -> this.addVegetation(SpringToLifePlacements.PLACED_FALLEN_JUNGLE_TREE));
            this.getOrCreateBiomeBuilder(ModBiomeTags.SPAWNS_FALLEN_SPRUCE_TREES).add(() -> this.addVegetation(SpringToLifePlacements.PLACED_FALLEN_SPRUCE_TREE));
            this.getOrCreateBiomeBuilder(ModBiomeTags.SPAWNS_FALLEN_SPRUCE_TREES_RARELY).add(() -> this.addVegetation(SpringToLifePlacements.PLACED_RARE_FALLEN_SPRUCE_TREE));
        });
        this.addIf((Boolean)VanillaBackport.COMMON_CONFIG.hasLeafLitter.get(), (BiomeContext context, BiomeWriter writer) -> {
            this.getOrCreateBiomeBuilder(ModBiomeTags.SPAWNS_LEAF_LITTER_PATCHES).add(() -> this.addVegetation(SpringToLifePlacements.PATCH_LEAF_LITTER));
            this.getOrCreateBiomeBuilder(ModBiomeTags.SPAWNS_LEAF_LITTER).add(() -> this.addVegetation(SpringToLifePlacements.LEAF_LITTER));
        });
    }
}

