/*
 * Decompiled with CFR 0.152.
 */
package com.blackgear.vanillabackport.core.mixin.client;

import com.blackgear.vanillabackport.common.api.bundle.BundleFeatures;
import com.blackgear.vanillabackport.common.api.bundle.BundleSelectionTooltip;
import com.blackgear.vanillabackport.core.VanillaBackport;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientBundleTooltip;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.inventory.tooltip.BundleTooltip;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ClientBundleTooltip.class})
public class ClientBundleTooltipMixin
implements ClientTooltipComponent {
    @Unique
    private static final ResourceLocation BUNDLE_PROGRESS_BAR_TEXTURE = VanillaBackport.vanilla("textures/container/bundle/bundle_progressbar.png");
    @Unique
    private static final ResourceLocation BUNDLE_SLOT_HIGHLIGHT_BACK_TEXTURE = VanillaBackport.vanilla("textures/container/bundle/slot_highlight_back.png");
    @Unique
    private static final ResourceLocation BUNDLE_SLOT_HIGHLIGHT_FRONT_TEXTURE = VanillaBackport.vanilla("textures/container/bundle/slot_highlight_front.png");
    @Unique
    private static final ResourceLocation BUNDLE_SLOT_BACKGROUND_TEXTURE = VanillaBackport.vanilla("textures/container/bundle/slot_background.png");
    @Unique
    private static final Component BUNDLE_EMPTY_DESCRIPTION = Component.m_237115_((String)"item.minecraft.bundle.empty.description");
    @Unique
    private static final Component BUNDLE_FULL = Component.m_237115_((String)"item.minecraft.bundle.full");
    @Unique
    private static final Component BUNDLE_EMPTY = Component.m_237115_((String)"item.minecraft.bundle.empty");
    @Shadow
    @Final
    private NonNullList<ItemStack> f_169869_;
    @Shadow
    @Final
    private int f_169870_;
    @Unique
    private int selectedItem;

    @Inject(method={"<init>"}, at={@At(value="TAIL")})
    private void vb$init(BundleTooltip tooltip, CallbackInfo ci) {
        int n;
        if (tooltip instanceof BundleSelectionTooltip) {
            BundleSelectionTooltip selection = (BundleSelectionTooltip)tooltip;
            n = selection.getSelectedItem();
        } else {
            n = -1;
        }
        this.selectedItem = n;
    }

    @Unique
    private int getSelectedItem() {
        return this.selectedItem;
    }

    @Unique
    private boolean hasSelectedItem() {
        return this.selectedItem != -1;
    }

    public int m_142103_() {
        return this.f_169869_.isEmpty() ? 39 : this.backgroundHeight();
    }

    public int m_142069_(Font font) {
        return 96;
    }

    @Unique
    private int backgroundHeight() {
        return this.itemGridHeight() + 13 + 8;
    }

    @Unique
    private int itemGridHeight() {
        return this.gridSizeY() * 24;
    }

    @Unique
    private int getContentXOffset(int width) {
        return (width - 96) / 2;
    }

    @Unique
    private int gridSizeY() {
        return Mth.m_184652_((int)this.slotCount(), (int)4);
    }

    @Unique
    private int slotCount() {
        return Math.min(12, this.f_169869_.size());
    }

    @Inject(method={"renderImage"}, at={@At(value="HEAD")}, cancellable=true)
    private void vb$onRenderImage(Font font, int x, int y, GuiGraphics graphics, CallbackInfo ci) {
        if (!BundleFeatures.onBundleUpdate()) {
            return;
        }
        if (this.f_169869_.isEmpty()) {
            this.renderEmptyBundleTooltip(font, x, y, this.m_142069_(font), graphics);
        } else {
            this.renderBundleWithItemsTooltip(font, x, y, this.m_142069_(font), graphics);
        }
        ci.cancel();
    }

    @Unique
    private void renderEmptyBundleTooltip(Font font, int x, int y, int width, GuiGraphics graphics) {
        this.drawEmptyBundleDescriptionText(x + this.getContentXOffset(width), y, font, graphics);
        this.drawProgressBar(x + this.getContentXOffset(width), y + this.getEmptyBundleDescriptionTextHeight(font) + 4, font, graphics);
    }

    @Unique
    private void renderBundleWithItemsTooltip(Font font, int x, int y, int width, GuiGraphics graphics) {
        boolean maxDisplay = this.f_169869_.size() > 12;
        List<ItemStack> stacks = this.getShownItems(BundleFeatures.getItemsToShow(this.f_169869_));
        int xOffset = x + this.getContentXOffset(width) + 96;
        int yOffset = y + this.gridSizeY() * 24;
        int index = 1;
        for (int row = 1; row <= this.gridSizeY(); ++row) {
            for (int column = 1; column <= 4; ++column) {
                int slotX = xOffset - column * 24;
                int slotY = yOffset - row * 24;
                if (this.shouldRenderSurplusText(maxDisplay, column, row)) {
                    this.renderCount(slotX, slotY, this.getAmountOfHiddenItems(stacks), font, graphics);
                    continue;
                }
                if (!this.shouldRenderItemSlot(stacks, index)) continue;
                this.renderSlot(index, slotX, slotY, stacks, index, font, graphics);
                ++index;
            }
        }
        this.drawSelectedItemTooltip(font, graphics, x, y, width);
        this.drawProgressBar(x + this.getContentXOffset(width), y + this.itemGridHeight() + 4, font, graphics);
    }

    @Unique
    private List<ItemStack> getShownItems(int max) {
        int size = Math.min(this.f_169869_.size(), max);
        return this.f_169869_.stream().toList().subList(0, size);
    }

    @Unique
    private boolean shouldRenderSurplusText(boolean maxDisplay, int column, int row) {
        return maxDisplay && column * row == 1;
    }

    @Unique
    private boolean shouldRenderItemSlot(List<ItemStack> items, int itemIndex) {
        return items.size() >= itemIndex;
    }

    @Unique
    private int getAmountOfHiddenItems(List<ItemStack> items) {
        return this.f_169869_.stream().skip(items.size()).mapToInt(ItemStack::m_41613_).sum();
    }

    @Unique
    private void renderSlot(int index, int x, int y, List<ItemStack> stacks, int seed, Font font, GuiGraphics graphics) {
        int itemIndex = stacks.size() - index;
        boolean hasSelectedItem = itemIndex == this.getSelectedItem();
        ItemStack stack = stacks.get(itemIndex);
        if (hasSelectedItem) {
            RenderSystem.enableBlend();
            RenderSystem.defaultBlendFunc();
            graphics.m_280398_(BUNDLE_SLOT_HIGHLIGHT_BACK_TEXTURE, x, y, 0, 0.0f, 0.0f, 24, 24, 24, 24);
            RenderSystem.disableBlend();
        } else {
            graphics.m_280398_(BUNDLE_SLOT_BACKGROUND_TEXTURE, x, y, 0, 0.0f, 0.0f, 24, 24, 24, 24);
        }
        graphics.m_280256_(stack, x + 4, y + 4, seed);
        graphics.m_280370_(font, stack, x + 4, y + 4);
        if (hasSelectedItem) {
            RenderSystem.enableBlend();
            RenderSystem.defaultBlendFunc();
            graphics.m_280398_(BUNDLE_SLOT_HIGHLIGHT_FRONT_TEXTURE, x, y, 0, 0.0f, 0.0f, 24, 24, 24, 24);
            RenderSystem.disableBlend();
        }
    }

    @Unique
    private void renderCount(int x, int y, int value, Font font, GuiGraphics graphics) {
        graphics.m_280137_(font, "+" + value, x + 12, y + 10, -1);
    }

    @Unique
    private void drawSelectedItemTooltip(Font font, GuiGraphics graphics, int x, int y, int width) {
        if (this.hasSelectedItem()) {
            ItemStack stack = (ItemStack)this.f_169869_.get(this.getSelectedItem());
            MutableComponent component = Component.m_237119_().m_7220_(stack.m_41786_()).m_130940_(stack.m_41791_().f_43022_);
            if (stack.m_41788_()) {
                component.m_130940_(ChatFormatting.ITALIC);
            }
            int textWidth = font.m_92724_(component.m_7532_());
            int xOffset = x + width / 2 - 12;
            graphics.m_280557_(font, (Component)component, xOffset - textWidth / 2, y - 15);
        }
    }

    @Unique
    private void drawProgressBar(int x, int y, Font textRenderer, GuiGraphics graphics) {
        boolean isFull;
        int progress = this.getProgressBarFill();
        boolean bl = isFull = this.f_169870_ >= 64;
        if (progress > 0) {
            graphics.m_280260_(BUNDLE_PROGRESS_BAR_TEXTURE, x + 1, y, progress > 1 ? progress : 2, 13, 2, 6, 6, isFull ? 6 : 0, 12);
        }
        graphics.m_280260_(BUNDLE_PROGRESS_BAR_TEXTURE, x, y, 96, 13, 2, 12, 12, 0, 0);
        Component fillText = this.getProgressBarFillText();
        if (fillText != null) {
            graphics.m_280653_(textRenderer, fillText, x + 48, y + 3, -1);
        }
    }

    @Unique
    private void drawEmptyBundleDescriptionText(int x, int y, Font font, GuiGraphics graphics) {
        graphics.m_280554_(font, (FormattedText)BUNDLE_EMPTY_DESCRIPTION, x, y, 96, -5592406);
    }

    @Unique
    private int getEmptyBundleDescriptionTextHeight(Font font) {
        return font.m_92923_((FormattedText)BUNDLE_EMPTY_DESCRIPTION, 96).size() * 9;
    }

    @Unique
    private int getProgressBarFill() {
        return Mth.m_14045_((int)(this.f_169870_ * 94 / 64), (int)0, (int)94);
    }

    @Unique
    @Nullable
    private Component getProgressBarFillText() {
        if (this.f_169869_.isEmpty()) {
            return BUNDLE_EMPTY;
        }
        return this.f_169870_ >= 64 ? BUNDLE_FULL : null;
    }
}

