/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.beachparty.core.event;

import dev.architectury.event.EventResult;
import dev.architectury.event.events.common.EntityEvent;
import dev.architectury.event.events.common.LootEvent;
import dev.architectury.event.events.common.PlayerEvent;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.loot.LootDataManager;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.entries.LootTableReference;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;
import net.satisfy.beachparty.core.block.BeachParasolBlock;
import net.satisfy.beachparty.core.registry.ObjectRegistry;
import org.jetbrains.annotations.Nullable;

public class CommonEvents {
    public static void init() {
        LootEvent.MODIFY_LOOT_TABLE.register(CommonEvents::onModifyLootTable);
        PlayerEvent.ATTACK_ENTITY.register(CommonEvents::onPlayerAttack);
        EntityEvent.LIVING_HURT.register(CommonEvents::onLivingHurt);
    }

    public static void onModifyLootTable(@Nullable LootDataManager lootDataManager, ResourceLocation id, LootEvent.LootTableModificationContext ctx, boolean b) {
        LoottableInjector.InjectLoot(id, ctx);
    }

    private static EventResult onPlayerAttack(Player player, Level level, Entity entity, InteractionHand hand, @Nullable EntityHitResult result) {
        ItemStack itemInHand = player.m_21120_(hand);
        if (itemInHand.m_41720_() == ObjectRegistry.POOL_NOODLE.get()) {
            Vec3 knockbackDirection = new Vec3(entity.m_20185_() - player.m_20185_(), 0.6, entity.m_20189_() - player.m_20189_()).m_82541_().m_82490_(1.5);
            entity.m_5997_(knockbackDirection.f_82479_, knockbackDirection.f_82480_, knockbackDirection.f_82481_);
            level.m_6263_(null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), SoundEvents.f_12267_, SoundSource.PLAYERS, 1.0f, 1.5f);
            return EventResult.interruptTrue();
        }
        return EventResult.pass();
    }

    private static EventResult onLivingHurt(LivingEntity entity, DamageSource source, float amount) {
        if (entity.m_9236_().m_5776_()) {
            return EventResult.pass();
        }
        if (CommonEvents.isFireDamage(source) && CommonEvents.isNearBeachParasol(entity)) {
            float reducedDamage = amount * 0.96f;
            entity.m_21153_(entity.m_21223_() + (amount - reducedDamage));
            return EventResult.interruptFalse();
        }
        return EventResult.pass();
    }

    private static boolean isFireDamage(DamageSource source) {
        return source.m_276093_(DamageTypes.f_268631_) || source.m_276093_(DamageTypes.f_268468_) || source.m_276093_(DamageTypes.f_268546_);
    }

    private static boolean isNearBeachParasol(LivingEntity entity) {
        Level level = entity.m_9236_();
        BlockPos entityPos = entity.m_20183_();
        for (int x = -1; x <= 1; ++x) {
            for (int y = -1; y <= 1; ++y) {
                for (int z = -1; z <= 1; ++z) {
                    BlockPos checkPos = entityPos.m_7918_(x, y, z);
                    BlockState blockState = level.m_8055_(checkPos);
                    if (!(blockState.m_60734_() instanceof BeachParasolBlock)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public static class LoottableInjector {
        public static void InjectLoot(ResourceLocation id, LootEvent.LootTableModificationContext context) {
            String prefix = "minecraft:chests/";
            String name = id.toString();
            if (name.startsWith(prefix)) {
                String file;
                switch (file = name.substring(name.indexOf(prefix) + prefix.length())) {
                    case "desert_pyramid": 
                    case "buried_treasure": 
                    case "shipwreck_supply": 
                    case "shipwreck_treasure": 
                    case "simple_dungeon": 
                    case "underwater_ruin_big": 
                    case "underwater_ruin_small": 
                    case "woodland_mansion": {
                        context.addPool(LoottableInjector.getPool(file));
                        break;
                    }
                }
            }
        }

        public static LootPool getPool(String entryName) {
            return LootPool.m_79043_().m_79076_(LoottableInjector.getPoolEntry(entryName)).m_79082_();
        }

        private static LootPoolEntryContainer.Builder<?> getPoolEntry(String name) {
            ResourceLocation table = new ResourceLocation("beachparty", "chests/" + name);
            return LootTableReference.m_79776_((ResourceLocation)table);
        }
    }
}

