/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.beachparty.forge.client.renderer.player.layers;

import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.satisfy.beachparty.client.model.BeachHatModel;
import net.satisfy.beachparty.core.registry.ObjectRegistry;
import net.satisfy.beachparty.core.util.BeachpartyIdentifier;
import org.jetbrains.annotations.NotNull;

public class BeachHatLayer<T extends LivingEntity, M extends HumanoidModel<T>>
extends RenderLayer<T, M> {
    private final BeachHatModel<T> model = new BeachHatModel(Minecraft.m_91087_().m_167973_().m_171103_(BeachHatModel.LAYER_LOCATION));

    public BeachHatLayer(RenderLayerParent<T, M> renderLayerParent) {
        super(renderLayerParent);
    }

    public void render(@NotNull PoseStack poseStack, @NotNull MultiBufferSource multiBufferSource, int light, @NotNull T entity, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        if (!(entity instanceof Player)) {
            return;
        }
        ItemStack hatStack = entity.m_6844_(EquipmentSlot.HEAD);
        if (hatStack.m_41619_() || !BeachHatLayer.isBeachHat(hatStack)) {
            return;
        }
        this.model.m_6973_(entity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
        poseStack.m_85836_();
        ((HumanoidModel)this.m_117386_()).f_102808_.m_104299_(poseStack);
        poseStack.m_252880_(0.0f, -1.4f, 0.0f);
        BeachHatLayer.renderColoredCutoutModel(this.model, BeachHatLayer.getItemTexture(), poseStack, multiBufferSource, light, entity, 1.0f, 1.0f, 1.0f);
        poseStack.m_85849_();
    }

    private static ResourceLocation getItemTexture() {
        return new BeachpartyIdentifier("textures/models/armor/beach_hat.png");
    }

    private static boolean isBeachHat(ItemStack stack) {
        return stack.m_150930_((Item)ObjectRegistry.BEACH_HAT.get());
    }

    private static <T extends LivingEntity, M extends HumanoidModel<T>> void renderColoredCutoutModel(BeachHatModel<T> model, ResourceLocation texture, PoseStack poseStack, MultiBufferSource buffer, int light, T entity, float red, float green, float blue) {
        model.m_7695_(poseStack, buffer.m_6299_(RenderType.m_110458_((ResourceLocation)texture)), light, OverlayTexture.f_118083_, red, green, blue, 1.0f);
    }
}

