/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.beachparty.forge.client.renderer.player.layers;

import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.satisfy.beachparty.client.model.TrunksModel;
import net.satisfy.beachparty.core.item.DyeableBeachpartyArmorItem;
import net.satisfy.beachparty.core.registry.ObjectRegistry;
import net.satisfy.beachparty.core.util.BeachpartyIdentifier;
import org.jetbrains.annotations.NotNull;
import top.theillusivec4.curios.api.CuriosApi;

public class TrunksLayer<T extends LivingEntity, M extends HumanoidModel<T>>
extends RenderLayer<T, M> {
    private final TrunksModel<T> model = new TrunksModel(Minecraft.m_91087_().m_167973_().m_171103_(TrunksModel.LAYER_LOCATION));

    public TrunksLayer(RenderLayerParent<T, M> renderLayerParent) {
        super(renderLayerParent);
    }

    public void render(@NotNull PoseStack poseStack, @NotNull MultiBufferSource multiBufferSource, int i, @NotNull T entity, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        DyeableBeachpartyArmorItem item;
        this.model.m_6973_(entity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
        ItemStack[] trunks = new ItemStack[]{ItemStack.f_41583_};
        boolean[] inCurioSlot = new boolean[]{false};
        CuriosApi.getCuriosInventory(entity).ifPresent(curios -> {
            if (curios.isEquipped((Item)ObjectRegistry.TRUNKS.get())) {
                curios.findFirstCurio(stack -> stack.m_150930_((Item)ObjectRegistry.TRUNKS.get())).ifPresent(curio -> {
                    inCurioSlot[0] = true;
                    trunks[0] = curio.stack();
                });
            }
        });
        boolean inLegsSlot = entity.m_6844_(EquipmentSlot.LEGS).m_150930_((Item)ObjectRegistry.TRUNKS.get());
        if (inLegsSlot) {
            trunks[0] = entity.m_6844_(EquipmentSlot.LEGS);
        }
        if (!inCurioSlot[0] && !inLegsSlot) {
            return;
        }
        if (trunks[0].m_41782_()) {
            assert (trunks[0].m_41783_() != null);
            if (trunks[0].m_41783_().m_128441_("Visible") && !trunks[0].m_41783_().m_128471_("Visible")) {
                return;
            }
        }
        DyeableBeachpartyArmorItem dyeableBeachpartyArmorItem = item = trunks[0].m_41720_() instanceof DyeableBeachpartyArmorItem ? (DyeableBeachpartyArmorItem)trunks[0].m_41720_() : null;
        if (item == null) {
            return;
        }
        int colorInt = item.m_41121_(trunks[0]);
        float red = (float)(colorInt >> 16 & 0xFF) / 255.0f;
        float green = (float)(colorInt >> 8 & 0xFF) / 255.0f;
        float blue = (float)(colorInt & 0xFF) / 255.0f;
        poseStack.m_85836_();
        TrunksLayer.m_117376_(this.model, (ResourceLocation)this.getTextureLocation(entity), (PoseStack)poseStack, (MultiBufferSource)multiBufferSource, (int)i, entity, (float)red, (float)green, (float)blue);
        poseStack.m_85849_();
    }

    @NotNull
    protected ResourceLocation getTextureLocation(@NotNull T entity) {
        return new BeachpartyIdentifier("textures/models/armor/trunks.png");
    }
}

