/*
 * Decompiled with CFR 0.152.
 */
package com.github.eterdelta.crittersandcompanions.network;

import com.github.eterdelta.crittersandcompanions.entity.GrapplingHookEntity;
import com.github.eterdelta.crittersandcompanions.extension.IGrapplingState;
import com.github.eterdelta.crittersandcompanions.network.IPacketHandler;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.player.Player;

public record ClientboundGrapplingStatePacket(Optional<Integer> hook, int playerId) {

    public static class Handler
    implements IPacketHandler<ClientboundGrapplingStatePacket> {
        @Override
        public ClientboundGrapplingStatePacket read(FriendlyByteBuf byteBuf) {
            return new ClientboundGrapplingStatePacket(byteBuf.m_236860_(FriendlyByteBuf::readInt), byteBuf.readInt());
        }

        @Override
        public void write(ClientboundGrapplingStatePacket packet, FriendlyByteBuf byteBuf) {
            byteBuf.m_236835_(packet.hook, FriendlyByteBuf::writeInt);
            byteBuf.writeInt(packet.playerId);
        }

        @Override
        public void handle(ClientboundGrapplingStatePacket packet) {
            Player player = (Player)Minecraft.m_91087_().f_91073_.m_6815_(packet.playerId);
            if (player instanceof IGrapplingState) {
                IGrapplingState grappleState = (IGrapplingState)player;
                GrapplingHookEntity grapplingHook = packet.hook.map(id -> (GrapplingHookEntity)Minecraft.m_91087_().f_91073_.m_6815_(id.intValue())).orElse(null);
                grappleState.setHook(grapplingHook);
            }
        }
    }
}

